/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.menus;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.sourceforge.atunes.gui.views.menus.PlayListMenu;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.AddPodcastFeedAction;
import net.sourceforge.atunes.kernel.actions.AddRadioAction;
import net.sourceforge.atunes.kernel.actions.CheckUpdatesAction;
import net.sourceforge.atunes.kernel.actions.CollapseTreesAction;
import net.sourceforge.atunes.kernel.actions.ConnectDeviceAction;
import net.sourceforge.atunes.kernel.actions.CustomSearchAction;
import net.sourceforge.atunes.kernel.actions.DisconnectDeviceAction;
import net.sourceforge.atunes.kernel.actions.EditPreferencesAction;
import net.sourceforge.atunes.kernel.actions.ExitAction;
import net.sourceforge.atunes.kernel.actions.ExpandTreesAction;
import net.sourceforge.atunes.kernel.actions.ExportAction;
import net.sourceforge.atunes.kernel.actions.FullScreenAction;
import net.sourceforge.atunes.kernel.actions.GoToWebSiteAction;
import net.sourceforge.atunes.kernel.actions.GoToWikiAction;
import net.sourceforge.atunes.kernel.actions.ImportLovedTracksFromLastFMAction;
import net.sourceforge.atunes.kernel.actions.ImportToRepositoryAction;
import net.sourceforge.atunes.kernel.actions.MuteAction;
import net.sourceforge.atunes.kernel.actions.OSDSettingAction;
import net.sourceforge.atunes.kernel.actions.RefreshDeviceAction;
import net.sourceforge.atunes.kernel.actions.RefreshRepositoryAction;
import net.sourceforge.atunes.kernel.actions.RepairAlbumNamesAction;
import net.sourceforge.atunes.kernel.actions.RepairGenresAction;
import net.sourceforge.atunes.kernel.actions.RepairTrackNumbersAction;
import net.sourceforge.atunes.kernel.actions.ReportBugOrFeatureRequestAction;
import net.sourceforge.atunes.kernel.actions.RipCDAction;
import net.sourceforge.atunes.kernel.actions.SelectRepositoryAction;
import net.sourceforge.atunes.kernel.actions.ShowAboutAction;
import net.sourceforge.atunes.kernel.actions.ShowAlbumsInNavigatorAction;
import net.sourceforge.atunes.kernel.actions.ShowArtistsInNavigatorAction;
import net.sourceforge.atunes.kernel.actions.ShowAudioObjectPropertiesAction;
import net.sourceforge.atunes.kernel.actions.ShowContextAction;
import net.sourceforge.atunes.kernel.actions.ShowCoverNavigatorAction;
import net.sourceforge.atunes.kernel.actions.ShowEqualizerAction;
import net.sourceforge.atunes.kernel.actions.ShowFoldersInNavigatorAction;
import net.sourceforge.atunes.kernel.actions.ShowGenresInNavigatorAction;
import net.sourceforge.atunes.kernel.actions.ShowLogAction;
import net.sourceforge.atunes.kernel.actions.ShowNavigationTableAction;
import net.sourceforge.atunes.kernel.actions.ShowNavigationTreeAction;
import net.sourceforge.atunes.kernel.actions.ShowPlayListControlsAction;
import net.sourceforge.atunes.kernel.actions.ShowRadioBrowserAction;
import net.sourceforge.atunes.kernel.actions.ShowStatsAction;
import net.sourceforge.atunes.kernel.actions.ShowStatusBarAction;
import net.sourceforge.atunes.kernel.actions.ShowToolbarAction;
import net.sourceforge.atunes.kernel.actions.ShowYearsInNavigatorAction;
import net.sourceforge.atunes.kernel.actions.VolumeDownAction;
import net.sourceforge.atunes.kernel.actions.VolumeUpAction;
import net.sourceforge.atunes.kernel.modules.navigator.AbstractNavigationView;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.player.PlayerEngineCapability;
import net.sourceforge.atunes.kernel.modules.player.PlayerHandler;
import net.sourceforge.atunes.utils.I18nUtils;

public final class ApplicationMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 234977404080329591L;
    private JMenu file;
    private JMenu edit;
    private JMenu view;
    private JMenu navigator;
    private JMenu playList;
    private JMenu tools;
    private JMenu device;
    private JMenu help;

    public ApplicationMenuBar() {
        this.addMenus();
    }

    private JMenu getFileMenu() {
        if (this.file == null) {
            this.file = new JMenu(I18nUtils.getString("FILE"));
            this.file.add(Actions.getAction(SelectRepositoryAction.class));
            this.file.add(Actions.getAction(RefreshRepositoryAction.class));
            this.file.add(new JSeparator());
            this.file.add(Actions.getAction(ImportToRepositoryAction.class));
            this.file.add(Actions.getAction(ExportAction.class));
            this.file.add(new JSeparator());
            this.file.add(Actions.getAction(ExitAction.class));
        }
        return this.file;
    }

    private JMenu getEditMenu() {
        if (this.edit == null) {
            this.edit = new JMenu(I18nUtils.getString("EDIT"));
            JMenu jMenu = new JMenu(I18nUtils.getString("VOLUME"));
            JMenuItem jMenuItem = new JMenuItem(Actions.getAction(ShowEqualizerAction.class));
            jMenu.add(jMenuItem);
            if (!PlayerHandler.getInstance().supportsCapability(PlayerEngineCapability.EQUALIZER)) {
                jMenuItem.setEnabled(false);
            }
            jMenu.add(Actions.getAction(VolumeUpAction.class));
            jMenu.add(Actions.getAction(VolumeDownAction.class));
            jMenu.add(new JCheckBoxMenuItem(Actions.getAction(MuteAction.class)));
            JMenu jMenu2 = new JMenu(I18nUtils.getString("REPAIR"));
            jMenu2.add(Actions.getAction(RepairTrackNumbersAction.class));
            jMenu2.add(Actions.getAction(RepairGenresAction.class));
            jMenu2.add(Actions.getAction(RepairAlbumNamesAction.class));
            this.edit.add(jMenu);
            this.edit.add(Actions.getAction(EditPreferencesAction.class));
            this.edit.add(new JSeparator());
            this.edit.add(jMenu2);
        }
        return this.edit;
    }

    private JMenu getViewMenu() {
        if (this.view == null) {
            this.view = new JMenu(I18nUtils.getString("VIEW"));
            int n = 1;
            for (AbstractNavigationView abstractNavigationView : NavigationHandler.getInstance().getNavigationViews()) {
                this.view.add(abstractNavigationView.getActionToShowView(n++));
            }
            this.view.add(new JSeparator());
            this.view.add(new JCheckBoxMenuItem(Actions.getAction(ShowToolbarAction.class)));
            this.view.add(new JCheckBoxMenuItem(Actions.getAction(ShowStatusBarAction.class)));
            this.view.add(new JCheckBoxMenuItem(Actions.getAction(ShowPlayListControlsAction.class)));
            this.view.add(new JCheckBoxMenuItem(Actions.getAction(ShowNavigationTreeAction.class)));
            this.view.add(new JCheckBoxMenuItem(Actions.getAction(ShowNavigationTableAction.class)));
            this.view.add(new JCheckBoxMenuItem(Actions.getAction(ShowAudioObjectPropertiesAction.class)));
            this.view.add(new JCheckBoxMenuItem(Actions.getAction(ShowContextAction.class)));
            this.view.add(new JCheckBoxMenuItem(Actions.getAction(OSDSettingAction.class)));
            this.view.add(new JSeparator());
            this.view.add(Actions.getAction(FullScreenAction.class));
        }
        return this.view;
    }

    private JMenu getNavigatorMenu() {
        if (this.navigator == null) {
            this.navigator = new JMenu(I18nUtils.getString("NAVIGATOR"));
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(Actions.getAction(ShowArtistsInNavigatorAction.class));
            JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(Actions.getAction(ShowAlbumsInNavigatorAction.class));
            JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(Actions.getAction(ShowGenresInNavigatorAction.class));
            JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem(Actions.getAction(ShowYearsInNavigatorAction.class));
            JRadioButtonMenuItem jRadioButtonMenuItem5 = new JRadioButtonMenuItem(Actions.getAction(ShowFoldersInNavigatorAction.class));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem2);
            buttonGroup.add(jRadioButtonMenuItem3);
            buttonGroup.add(jRadioButtonMenuItem4);
            buttonGroup.add(jRadioButtonMenuItem5);
            this.navigator.add(jRadioButtonMenuItem);
            this.navigator.add(jRadioButtonMenuItem2);
            this.navigator.add(jRadioButtonMenuItem3);
            this.navigator.add(jRadioButtonMenuItem4);
            this.navigator.add(jRadioButtonMenuItem5);
            this.navigator.add(new JSeparator());
            this.navigator.add(Actions.getAction(ExpandTreesAction.class));
            this.navigator.add(Actions.getAction(CollapseTreesAction.class));
        }
        return this.navigator;
    }

    private JMenu getPlayListMenu() {
        if (this.playList == null) {
            this.playList = new JMenu(I18nUtils.getString("PLAYLIST"));
            PlayListMenu.fillMenu(this.playList, ControllerProxy.getInstance().getPlayListController().getMainPlayListTable());
            this.playList.addMenuListener(new PlayListMenuListener());
        }
        return this.playList;
    }

    private JMenu getToolsMenu() {
        if (this.tools == null) {
            this.tools = new JMenu(I18nUtils.getString("TOOLS"));
            this.tools.add(Actions.getAction(RipCDAction.class));
            this.tools.add(new JSeparator());
            this.tools.add(Actions.getAction(ShowStatsAction.class));
            this.tools.add(Actions.getAction(ShowCoverNavigatorAction.class));
            this.tools.add(new JSeparator());
            this.tools.add(Actions.getAction(AddRadioAction.class));
            this.tools.add(Actions.getAction(ShowRadioBrowserAction.class));
            this.tools.add(Actions.getAction(AddPodcastFeedAction.class));
            this.tools.add(new JSeparator());
            this.tools.add(Actions.getAction(CustomSearchAction.class));
            this.tools.add(new JSeparator());
            this.tools.add(Actions.getAction(ImportLovedTracksFromLastFMAction.class));
        }
        return this.tools;
    }

    private JMenu getDeviceMenu() {
        if (this.device == null) {
            this.device = new JMenu(I18nUtils.getString("DEVICE"));
            this.device.add(Actions.getAction(ConnectDeviceAction.class));
            this.device.add(Actions.getAction(RefreshDeviceAction.class));
            this.device.add(Actions.getAction(DisconnectDeviceAction.class));
        }
        return this.device;
    }

    private JMenu getCustomHelpMenu() {
        if (this.help == null) {
            this.help = new JMenu(I18nUtils.getString("HELP"));
            this.help.add(Actions.getAction(GoToWebSiteAction.class));
            this.help.add(Actions.getAction(GoToWikiAction.class));
            this.help.add(Actions.getAction(ReportBugOrFeatureRequestAction.class));
            this.help.add(new JSeparator());
            this.help.add(Actions.getAction(ShowLogAction.class));
            this.help.add(Actions.getAction(CheckUpdatesAction.class));
            this.help.add(new JSeparator());
            this.help.add(Actions.getAction(ShowAboutAction.class));
        }
        return this.help;
    }

    private void addMenus() {
        this.add(this.getFileMenu());
        this.add(this.getEditMenu());
        this.add(this.getViewMenu());
        this.add(this.getNavigatorMenu());
        this.add(this.getPlayListMenu());
        this.add(this.getDeviceMenu());
        this.add(this.getToolsMenu());
        this.add(this.getCustomHelpMenu());
    }

    public void addMenu(JMenu jMenu) {
        this.remove(this.getComponentCount() - 1);
        this.add(jMenu);
        this.add(this.getCustomHelpMenu());
    }

    private static class PlayListMenuListener
    implements MenuListener {
        private PlayListMenuListener() {
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            PlayListMenu.updatePlayListMenuItems(ControllerProxy.getInstance().getPlayListController().getMainPlayListTable());
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }
    }
}

