/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractActionOverSelectedObjects;
import net.sourceforge.atunes.kernel.modules.device.DeviceHandler;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.navigator.PodcastNavigationView;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class CopyToDeviceAction
extends AbstractActionOverSelectedObjects<AudioObject> {
    private static final long serialVersionUID = -7689483210176624995L;

    CopyToDeviceAction() {
        super(I18nUtils.getString("COPY_TO_DEVICE"), Images.getImage("device.png"), AudioObject.class);
        this.putValue("ShortDescription", I18nUtils.getString("COPY_TO_DEVICE"));
    }

    @Override
    protected AudioObject preprocessObject(AudioObject audioObject) {
        if (audioObject instanceof AudioFile) {
            return audioObject;
        }
        if (audioObject instanceof PodcastFeedEntry && ((PodcastFeedEntry)audioObject).isDownloaded()) {
            String string = PodcastFeedHandler.getInstance().getDownloadPath((PodcastFeedEntry)audioObject);
            return new AudioFile(string);
        }
        return null;
    }

    @Override
    protected void performAction(List<AudioObject> list) {
        DeviceHandler.getInstance().copyFilesToDevice(AudioFile.getAudioFiles(list));
    }

    @Override
    public boolean isEnabledForNavigationTreeSelection(boolean bl, List<DefaultMutableTreeNode> list) {
        return DeviceHandler.getInstance().isDeviceConnected() && !bl && !list.isEmpty();
    }

    @Override
    public boolean isEnabledForNavigationTableSelection(List<AudioObject> list) {
        if (!DeviceHandler.getInstance().isDeviceConnected()) {
            return false;
        }
        if (NavigationHandler.getInstance().getCurrentView().equals(NavigationHandler.getInstance().getView(PodcastNavigationView.class))) {
            for (AudioObject audioObject : list) {
                if (((PodcastFeedEntry)audioObject).isDownloaded()) continue;
                return false;
            }
            return true;
        }
        return !list.isEmpty();
    }
}

