/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.AbstractActionOverSelectedObjects;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class EditTagAction
extends AbstractActionOverSelectedObjects<AudioFile> {
    private static final long serialVersionUID = -4310895355731333072L;
    private Logger logger;

    EditTagAction() {
        super(I18nUtils.getString("EDIT_TAG"), Images.getImage("tag.png"), AudioFile.class);
        this.putValue("ShortDescription", I18nUtils.getString("EDIT_TAG"));
    }

    @Override
    protected void initialize() {
        if (EditTagSources.PLAYLIST.toString().equals(this.getActionId())) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(155, 0));
        }
    }

    @Override
    protected void performAction(List<AudioFile> list) {
        try {
            EditTagSources editTagSources = EditTagSources.valueOf(this.getActionId());
            ControllerProxy.getInstance().getEditTagDialogController(editTagSources).editFiles(list);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.getLogger().error("The source that caused this action is not known. No further action initiated.", illegalArgumentException);
        }
        catch (NullPointerException nullPointerException) {
            this.getLogger().error("The source that caused this action is not set. No further action initiated.", nullPointerException);
        }
    }

    @Override
    public boolean isEnabledForNavigationTreeSelection(boolean bl, List<DefaultMutableTreeNode> list) {
        if (EditTagSources.NAVIGATOR.toString().equals(this.getActionId())) {
            return !bl && !list.isEmpty();
        }
        return super.isEnabledForNavigationTreeSelection(bl, list);
    }

    @Override
    public boolean isEnabledForNavigationTableSelection(List<AudioObject> list) {
        if (EditTagSources.NAVIGATOR.toString().equals(this.getActionId())) {
            return !list.isEmpty();
        }
        return super.isEnabledForNavigationTableSelection(list);
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    public static enum EditTagSources {
        PLAYLIST,
        NAVIGATOR;

    }
}

