/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingWorker;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.favorites.FavoritesHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.data.LastFmLovedTrack;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class ImportLovedTracksFromLastFMAction
extends AbstractAction {
    private static final long serialVersionUID = 5620935204300321285L;

    ImportLovedTracksFromLastFMAction() {
        super(I18nUtils.getString("IMPORT_LOVED_TRACKS_FROM_LASTFM"));
        this.setEnabled(ApplicationState.getInstance().isLastFmEnabled());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ImportLovedTracksWorker importLovedTracksWorker = new ImportLovedTracksWorker();
        GuiHandler.getInstance().showIndeterminateProgressDialog(I18nUtils.getString("GETTING_LOVED_TRACKS_FROM_LASTFM"));
        importLovedTracksWorker.execute();
    }

    private static class ImportLovedTracksWorker
    extends SwingWorker<List<AudioFile>, Void> {
        private ImportLovedTracksWorker() {
        }

        @Override
        protected List<AudioFile> doInBackground() throws Exception {
            List<LastFmLovedTrack> list = LastFmService.getInstance().getLovedTracks();
            if (!list.isEmpty()) {
                ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>();
                for (LastFmLovedTrack lastFmLovedTrack : list) {
                    Artist artist = RepositoryHandler.getInstance().getArtistStructure().get(lastFmLovedTrack.getArtist());
                    if (artist == null) continue;
                    for (AudioFile audioFile : artist.getAudioFiles()) {
                        if (!audioFile.getTitleOrFileName().equalsIgnoreCase(lastFmLovedTrack.getTitle())) continue;
                        arrayList.add(audioFile);
                    }
                }
                return arrayList;
            }
            return Collections.emptyList();
        }

        @Override
        protected void done() {
            GuiHandler.getInstance().hideIndeterminateProgressDialog();
            List list = null;
            try {
                list = (List)this.get();
                FavoritesHandler.getInstance().addFavoriteSongs(list);
            }
            catch (Exception exception) {
                // empty catch block
            }
            GuiHandler.getInstance().showMessage(StringUtils.getString(I18nUtils.getString("LOVED_TRACKS_IMPORTED"), ": ", list == null ? "0" : Integer.valueOf(list.size())));
        }
    }
}

