/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.model.NavigationTableModel;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.navigator.FavoritesNavigationView;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.favorites.FavoritesHandler;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.TreeObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class RemoveFromFavoritesAction
extends AbstractAction {
    private static final long serialVersionUID = -4288879781314486222L;

    public RemoveFromFavoritesAction() {
        super(I18nUtils.getString("REMOVE_FROM_FAVORITES"), Images.getImage("erase.png"));
        this.putValue("ShortDescription", I18nUtils.getString("REMOVE_FROM_FAVORITES"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (ControllerProxy.getInstance().getNavigationController().getPopupMenuCaller() == NavigationHandler.getInstance().getView(FavoritesNavigationView.class).getTree()) {
            TreePath[] treePathArray = NavigationHandler.getInstance().getView(FavoritesNavigationView.class).getTree().getSelectionPaths();
            if (treePathArray != null) {
                ArrayList<TreeObject> arrayList = new ArrayList<TreeObject>();
                for (TreePath treePath : treePathArray) {
                    arrayList.add((TreeObject)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject());
                }
                FavoritesHandler.getInstance().removeFromFavorites(arrayList);
            }
        } else {
            int[] nArray = ControllerProxy.getInstance().getNavigationController().getNavigationTablePanel().getNavigationTable().getSelectedRows();
            if (nArray.length > 0) {
                List<AudioObject> list = ((NavigationTableModel)ControllerProxy.getInstance().getNavigationController().getNavigationTablePanel().getNavigationTable().getModel()).getAudioObjectsAt(nArray);
                FavoritesHandler.getInstance().removeSongsFromFavorites(list);
            }
        }
    }

    @Override
    public boolean isEnabledForNavigationTreeSelection(boolean bl, List<DefaultMutableTreeNode> list) {
        for (DefaultMutableTreeNode defaultMutableTreeNode : list) {
            Object[] objectArray;
            if (!(defaultMutableTreeNode.getUserObject() instanceof Album)) continue;
            for (Object object : objectArray = defaultMutableTreeNode.getUserObjectPath()) {
                if (!(object instanceof Artist)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isEnabledForNavigationTableSelection(List<AudioObject> list) {
        return FavoritesHandler.getInstance().getFavoriteSongsInfo().values().containsAll(AudioFile.getAudioFiles(list));
    }
}

