/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.AbstractActionOverSelectedObjects;
import net.sourceforge.atunes.kernel.controllers.navigation.NavigationController;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.favorites.FavoritesHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.I18nUtils;

public class SetFavoriteArtistFromNavigatorAction
extends AbstractActionOverSelectedObjects<AudioFile> {
    private static final long serialVersionUID = -3551889307264609825L;

    SetFavoriteArtistFromNavigatorAction() {
        super(I18nUtils.getString("SET_FAVORITE_ARTIST"), Images.getImage("favorite.png"), AudioFile.class);
        this.putValue("ShortDescription", I18nUtils.getString("SET_FAVORITE_ARTIST"));
    }

    @Override
    protected void performAction(List<AudioFile> list) {
        FavoritesHandler.getInstance().addFavoriteArtists(list);
        ControllerProxy.getInstance().getNavigationController().refreshTable();
    }

    @Override
    public boolean isEnabledForNavigationTreeSelection(boolean bl, List<DefaultMutableTreeNode> list) {
        if (list.isEmpty()) {
            return false;
        }
        if (ApplicationState.getInstance().getViewMode() == NavigationController.ViewMode.FOLDER) {
            return false;
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode : list) {
            if (defaultMutableTreeNode.getUserObject() instanceof Artist) continue;
            return false;
        }
        return true;
    }
}

