/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.coverNavigator;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.atunes.Constants;
import net.sourceforge.atunes.gui.views.dialogs.CoverNavigatorFrame;
import net.sourceforge.atunes.kernel.controllers.model.AbstractSimpleController;
import net.sourceforge.atunes.kernel.modules.process.ProcessListener;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.GetCoversProcess;
import net.sourceforge.atunes.utils.GuiUtils;
import org.jdesktop.swingx.border.DropShadowBorder;

public final class CoverNavigatorController
extends AbstractSimpleController<CoverNavigatorFrame> {
    private static final int COVER_PANEL_WIDTH = Constants.COVER_NAVIGATOR_IMAGE_SIZE.getSize() + 20;
    private static final int COVER_PANEL_HEIGHT = Constants.COVER_NAVIGATOR_IMAGE_SIZE.getSize() + 40;

    public CoverNavigatorController(CoverNavigatorFrame coverNavigatorFrame) {
        super(coverNavigatorFrame);
        this.addBindings();
    }

    @Override
    protected void addBindings() {
        CoverNavigatorFrame coverNavigatorFrame = (CoverNavigatorFrame)this.getComponentControlled();
        coverNavigatorFrame.getList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!((JList)listSelectionEvent.getSource()).getValueIsAdjusting()) {
                    CoverNavigatorController.this.updateCovers();
                }
            }
        });
        coverNavigatorFrame.getCoversButton().addActionListener(new GetCoversButtonActionListener(coverNavigatorFrame));
    }

    @Override
    protected void addStateBindings() {
    }

    JPanel getPanelForAlbum(Album album, ImageIcon imageIcon) {
        JPanel jPanel = new JPanel(new FlowLayout());
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setToolTipText(album.getName());
        if (imageIcon == null) {
            jLabel.setPreferredSize(new Dimension(Constants.COVER_NAVIGATOR_IMAGE_SIZE.getSize(), Constants.COVER_NAVIGATOR_IMAGE_SIZE.getSize()));
            jLabel.setBorder(BorderFactory.createLineBorder(GuiUtils.getBorderColor()));
        } else {
            jLabel.setBorder((Border)new DropShadowBorder());
        }
        JLabel jLabel2 = new JLabel(album.getName(), 0);
        jLabel2.setPreferredSize(new Dimension(Constants.COVER_NAVIGATOR_IMAGE_SIZE.getSize(), 20));
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        jPanel.setPreferredSize(new Dimension(COVER_PANEL_WIDTH, COVER_PANEL_HEIGHT));
        GuiUtils.applyComponentOrientation(jPanel);
        return jPanel;
    }

    @Override
    protected void notifyReload() {
    }

    public void updateCovers() {
        Artist artist = (Artist)((CoverNavigatorFrame)this.getComponentControlled()).getList().getSelectedValue();
        if (artist == null) {
            return;
        }
        ((CoverNavigatorFrame)this.getComponentControlled()).getCoversPanel().removeAll();
        ((CoverNavigatorFrame)this.getComponentControlled()).getList().setEnabled(false);
        ((CoverNavigatorFrame)this.getComponentControlled()).getCoversButton().setEnabled(false);
        ((CoverNavigatorFrame)this.getComponentControlled()).setCursor(Cursor.getPredefinedCursor(3));
        GenerateAndShowAlbumPanelsSwingWorker generateAndShowAlbumPanelsSwingWorker = new GenerateAndShowAlbumPanelsSwingWorker(artist);
        generateAndShowAlbumPanelsSwingWorker.execute();
    }

    private static class IntermediateResult {
        private Album album;
        private ImageIcon cover;

        public IntermediateResult(Album album, ImageIcon imageIcon) {
            this.album = album;
            this.cover = imageIcon;
        }

        public Album getAlbum() {
            return this.album;
        }

        public ImageIcon getCover() {
            return this.cover;
        }
    }

    private final class GetCoversButtonActionListener
    implements ActionListener {
        private final CoverNavigatorFrame frame;

        private GetCoversButtonActionListener(CoverNavigatorFrame coverNavigatorFrame) {
            this.frame = coverNavigatorFrame;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Artist artist = (Artist)this.frame.getList().getSelectedValue();
            if (artist != null) {
                GetCoversProcess getCoversProcess = new GetCoversProcess(artist, (Component)CoverNavigatorController.this.getComponentControlled());
                getCoversProcess.addProcessListener(new GetCoversProcessListener());
                getCoversProcess.execute();
            }
        }

        private final class GetCoversProcessListener
        implements ProcessListener {
            private GetCoversProcessListener() {
            }

            @Override
            public void processCanceled() {
                this.update();
            }

            @Override
            public void processFinished(boolean bl) {
                this.update();
            }

            private void update() {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            CoverNavigatorController.this.updateCovers();
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private final class GenerateAndShowAlbumPanelsSwingWorker
    extends SwingWorker<Void, IntermediateResult> {
        private final Artist artistSelected;

        private GenerateAndShowAlbumPanelsSwingWorker(Artist artist) {
            this.artistSelected = artist;
        }

        @Override
        protected Void doInBackground() throws Exception {
            ArrayList<Album> arrayList = new ArrayList<Album>(this.artistSelected.getAlbums().values());
            Collections.sort(arrayList);
            int n = 0;
            for (Album album : arrayList) {
                ImageIcon imageIcon = album.getPicture(Constants.COVER_NAVIGATOR_IMAGE_SIZE);
                this.publish(new IntermediateResult(album, imageIcon));
                ++n;
            }
            return null;
        }

        @Override
        protected void done() {
            ((CoverNavigatorFrame)CoverNavigatorController.this.getComponentControlled()).setCursor(Cursor.getDefaultCursor());
            ((CoverNavigatorFrame)CoverNavigatorController.this.getComponentControlled()).getList().setEnabled(true);
            ((CoverNavigatorFrame)CoverNavigatorController.this.getComponentControlled()).getCoversButton().setEnabled(true);
        }

        @Override
        protected void process(List<IntermediateResult> list) {
            for (IntermediateResult intermediateResult : list) {
                ((CoverNavigatorFrame)CoverNavigatorController.this.getComponentControlled()).getCoversPanel().add(CoverNavigatorController.this.getPanelForAlbum(intermediateResult.getAlbum(), intermediateResult.getCover()));
                ((CoverNavigatorFrame)CoverNavigatorController.this.getComponentControlled()).getCoversPanel().revalidate();
                ((CoverNavigatorFrame)CoverNavigatorController.this.getComponentControlled()).getCoversPanel().repaint();
                ((CoverNavigatorFrame)CoverNavigatorController.this.getComponentControlled()).getCoversPanel().validate();
            }
        }
    }
}

