/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.filter;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.atunes.gui.views.panels.ToolBarFilterPanel;
import net.sourceforge.atunes.kernel.controllers.model.AbstractSimpleController;
import net.sourceforge.atunes.kernel.modules.filter.AbstractFilter;
import net.sourceforge.atunes.kernel.modules.filter.FilterHandler;

public class ToolBarFilterController
extends AbstractSimpleController<ToolBarFilterPanel> {
    private ButtonGroup group;
    private Map<String, JRadioButtonMenuItem> filters;

    public ToolBarFilterController(ToolBarFilterPanel toolBarFilterPanel) {
        super(toolBarFilterPanel);
        this.addBindings();
        this.group = new ButtonGroup();
        this.filters = new HashMap<String, JRadioButtonMenuItem>();
    }

    @Override
    protected void addBindings() {
        ((ToolBarFilterPanel)this.getComponentControlled()).getFilterTextField().getDocument().addDocumentListener(new FilterTextFieldDocumentListener());
        ((ToolBarFilterPanel)this.getComponentControlled()).getClearFilterButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((ToolBarFilterPanel)ToolBarFilterController.this.getComponentControlled()).getFilterTextField().setText(null);
                        ToolBarFilterController.this.applyFilter(ToolBarFilterController.this.getFilter());
                    }
                });
            }
        });
    }

    @Override
    protected void addStateBindings() {
    }

    @Override
    protected void notifyReload() {
    }

    public void addFilter(final AbstractFilter abstractFilter) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(abstractFilter.getDescription());
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToolBarFilterController.this.applyFilter(null);
                FilterHandler.getInstance().setSelectedFilter(abstractFilter.getName());
                ToolBarFilterController.this.applyFilter(ToolBarFilterController.this.getFilter());
            }
        });
        this.filters.put(abstractFilter.getName(), jRadioButtonMenuItem);
        this.group.add(jRadioButtonMenuItem);
        ((ToolBarFilterPanel)this.getComponentControlled()).getFilterButton().add(jRadioButtonMenuItem);
    }

    public void removeFilter(String string) {
        JRadioButtonMenuItem jRadioButtonMenuItem = this.filters.get(string);
        this.filters.remove(string);
        this.group.remove(jRadioButtonMenuItem);
        ((ToolBarFilterPanel)this.getComponentControlled()).getFilterButton().remove(jRadioButtonMenuItem);
    }

    public void setSelectedFilter(String string) {
        this.filters.get(string).setSelected(true);
    }

    private void applyFilter(String string) {
        FilterHandler.getInstance().applyFilter(string);
    }

    public String getFilter() {
        String string = ((ToolBarFilterPanel)this.getComponentControlled()).getFilterTextField().getText();
        return string.trim().equals("") ? null : string;
    }

    public void setFilterEnabled(String string, boolean bl) {
        JRadioButtonMenuItem jRadioButtonMenuItem = this.filters.get(string);
        if (jRadioButtonMenuItem != null) {
            jRadioButtonMenuItem.setEnabled(bl);
        }
    }

    private final class FilterTextFieldDocumentListener
    implements DocumentListener {
        private FilterTextFieldDocumentListener() {
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        private void update() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ToolBarFilterController.this.applyFilter(ToolBarFilterController.this.getFilter());
                }
            });
        }
    }
}

