/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.stats;

import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import net.sourceforge.atunes.gui.Fonts;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTableCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.gui.views.dialogs.StatsDialog;
import net.sourceforge.atunes.kernel.controllers.model.AbstractSimpleController;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.statistics.StatisticsHandler;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleInsets;

public final class StatsDialogController
extends AbstractSimpleController<StatsDialog> {
    public StatsDialogController(StatsDialog statsDialog) {
        super(statsDialog);
    }

    @Override
    protected void addBindings() {
    }

    @Override
    protected void addStateBindings() {
    }

    private DefaultCategoryDataset getDataSet(List<?> list) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Object[] objectArray = (Object[])list.get(i);
                defaultCategoryDataset.setValue((Number)((Integer)objectArray[1]), (Comparable)((Object)""), (Comparable)((Object)((String)objectArray[0])));
            }
        }
        return defaultCategoryDataset;
    }

    @Override
    protected void notifyReload() {
    }

    private void setAlbumsChart() {
        DefaultCategoryDataset defaultCategoryDataset = this.getDataSet(this.getMostPlayedAlbumsInRanking(10));
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart3D((String)I18nUtils.getString("ALBUM_MOST_PLAYED"), null, null, (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
        jFreeChart.getTitle().setFont(Fonts.getChartTitleFont());
        jFreeChart.setBackgroundPaint((Paint)Color.WHITE);
        jFreeChart.setPadding(new RectangleInsets(5.0, 0.0, 0.0, 0.0));
        NumberAxis numberAxis = new NumberAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setTickLabelFont(Fonts.getChartTickLabelFont());
        jFreeChart.setBackgroundPaint((Paint)GuiUtils.getBackgroundColor());
        jFreeChart.getTitle().setPaint((Paint)GuiUtils.getForegroundColor());
        jFreeChart.getCategoryPlot().setRangeAxis((ValueAxis)numberAxis);
        jFreeChart.getCategoryPlot().setForegroundAlpha(1.0f);
        jFreeChart.getCategoryPlot().getRenderer().setSeriesPaint(0, (Paint)Color.GREEN);
        jFreeChart.getCategoryPlot().getDomainAxis().setTickLabelFont(Fonts.getChartTickLabelFont());
        jFreeChart.getCategoryPlot().getDomainAxis().setTickLabelPaint((Paint)GuiUtils.getForegroundColor());
        jFreeChart.getCategoryPlot().getRangeAxis().setTickLabelFont(Fonts.getChartTickLabelFont());
        jFreeChart.getCategoryPlot().getRangeAxis().setTickLabelPaint((Paint)GuiUtils.getForegroundColor());
        jFreeChart.getPlot().setBackgroundPaint((Paint)GuiUtils.getBackgroundColor());
        ((StatsDialog)this.getComponentControlled()).getAlbumsChart().setIcon(new ImageIcon(jFreeChart.createBufferedImage(710, 250)));
    }

    private void setAlbumsTable() {
        List<Object[]> list = this.getMostPlayedAlbumsInRanking(-1);
        if (list != null) {
            Object[] objectArray = new String[]{I18nUtils.getString("ALBUM"), I18nUtils.getString("TIMES_PLAYED"), "%"};
            Object[][] objectArray2 = new Object[list.size()][3];
            for (int i = 0; i < list.size(); ++i) {
                objectArray2[i][0] = list.get(i)[0];
                objectArray2[i][1] = list.get(i)[1];
                objectArray2[i][2] = StatisticsHandler.getInstance().getTotalAudioFilesPlayed() != -1 ? StringUtils.toString(100.0 * (double)((Integer)list.get(i)[1]).intValue() / (double)StatisticsHandler.getInstance().getTotalAudioFilesPlayed(), 2) : Integer.valueOf(0);
            }
            this.setTable(((StatsDialog)this.getComponentControlled()).getAlbumsTable(), objectArray, objectArray2);
        }
    }

    private List<Object[]> getMostPlayedAlbumsInRanking(int n) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        List<Album> list = StatisticsHandler.getInstance().getMostPlayedAlbums(n);
        List<Integer> list2 = StatisticsHandler.getInstance().getMostPlayedAlbumsCount(n);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Object[] objectArray = new Object[]{list.get(i).toString(), list2.get(i)};
                arrayList.add(objectArray);
            }
        }
        return arrayList;
    }

    private void setArtistsChart() {
        DefaultCategoryDataset defaultCategoryDataset = this.getDataSet(this.getMostPlayedArtistsInRanking(10));
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart3D((String)I18nUtils.getString("ARTIST_MOST_PLAYED"), null, null, (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
        jFreeChart.getTitle().setFont(Fonts.getChartTitleFont());
        jFreeChart.setBackgroundPaint((Paint)Color.WHITE);
        jFreeChart.setPadding(new RectangleInsets(5.0, 0.0, 0.0, 0.0));
        NumberAxis numberAxis = new NumberAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setTickLabelFont(Fonts.getChartTickLabelFont());
        jFreeChart.setBackgroundPaint((Paint)GuiUtils.getBackgroundColor());
        jFreeChart.getTitle().setPaint((Paint)GuiUtils.getForegroundColor());
        jFreeChart.getCategoryPlot().setRangeAxis((ValueAxis)numberAxis);
        jFreeChart.getCategoryPlot().setForegroundAlpha(1.0f);
        jFreeChart.getCategoryPlot().getRenderer().setSeriesPaint(0, (Paint)Color.GREEN);
        jFreeChart.getCategoryPlot().getDomainAxis().setTickLabelFont(Fonts.getChartTickLabelFont());
        jFreeChart.getCategoryPlot().getDomainAxis().setTickLabelPaint((Paint)GuiUtils.getForegroundColor());
        jFreeChart.getCategoryPlot().getRangeAxis().setTickLabelFont(Fonts.getChartTickLabelFont());
        jFreeChart.getCategoryPlot().getRangeAxis().setTickLabelPaint((Paint)GuiUtils.getForegroundColor());
        jFreeChart.getPlot().setBackgroundPaint((Paint)GuiUtils.getBackgroundColor());
        ((StatsDialog)this.getComponentControlled()).getArtistsChart().setIcon(new ImageIcon(jFreeChart.createBufferedImage(710, 250)));
    }

    private void setArtistsTable() {
        List<Object[]> list = this.getMostPlayedArtistsInRanking(-1);
        if (list != null) {
            Object[] objectArray = new String[]{I18nUtils.getString("ARTIST"), I18nUtils.getString("TIMES_PLAYED"), "%"};
            Object[][] objectArray2 = new Object[list.size()][3];
            for (int i = 0; i < list.size(); ++i) {
                objectArray2[i][0] = list.get(i)[0];
                objectArray2[i][1] = list.get(i)[1];
                objectArray2[i][2] = StatisticsHandler.getInstance().getTotalAudioFilesPlayed() != -1 ? StringUtils.toString(100.0 * (double)((Integer)list.get(i)[1]).intValue() / (double)StatisticsHandler.getInstance().getTotalAudioFilesPlayed(), 2) : Integer.valueOf(0);
            }
            this.setTable(((StatsDialog)this.getComponentControlled()).getArtistsTable(), objectArray, objectArray2);
        }
    }

    private List<Object[]> getMostPlayedArtistsInRanking(int n) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        List<Artist> list = StatisticsHandler.getInstance().getMostPlayedArtists(n);
        List<Integer> list2 = StatisticsHandler.getInstance().getMostPlayedArtistsCount(n);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) == null) continue;
                Object[] objectArray = new Object[]{list.get(i).toString(), list2.get(i)};
                arrayList.add(objectArray);
            }
        }
        return arrayList;
    }

    private void setGeneralChart() {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        int n = StatisticsHandler.getInstance().getDifferentAudioFilesPlayed();
        int n2 = RepositoryHandler.getInstance().getAudioFilesList().size();
        defaultPieDataset.setValue((Comparable)((Object)I18nUtils.getString("SONGS_PLAYED")), (double)n);
        defaultPieDataset.setValue((Comparable)((Object)I18nUtils.getString("SONGS_NEVER_PLAYED")), (double)(n2 - n));
        JFreeChart jFreeChart = ChartFactory.createPieChart3D((String)I18nUtils.getString("SONGS_PLAYED"), (PieDataset)defaultPieDataset, (boolean)false, (boolean)false, (boolean)false);
        jFreeChart.getTitle().setFont(Fonts.getChartTitleFont());
        jFreeChart.setBackgroundPaint((Paint)GuiUtils.getBackgroundColor());
        jFreeChart.getTitle().setPaint((Paint)GuiUtils.getForegroundColor());
        jFreeChart.setPadding(new RectangleInsets(5.0, 0.0, 0.0, 0.0));
        DefaultDrawingSupplier defaultDrawingSupplier = new DefaultDrawingSupplier(new Paint[]{new Color(0.0f, 1.0f, 0.0f, 0.6f), new Color(1.0f, 0.0f, 0.0f, 0.6f)}, new Paint[]{new Color(0.0f, 1.0f, 0.0f, 0.4f), new Color(1.0f, 0.0f, 0.0f, 0.4f)}, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE);
        jFreeChart.getPlot().setDrawingSupplier((DrawingSupplier)defaultDrawingSupplier);
        ((PiePlot3D)jFreeChart.getPlot()).setLabelFont(Fonts.getChartTickLabelFont());
        ((PiePlot3D)jFreeChart.getPlot()).setOutlineVisible(false);
        ((PiePlot3D)jFreeChart.getPlot()).setBackgroundPaint((Paint)GuiUtils.getBackgroundColor());
        ((StatsDialog)this.getComponentControlled()).getGeneralChart().setIcon(new ImageIcon(jFreeChart.createBufferedImage(710, 250)));
    }

    private void setGeneralTable() {
        int n = StatisticsHandler.getInstance().getDifferentAudioFilesPlayed();
        int n2 = RepositoryHandler.getInstance().getAudioFilesList().size();
        if (n2 != 0) {
            Object[] objectArray = new String[]{" ", I18nUtils.getString("COUNT"), "%"};
            Object[][] objectArray2 = new Object[2][3];
            objectArray2[0] = new Object[3];
            objectArray2[0][0] = I18nUtils.getString("SONGS_PLAYED");
            objectArray2[0][1] = n;
            objectArray2[0][2] = StringUtils.toString((float)n / (float)n2 * 100.0f, 2);
            objectArray2[1] = new Object[3];
            objectArray2[1][0] = I18nUtils.getString("SONGS_NEVER_PLAYED");
            objectArray2[1][1] = n2 - n;
            objectArray2[1][2] = StringUtils.toString((float)(n2 - n) / (float)n2 * 100.0f, 2);
            this.setTable(((StatsDialog)this.getComponentControlled()).getGeneralTable(), objectArray, objectArray2);
        }
    }

    private void setSongsChart() {
        DefaultCategoryDataset defaultCategoryDataset = this.getDataSet(this.getMostPlayedAudioFilesInRanking(10));
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart3D((String)I18nUtils.getString("SONG_MOST_PLAYED"), null, null, (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
        jFreeChart.getTitle().setFont(Fonts.getChartTitleFont());
        jFreeChart.setBackgroundPaint((Paint)Color.WHITE);
        jFreeChart.setPadding(new RectangleInsets(5.0, 0.0, 0.0, 0.0));
        NumberAxis numberAxis = new NumberAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setTickLabelFont(Fonts.getChartTickLabelFont());
        jFreeChart.setBackgroundPaint((Paint)GuiUtils.getBackgroundColor());
        jFreeChart.getTitle().setPaint((Paint)GuiUtils.getForegroundColor());
        jFreeChart.getCategoryPlot().setRangeAxis((ValueAxis)numberAxis);
        jFreeChart.getCategoryPlot().setForegroundAlpha(1.0f);
        jFreeChart.getCategoryPlot().getRenderer().setSeriesPaint(0, (Paint)Color.GREEN);
        jFreeChart.getCategoryPlot().getDomainAxis().setTickLabelFont(Fonts.getChartTickLabelFont());
        jFreeChart.getCategoryPlot().getDomainAxis().setTickLabelPaint((Paint)GuiUtils.getForegroundColor());
        jFreeChart.getCategoryPlot().getRangeAxis().setTickLabelFont(Fonts.getChartTickLabelFont());
        jFreeChart.getCategoryPlot().getRangeAxis().setTickLabelPaint((Paint)GuiUtils.getForegroundColor());
        jFreeChart.getPlot().setBackgroundPaint((Paint)GuiUtils.getBackgroundColor());
        ((StatsDialog)this.getComponentControlled()).getSongsChart().setIcon(new ImageIcon(jFreeChart.createBufferedImage(710, 250)));
    }

    private void setSongsTable() {
        List<Object[]> list = this.getMostPlayedAudioFilesInRanking(-1);
        if (list != null) {
            Object[] objectArray = new String[]{I18nUtils.getString("SONG"), I18nUtils.getString("TIMES_PLAYED"), "%"};
            Object[][] objectArray2 = new Object[list.size()][3];
            for (int i = 0; i < list.size(); ++i) {
                objectArray2[i][0] = list.get(i)[0];
                objectArray2[i][1] = list.get(i)[1];
                objectArray2[i][2] = StatisticsHandler.getInstance().getTotalAudioFilesPlayed() != -1 ? StringUtils.toString(100.0 * (double)((Integer)list.get(i)[1]).intValue() / (double)StatisticsHandler.getInstance().getTotalAudioFilesPlayed(), 2) : Integer.valueOf(0);
            }
            this.setTable(((StatsDialog)this.getComponentControlled()).getSongsTable(), objectArray, objectArray2);
        }
    }

    private List<Object[]> getMostPlayedAudioFilesInRanking(int n) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        List<AudioFile> list = StatisticsHandler.getInstance().getMostPlayedAudioFiles(n);
        List<Integer> list2 = StatisticsHandler.getInstance().getMostPlayedAudioFilesCount(n);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Object[] objectArray = new Object[2];
                AudioFile audioFile = list.get(i);
                if (audioFile == null) continue;
                objectArray[0] = StringUtils.getString(audioFile.getTitleOrFileName(), " (", audioFile.getArtist(), ")");
                objectArray[1] = list2.get(i);
                arrayList.add(objectArray);
            }
        }
        return arrayList;
    }

    private void setTable(JTable jTable, Object[] objectArray, Object[][] objectArray2) {
        jTable.setModel(new StatsDialogDefaultTableModel(objectArray2, objectArray));
        jTable.getColumnModel().getColumn(0).setPreferredWidth(420);
        jTable.getColumnModel().getColumn(0).setWidth(jTable.getColumnModel().getColumn(0).getWidth());
        jTable.getColumnModel().getColumn(0).setCellRenderer(LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(new SwingOrientationTableCellRendererCode()));
        jTable.getColumnModel().getColumn(2).setPreferredWidth(30);
        jTable.getColumnModel().getColumn(2).setWidth(jTable.getColumnModel().getColumn(2).getWidth());
        jTable.getColumnModel().getColumn(1).setCellRenderer(LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(new RightAlignmentTableCellRendererCode()));
        jTable.getColumnModel().getColumn(2).setCellRenderer(LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(new RightAlignmentTableCellRendererCode()));
    }

    public void showStats() {
        this.getLogger().debug("CONTROLLER  ");
        this.updateStats();
        StatsDialog statsDialog = (StatsDialog)this.getComponentControlled();
        statsDialog.setVisible(true);
    }

    public void updateStats() {
        this.setArtistsTable();
        this.setAlbumsTable();
        this.setSongsTable();
        this.setGeneralTable();
        this.setArtistsChart();
        this.setAlbumsChart();
        this.setSongsChart();
        this.setGeneralChart();
    }

    private static final class StatsDialogDefaultTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 0L;

        private StatsDialogDefaultTableModel(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    private static class SwingOrientationTableCellRendererCode
    extends AbstractTableCellRendererCode {
        private SwingOrientationTableCellRendererCode() {
        }

        @Override
        public Component getComponent(Component component, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setHorizontalAlignment(GuiUtils.getComponentOrientationAsSwingConstant());
                return jLabel;
            }
            return component;
        }
    }

    private static class RightAlignmentTableCellRendererCode
    extends AbstractTableCellRendererCode {
        private RightAlignmentTableCellRendererCode() {
        }

        @Override
        public Component getComponent(Component component, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setHorizontalAlignment(4);
                return jLabel;
            }
            return component;
        }
    }
}

