/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.columns;

import javax.swing.JLabel;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.kernel.modules.repository.favorites.FavoritesHandler;
import net.sourceforge.atunes.model.AudioObject;

public class AlbumColumn
extends AbstractColumn {
    private static final long serialVersionUID = -6162621108007788707L;

    public AlbumColumn() {
        super("ALBUM", JLabel.class);
        this.setVisible(true);
        this.setUsedForFilter(true);
    }

    @Override
    protected int ascendingCompare(AudioObject audioObject, AudioObject audioObject2) {
        if (audioObject.getAlbum().equals(audioObject2.getAlbum())) {
            if (audioObject.getDiscNumber() == audioObject2.getDiscNumber()) {
                return Integer.valueOf(audioObject.getTrackNumber()).compareTo(audioObject2.getTrackNumber());
            }
            return Integer.valueOf(audioObject.getDiscNumber()).compareTo(audioObject2.getDiscNumber());
        }
        return audioObject.getAlbum().compareTo(audioObject2.getAlbum());
    }

    @Override
    public Object getValueFor(AudioObject audioObject) {
        return new JLabel(audioObject.getAlbum(), !FavoritesHandler.getInstance().getFavoriteAlbumsInfo().containsKey(audioObject.getAlbum()) ? null : Images.getImage("albumFavorite.png"), 2);
    }

    @Override
    public String getValueForFilter(AudioObject audioObject) {
        return audioObject.getAlbum();
    }
}

