/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.columns;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.kernel.modules.columns.AlbumArtistColumn;
import net.sourceforge.atunes.kernel.modules.columns.AlbumColumn;
import net.sourceforge.atunes.kernel.modules.columns.ArtistColumn;
import net.sourceforge.atunes.kernel.modules.columns.BitrateColumn;
import net.sourceforge.atunes.kernel.modules.columns.ComposerColumn;
import net.sourceforge.atunes.kernel.modules.columns.DateColumn;
import net.sourceforge.atunes.kernel.modules.columns.DiscNumberColumn;
import net.sourceforge.atunes.kernel.modules.columns.FavoriteColumn;
import net.sourceforge.atunes.kernel.modules.columns.FileNameColumn;
import net.sourceforge.atunes.kernel.modules.columns.FrequencyColumn;
import net.sourceforge.atunes.kernel.modules.columns.GenreColumn;
import net.sourceforge.atunes.kernel.modules.columns.LengthColumn;
import net.sourceforge.atunes.kernel.modules.columns.PathColumn;
import net.sourceforge.atunes.kernel.modules.columns.PlayingColumn;
import net.sourceforge.atunes.kernel.modules.columns.ScoreColumn;
import net.sourceforge.atunes.kernel.modules.columns.SizeColumn;
import net.sourceforge.atunes.kernel.modules.columns.TimesPlayedColumn;
import net.sourceforge.atunes.kernel.modules.columns.TitleColumn;
import net.sourceforge.atunes.kernel.modules.columns.TrackColumn;
import net.sourceforge.atunes.kernel.modules.columns.TypeColumn;
import net.sourceforge.atunes.kernel.modules.columns.YearColumn;
import net.sourceforge.atunes.misc.log.Logger;

public final class Columns {
    private static List<Class<? extends AbstractColumn>> classes;

    private Columns() {
    }

    private static List<Class<? extends AbstractColumn>> getClasses() {
        if (classes == null) {
            classes = new ArrayList<Class<? extends AbstractColumn>>();
            classes.add(PlayingColumn.class);
            classes.add(FavoriteColumn.class);
            classes.add(TypeColumn.class);
            classes.add(TrackColumn.class);
            classes.add(TitleColumn.class);
            classes.add(ArtistColumn.class);
            classes.add(AlbumColumn.class);
            classes.add(AlbumArtistColumn.class);
            classes.add(ComposerColumn.class);
            classes.add(GenreColumn.class);
            classes.add(YearColumn.class);
            classes.add(DateColumn.class);
            classes.add(LengthColumn.class);
            classes.add(ScoreColumn.class);
            classes.add(FileNameColumn.class);
            classes.add(PathColumn.class);
            classes.add(SizeColumn.class);
            classes.add(BitrateColumn.class);
            classes.add(FrequencyColumn.class);
            classes.add(TimesPlayedColumn.class);
            classes.add(DiscNumberColumn.class);
        }
        return classes;
    }

    public static List<AbstractColumn> getColumns(boolean bl) {
        ArrayList<AbstractColumn> arrayList = new ArrayList<AbstractColumn>();
        int n = 0;
        for (Class<? extends AbstractColumn> clazz : Columns.getClasses()) {
            AbstractColumn abstractColumn = null;
            try {
                abstractColumn = clazz.newInstance();
                if ((bl || abstractColumn.isPlayListExclusive()) && !bl) continue;
                abstractColumn.setOrder(n);
                ++n;
                arrayList.add(abstractColumn);
            }
            catch (Exception exception) {
                new Logger().error("COLUMNS     ", exception);
            }
        }
        return arrayList;
    }
}

