/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.columns;

import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.model.AudioObject;

public class GenreColumn
extends AbstractColumn {
    private static final long serialVersionUID = 1420893111015572964L;

    public GenreColumn() {
        super("GENRE", String.class);
        this.setVisible(true);
        this.setUsedForFilter(true);
    }

    @Override
    protected int ascendingCompare(AudioObject audioObject, AudioObject audioObject2) {
        if (audioObject.getGenre().equals(audioObject2.getGenre())) {
            if (audioObject.getArtist().equals(audioObject2.getArtist())) {
                if (audioObject.getAlbum().equals(audioObject2.getAlbum())) {
                    return Integer.valueOf(audioObject.getTrackNumber()).compareTo(audioObject2.getTrackNumber());
                }
                return audioObject.getAlbum().compareTo(audioObject2.getAlbum());
            }
            return audioObject.getArtist().compareTo(audioObject2.getArtist());
        }
        return audioObject.getGenre().compareTo(audioObject2.getGenre());
    }

    @Override
    public Object getValueFor(AudioObject audioObject) {
        return audioObject.getGenre();
    }

    @Override
    public String getValueForFilter(AudioObject audioObject) {
        return audioObject.getGenre();
    }
}

