/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.gui.views.controls.PopUpButton;
import net.sourceforge.atunes.kernel.modules.context.AbstractContextPanelContent;
import net.sourceforge.atunes.kernel.modules.context.ContextHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import org.commonjukebox.plugins.model.PluginApi;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;

@PluginApi
public abstract class AbstractContextPanel {
    private static final long serialVersionUID = 7870512266932745272L;
    private AudioObject audioObject;

    public abstract String getContextPanelName();

    protected abstract String getContextPanelTitle(AudioObject var1);

    protected abstract ImageIcon getContextPanelIcon(AudioObject var1);

    protected abstract List<AbstractContextPanelContent> getContents();

    protected abstract boolean isPanelEnabledForAudioObject(AudioObject var1);

    protected final void updateContextPanel(final AudioObject audioObject, final boolean bl) {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractContextPanel.this.updateContextPanelEDT(audioObject, bl);
                }
            });
        } else {
            this.updateContextPanelEDT(audioObject, bl);
        }
    }

    private void updateContextPanelEDT(AudioObject audioObject, boolean bl) {
        if (!bl && this.audioObject != null && this.audioObject.equals(audioObject)) {
            return;
        }
        new Logger().debug("CONTEXT     ", "Updating panel: ", this.getContextPanelName());
        for (AbstractContextPanelContent abstractContextPanelContent : this.getContents()) {
            abstractContextPanelContent.clearContextPanelContent();
            abstractContextPanelContent.updateContextPanelContent(audioObject);
        }
        this.audioObject = audioObject;
    }

    public final void clearContextPanel() {
        new Logger().debug("CONTEXT     ", "Clearing panel: ", this.getContextPanelName());
        for (AbstractContextPanelContent abstractContextPanelContent : this.getContents()) {
            abstractContextPanelContent.clearContextPanelContent();
        }
        this.audioObject = null;
    }

    public final Component getUIComponent() {
        JXTaskPaneContainer jXTaskPaneContainer = new JXTaskPaneContainer();
        jXTaskPaneContainer.setOpaque(false);
        for (AbstractContextPanelContent abstractContextPanelContent : this.getContents()) {
            Object object;
            CustomJXTaskPane customJXTaskPane = new CustomJXTaskPane();
            abstractContextPanelContent.setParentTaskPane(customJXTaskPane);
            customJXTaskPane.setTitle(abstractContextPanelContent.getContentName());
            Object object2 = abstractContextPanelContent.getComponent();
            if (object2 instanceof JComponent) {
                ((JComponent)object2).setOpaque(false);
            }
            if (abstractContextPanelContent.isScrollNeeded()) {
                object = new JScrollPane((Component)object2);
                ((JComponent)object).setBorder(null);
                ((JScrollPane)object).getVerticalScrollBar().setUnitIncrement(50);
                object2 = object;
            }
            if ((object = abstractContextPanelContent.getOptions()) != null && !object.isEmpty()) {
                Serializable serializable;
                PopUpButton popUpButton = new PopUpButton(I18nUtils.getString("OPTIONS"), 1);
                Object object3 = object.iterator();
                while (object3.hasNext()) {
                    serializable = (Component)object3.next();
                    popUpButton.add((Component)serializable);
                }
                object3 = new JPanel(new GridBagLayout());
                ((JComponent)object3).setOpaque(false);
                serializable = new GridBagConstraints();
                ((GridBagConstraints)serializable).weightx = 1.0;
                ((GridBagConstraints)serializable).weighty = 1.0;
                ((GridBagConstraints)serializable).fill = 1;
                ((Container)object3).add((Component)object2, serializable);
                ((GridBagConstraints)serializable).gridy = 1;
                ((GridBagConstraints)serializable).weightx = 0.0;
                ((GridBagConstraints)serializable).weighty = 0.0;
                ((GridBagConstraints)serializable).fill = 0;
                ((GridBagConstraints)serializable).insets = new Insets(5, 0, 0, 0);
                ((GridBagConstraints)serializable).anchor = 17;
                ((Container)object3).add((Component)popUpButton, serializable);
                GuiUtils.applyComponentOrientation(new Container[]{object3});
                object2 = object3;
            }
            customJXTaskPane.add((Component)object2);
            customJXTaskPane.setCollapsed(true);
            jXTaskPaneContainer.add((JXTaskPane)customJXTaskPane);
        }
        JScrollPane jScrollPane = new JScrollPane((Component)jXTaskPaneContainer);
        jScrollPane.setBorder(null);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(50);
        return jScrollPane;
    }

    public final String getTitle() {
        if (ApplicationState.getInstance().isShowContextTabsText()) {
            return this.getContextPanelTitle(ContextHandler.getInstance().getCurrentAudioObject());
        }
        return null;
    }

    public final ImageIcon getIcon() {
        return this.getContextPanelIcon(ContextHandler.getInstance().getCurrentAudioObject());
    }

    public final boolean isEnabled() {
        if (ContextHandler.getInstance().getCurrentAudioObject() == null) {
            return false;
        }
        return this.isPanelEnabledForAudioObject(ContextHandler.getInstance().getCurrentAudioObject());
    }

    private static class CustomJXTaskPane
    extends JXTaskPane {
        private static final long serialVersionUID = 1569831509432974799L;

        private CustomJXTaskPane() {
        }

        public void setCollapsed(boolean bl) {
            if (this.isEnabled()) {
                super.setCollapsed(bl);
            }
        }
    }
}

