/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.artist;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.sourceforge.atunes.gui.Fonts;
import net.sourceforge.atunes.gui.views.controls.CustomTextPane;
import net.sourceforge.atunes.gui.views.controls.UrlLabel;
import net.sourceforge.atunes.kernel.modules.context.AbstractContextPanelContent;
import net.sourceforge.atunes.kernel.modules.context.artist.ArtistInfoDataSource;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.ImageUtils;
import org.jdesktop.swingx.border.DropShadowBorder;

public class ArtistBasicInfoContent
extends AbstractContextPanelContent {
    private static final long serialVersionUID = -5538266144953409867L;
    private JLabel artistImageLabel;
    private UrlLabel artistNameLabel;
    private CustomTextPane artistWikiAbstract;
    private UrlLabel artistWikiReadMore;

    public ArtistBasicInfoContent() {
        super(new ArtistInfoDataSource());
    }

    @Override
    protected String getContentName() {
        return I18nUtils.getString("INFO");
    }

    @Override
    protected Map<String, ?> getDataSourceParameters(AudioObject audioObject) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("AUDIO_OBJECT", audioObject);
        hashMap.put("IMAGE", true);
        return hashMap;
    }

    @Override
    protected void updateContentWithDataSourceResult(Map<String, ?> map) {
        String string;
        String string2;
        Image image = (Image)map.get("IMAGE");
        if (image != null) {
            this.artistImageLabel.setIcon(ImageUtils.scaleImageBicubic(image, 225, 225));
            this.artistImageLabel.setBorder((Border)new DropShadowBorder());
        }
        String string3 = (String)map.get("ARTIST_NAME");
        String string4 = (String)map.get("ARTIST_URL");
        if (string3 != null && string4 != null) {
            this.artistNameLabel.setText(string3, string4);
        }
        if ((string2 = (String)map.get("WIKI_TEXT")) != null) {
            this.artistWikiAbstract.setText(string2);
            this.artistWikiAbstract.setCaretPosition(0);
        }
        if ((string = (String)map.get("WIKI_URL")) != null) {
            this.artistWikiReadMore.setText(I18nUtils.getString("READ_MORE"), string);
        }
    }

    @Override
    protected void clearContextPanelContent() {
        super.clearContextPanelContent();
        this.artistImageLabel.setIcon(null);
        this.artistImageLabel.setBorder(null);
        this.artistNameLabel.setText(null, null);
        this.artistWikiAbstract.setText(null);
        this.artistWikiReadMore.setText(null, null);
    }

    @Override
    protected Component getComponent() {
        this.artistImageLabel = new JLabel();
        this.artistNameLabel = new UrlLabel();
        this.artistNameLabel.setFont(Fonts.getContextInformationBigFont());
        this.artistWikiAbstract = new CustomTextPane(3);
        this.artistWikiAbstract.setEditable(false);
        this.artistWikiAbstract.setBorder(BorderFactory.createEmptyBorder());
        this.artistWikiAbstract.setOpaque(false);
        this.artistWikiReadMore = new UrlLabel();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 5, 0, 5);
        jPanel.add((Component)this.artistImageLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)((Object)this.artistNameLabel), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.artistWikiAbstract, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)((Object)this.artistWikiReadMore), gridBagConstraints);
        return jPanel;
    }
}

