/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.gui;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.atunes.Constants;
import net.sourceforge.atunes.gui.ColorDefinitions;
import net.sourceforge.atunes.gui.Fonts;
import net.sourceforge.atunes.gui.frame.DefaultSingleFrame;
import net.sourceforge.atunes.gui.frame.Frame;
import net.sourceforge.atunes.gui.frame.FrameState;
import net.sourceforge.atunes.gui.frame.MultipleFrame;
import net.sourceforge.atunes.gui.popup.FadingPopupFactory;
import net.sourceforge.atunes.gui.views.bars.ToolBar;
import net.sourceforge.atunes.gui.views.controls.playList.PlayListTable;
import net.sourceforge.atunes.gui.views.dialogs.AboutDialog;
import net.sourceforge.atunes.gui.views.dialogs.AddPodcastFeedDialog;
import net.sourceforge.atunes.gui.views.dialogs.AddRadioDialog;
import net.sourceforge.atunes.gui.views.dialogs.ColumnSetSelectorDialog;
import net.sourceforge.atunes.gui.views.dialogs.CoverNavigatorFrame;
import net.sourceforge.atunes.gui.views.dialogs.CustomSearchDialog;
import net.sourceforge.atunes.gui.views.dialogs.EditTagDialog;
import net.sourceforge.atunes.gui.views.dialogs.EditTitlesDialog;
import net.sourceforge.atunes.gui.views.dialogs.EqualizerDialog;
import net.sourceforge.atunes.gui.views.dialogs.ExportOptionsDialog;
import net.sourceforge.atunes.gui.views.dialogs.FileSelectionDialog;
import net.sourceforge.atunes.gui.views.dialogs.ImageDialog;
import net.sourceforge.atunes.gui.views.dialogs.IndeterminateProgressDialog;
import net.sourceforge.atunes.gui.views.dialogs.InputDialog;
import net.sourceforge.atunes.gui.views.dialogs.MultiFolderSelectionDialog;
import net.sourceforge.atunes.gui.views.dialogs.OSDDialog;
import net.sourceforge.atunes.gui.views.dialogs.ProgressDialog;
import net.sourceforge.atunes.gui.views.dialogs.RadioBrowserDialog;
import net.sourceforge.atunes.gui.views.dialogs.RepositoryProgressDialog;
import net.sourceforge.atunes.gui.views.dialogs.RepositorySelectionInfoDialog;
import net.sourceforge.atunes.gui.views.dialogs.ReviewImportDialog;
import net.sourceforge.atunes.gui.views.dialogs.RipCdDialog;
import net.sourceforge.atunes.gui.views.dialogs.RipperProgressDialog;
import net.sourceforge.atunes.gui.views.dialogs.SearchDialog;
import net.sourceforge.atunes.gui.views.dialogs.SearchResultsDialog;
import net.sourceforge.atunes.gui.views.dialogs.SplashScreenDialog;
import net.sourceforge.atunes.gui.views.dialogs.StatsDialog;
import net.sourceforge.atunes.gui.views.dialogs.TransferProgressDialog;
import net.sourceforge.atunes.gui.views.dialogs.UpdateDialog;
import net.sourceforge.atunes.gui.views.dialogs.editPreferences.EditPreferencesDialog;
import net.sourceforge.atunes.gui.views.dialogs.fullScreen.FullScreenWindow;
import net.sourceforge.atunes.gui.views.dialogs.properties.PropertiesDialog;
import net.sourceforge.atunes.gui.views.menus.ApplicationMenuBar;
import net.sourceforge.atunes.gui.views.panels.AudioObjectPropertiesPanel;
import net.sourceforge.atunes.gui.views.panels.ContextPanel;
import net.sourceforge.atunes.gui.views.panels.NavigationTablePanel;
import net.sourceforge.atunes.gui.views.panels.NavigationTreePanel;
import net.sourceforge.atunes.gui.views.panels.PlayListPanel;
import net.sourceforge.atunes.gui.views.panels.PlayerControlsPanel;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.Kernel;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.ShowToolbarAction;
import net.sourceforge.atunes.kernel.controllers.coverNavigator.CoverNavigatorController;
import net.sourceforge.atunes.kernel.modules.cdripper.RipperHandler;
import net.sourceforge.atunes.kernel.modules.context.ContextHandler;
import net.sourceforge.atunes.kernel.modules.draganddrop.PlayListTableTransferHandler;
import net.sourceforge.atunes.kernel.modules.draganddrop.PlayListToDeviceDragAndDropListener;
import net.sourceforge.atunes.kernel.modules.filter.FilterHandler;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.player.PlaybackState;
import net.sourceforge.atunes.kernel.modules.player.PlaybackStateListener;
import net.sourceforge.atunes.kernel.modules.playlist.PlayList;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeed;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.state.beans.LocaleBean;
import net.sourceforge.atunes.kernel.modules.tray.SystemTrayHandler;
import net.sourceforge.atunes.kernel.modules.updates.ApplicationVersion;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;

public final class GuiHandler
extends AbstractHandler
implements PlaybackStateListener {
    private static GuiHandler instance = new GuiHandler();
    private Frame frame;
    private OSDDialog osdDialog;
    private ExportOptionsDialog exportDialog;
    private StatsDialog statsDialog;
    private SearchDialog searchDialog;
    private RipCdDialog ripCdDialog;
    private RipperProgressDialog ripperProgressDialog;
    private IndeterminateProgressDialog indeterminateProgressDialog;
    private EditTitlesDialog editTitlesDialog;
    private EditPreferencesDialog editPreferencesDialog;
    private EqualizerDialog equalizerDialog;
    private AboutDialog aboutDialog;
    private SplashScreenDialog splashScreenDialog;
    private CustomSearchDialog customSearchDialog;
    private SearchResultsDialog searchResultsDialog;
    private RadioBrowserDialog radioBrowserDialog;
    private ReviewImportDialog reviewImportDialog;
    private FullScreenWindow fullScreenWindow;
    private boolean firstTimeShow = true;

    private GuiHandler() {
    }

    @Override
    protected void initHandler() {
    }

    public static GuiHandler getInstance() {
        return instance;
    }

    @Override
    public void applicationStarted() {
    }

    public void finish() {
        if (!ApplicationState.getInstance().isShowSystemTray()) {
            Kernel.getInstance().finish();
        }
    }

    public ContextPanel getContextPanel() {
        return this.frame.getContextPanel();
    }

    public EditPreferencesDialog getEditPreferencesDialog() {
        if (this.editPreferencesDialog == null) {
            this.editPreferencesDialog = new EditPreferencesDialog(this.frame.getFrame());
        }
        return this.editPreferencesDialog;
    }

    public EditTagDialog getEditTagDialog(boolean bl) {
        return new EditTagDialog(this.frame.getFrame(), bl);
    }

    public EditTitlesDialog getEditTitlesDialog() {
        if (this.editTitlesDialog == null) {
            this.editTitlesDialog = new EditTitlesDialog(this.frame.getFrame());
        }
        return this.editTitlesDialog;
    }

    public EqualizerDialog getEqualizerDialog() {
        if (this.equalizerDialog == null) {
            this.equalizerDialog = new EqualizerDialog(this.frame.getFrame());
        }
        return this.equalizerDialog;
    }

    public ExportOptionsDialog getExportDialog() {
        if (this.exportDialog == null) {
            this.exportDialog = new ExportOptionsDialog(this.frame.getFrame());
        }
        return this.exportDialog;
    }

    public FileSelectionDialog getFileSelectionDialog(boolean bl) {
        return new FileSelectionDialog(this.frame.getFrame(), bl);
    }

    public Frame getFrame() {
        if (this.frame == null) {
            Class<? extends Frame> clazz = ApplicationState.getInstance().getFrameClass();
            if (clazz != null) {
                try {
                    this.frame = clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    GuiHandler.getLogger().error("HANDLER     ", instantiationException);
                    this.constructDefaultFrame();
                }
                catch (IllegalAccessException illegalAccessException) {
                    GuiHandler.getLogger().error("HANDLER     ", illegalAccessException);
                    this.constructDefaultFrame();
                }
            } else {
                this.constructDefaultFrame();
            }
        }
        return this.frame;
    }

    private void constructDefaultFrame() {
        this.frame = new DefaultSingleFrame();
        ApplicationState.getInstance().setFrameClass(this.frame.getClass());
    }

    public FullScreenWindow getFullScreenWindow() {
        if (this.fullScreenWindow == null) {
            JDialog.setDefaultLookAndFeelDecorated(false);
            this.fullScreenWindow = new FullScreenWindow(this.frame.getFrame());
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
        return this.fullScreenWindow;
    }

    IndeterminateProgressDialog getIndeterminateProgressDialog() {
        if (this.indeterminateProgressDialog == null) {
            this.indeterminateProgressDialog = new IndeterminateProgressDialog(this.frame.getFrame());
        }
        return this.indeterminateProgressDialog;
    }

    public ApplicationMenuBar getMenuBar() {
        return this.frame.getAppMenuBar();
    }

    public MultiFolderSelectionDialog getMultiFolderSelectionDialog() {
        return new MultiFolderSelectionDialog(this.frame.getFrame());
    }

    public NavigationTreePanel getNavigationTreePanel() {
        return this.frame.getNavigationTreePanel();
    }

    public NavigationTablePanel getNavigationTablePanel() {
        return this.frame.getNavigationTablePanel();
    }

    public ProgressDialog getNewProgressDialog(String string, Component component) {
        return new ProgressDialog(string, component == null ? this.frame.getFrame() : component);
    }

    public TransferProgressDialog getNewTransferProgressDialog(String string, Component component) {
        return new TransferProgressDialog(string, component == null ? this.frame.getFrame() : component);
    }

    public OSDDialog getOSDDialog() {
        if (this.osdDialog == null) {
            JDialog.setDefaultLookAndFeelDecorated(false);
            this.osdDialog = new OSDDialog(ApplicationState.getInstance().getOsdWidth());
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
        return this.osdDialog;
    }

    public PlayerControlsPanel getPlayerControls() {
        return this.frame.getPlayerControls();
    }

    public ColumnSetSelectorDialog getColumnSelector() {
        return new ColumnSetSelectorDialog(this.frame.getFrame());
    }

    public PlayListPanel getPlayListPanel() {
        return this.frame.getPlayListPanel();
    }

    public PlayListTable getPlayListTable() {
        return this.frame.getPlayListTable();
    }

    public RepositoryProgressDialog getProgressDialog() {
        return new RepositoryProgressDialog(this.frame.getFrame());
    }

    public AudioObjectPropertiesPanel getPropertiesPanel() {
        return this.frame.getPropertiesPanel();
    }

    public RadioBrowserDialog getRadioBrowserDialog() {
        if (this.radioBrowserDialog == null) {
            this.radioBrowserDialog = new RadioBrowserDialog((Component)this.frame.getFrame());
        }
        return this.radioBrowserDialog;
    }

    public ReviewImportDialog getReviewImportDialog() {
        if (this.reviewImportDialog == null) {
            this.reviewImportDialog = new ReviewImportDialog(this.frame.getFrame());
        }
        return this.reviewImportDialog;
    }

    public RipCdDialog getRipCdDialog() {
        if (this.ripCdDialog == null) {
            this.ripCdDialog = new RipCdDialog(this.frame.getFrame());
        }
        return this.ripCdDialog;
    }

    public RipperProgressDialog getRipperProgressDialog() {
        if (this.ripperProgressDialog == null) {
            this.ripperProgressDialog = new RipperProgressDialog((Component)this.frame.getFrame());
            this.ripperProgressDialog.addCancelAction(new RipperCancelAction());
        }
        return this.ripperProgressDialog;
    }

    public SearchDialog getSearchDialog() {
        if (this.searchDialog == null) {
            this.searchDialog = new SearchDialog(this.frame.getFrame());
        }
        return this.searchDialog;
    }

    public StatsDialog getStatsDialog() {
        if (this.statsDialog == null) {
            this.statsDialog = new StatsDialog((Component)this.frame.getFrame());
        }
        return this.statsDialog;
    }

    public ToolBar getToolBar() {
        return this.frame.getToolBar();
    }

    public Point getWindowLocation() {
        return this.frame.getLocation();
    }

    public Dimension getWindowSize() {
        return this.frame.getSize();
    }

    public void hideIndeterminateProgressDialog() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GuiHandler.this.getIndeterminateProgressDialog().setVisible(false);
                }
            });
        }
        catch (Exception exception) {
            GuiHandler.getLogger().internalError(exception);
        }
    }

    public void hideSplashScreen() {
        if (this.splashScreenDialog != null) {
            this.splashScreenDialog.setVisible(false);
            this.splashScreenDialog.dispose();
            this.splashScreenDialog = null;
        }
    }

    @Override
    public void applicationFinish() {
        Window[] windowArray;
        for (Window window : windowArray = Window.getWindows()) {
            window.setVisible(false);
        }
    }

    public boolean isMaximized() {
        return this.frame.getExtendedState() == 6;
    }

    public boolean isMultipleWindow() {
        return this.frame instanceof MultipleFrame;
    }

    private void repaint() {
        this.frame.getFrame().invalidate();
        this.frame.getFrame().validate();
        this.frame.getFrame().repaint();
    }

    public void setCenterStatusBarText(String string, String string2) {
        this.frame.setCenterStatusBarText(string, string2);
    }

    public void setFrameDefaultCloseOperation(int n) {
        this.frame.setDefaultCloseOperation(n);
    }

    public void setFullFrameExtendedState(int n) {
        this.frame.setExtendedState(n);
    }

    public void setFullFrameLocation(Point point) {
        this.frame.setLocation(point);
    }

    public void setFullFrameLocationRelativeTo(Component component) {
        this.frame.setLocationRelativeTo(component);
    }

    public void setFullFrameVisible(boolean bl) {
        this.frame.setVisible(bl);
        if (this.firstTimeShow && this.frame instanceof DefaultSingleFrame) {
            ((DefaultSingleFrame)this.frame).setWindowSize();
        }
        this.firstTimeShow = false;
    }

    public void setLeftStatusBarText(String string, String string2) {
        this.frame.setLeftStatusBarText(string, string2);
    }

    private void setPlaying(boolean bl) {
        ControllerProxy.getInstance().getPlayerControlsController().setPlaying(bl);
        GuiHandler.getInstance().getFullScreenWindow().setPlaying(bl);
        SystemTrayHandler.getInstance().setPlaying(bl);
    }

    public void setRightStatusBarText(String string, String string2) {
        this.frame.setRightStatusBarText(string, string2);
    }

    public void setTitleBar(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!string.equals("")) {
            stringBuilder.append(string);
            stringBuilder.append(" - ");
        }
        stringBuilder.append("aTunes");
        stringBuilder.append(" ");
        stringBuilder.append(Constants.VERSION.toShortString());
        String string2 = stringBuilder.toString();
        this.frame.setTitle(string2);
        SystemTrayHandler.getInstance().setTrayToolTip(string2);
    }

    public void showAboutDialog() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog(this.frame.getFrame());
        }
        this.aboutDialog.setVisible(true);
    }

    public CustomSearchDialog getCustomSearchDialog() {
        if (this.customSearchDialog == null) {
            this.customSearchDialog = new CustomSearchDialog(this.frame.getFrame());
        }
        return this.customSearchDialog;
    }

    public SearchResultsDialog getSearchResultsDialog() {
        if (this.searchResultsDialog == null) {
            this.searchResultsDialog = new SearchResultsDialog(this.frame.getFrame());
        }
        return this.searchResultsDialog;
    }

    public PodcastFeed showAddPodcastFeedDialog() {
        AddPodcastFeedDialog addPodcastFeedDialog = new AddPodcastFeedDialog(this.frame.getFrame());
        addPodcastFeedDialog.setVisible(true);
        return addPodcastFeedDialog.getPodcastFeed();
    }

    public Radio showAddRadioDialog() {
        AddRadioDialog addRadioDialog = new AddRadioDialog(this.frame.getFrame());
        addRadioDialog.setVisible(true);
        return addRadioDialog.getRadio();
    }

    public void showContextPanel(boolean bl) {
        ApplicationState.getInstance().setUseContext(bl);
        this.frame.showContextPanel(bl);
        if (bl) {
            ContextHandler.getInstance().retrieveInfoAndShowInPanel(PlayListHandler.getInstance().getCurrentAudioObjectFromVisiblePlayList());
        }
    }

    public int showConfirmationDialog(String string, String string2) {
        return JOptionPane.showConfirmDialog(this.frame.getFrame(), string, string2, 0);
    }

    public int showConfirmationDialog(String string) {
        return this.showConfirmationDialog(string, I18nUtils.getString("CONFIRMATION"));
    }

    public void showCoverNavigator() {
        CoverNavigatorFrame coverNavigatorFrame = new CoverNavigatorFrame(RepositoryHandler.getInstance().getArtists(), this.frame.getFrame());
        new CoverNavigatorController(coverNavigatorFrame);
        coverNavigatorFrame.setVisible(true);
    }

    public void showErrorDialog(String string) {
        JOptionPane.showMessageDialog(this.frame.getFrame(), string, I18nUtils.getString("ERROR"), 0);
    }

    public void showErrorDialog(String string, Component component) {
        JOptionPane.showMessageDialog(component, string, I18nUtils.getString("ERROR"), 0);
    }

    public void showExceptionDialog(String string, Exception exception) {
        this.showExceptionDialog(I18nUtils.getString("ERROR"), string, exception);
    }

    public void showExceptionDialog(String string, String string2, Exception exception) {
        JXErrorPane jXErrorPane = new JXErrorPane();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(exception.getClass().getName());
        stringBuilder.append(": ");
        stringBuilder.append(exception.getMessage());
        stringBuilder.append("<br/>");
        stringBuilder.append("<br/>");
        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
            stringBuilder.append(stackTraceElement.toString());
            stringBuilder.append("<br/>");
        }
        jXErrorPane.setErrorInfo(new ErrorInfo(string, string2, stringBuilder.toString(), null, (Throwable)exception, Level.SEVERE, null));
        JXErrorPane.showDialog(null, (JXErrorPane)jXErrorPane);
    }

    public void showDeviceInfoOnStatusBar(String string) {
        this.frame.setStatusBarDeviceLabelText(string);
        this.frame.showDeviceInfo(true);
    }

    public void hideDeviceInfoOnStatusBar() {
        this.frame.showDeviceInfo(false);
    }

    public void showNewPodcastFeedEntriesInfo() {
        if (!ApplicationState.getInstance().isShowStatusBar()) {
            this.showMessage(I18nUtils.getString("NEW_PODCAST_ENTRIES"));
        } else {
            this.frame.showNewPodcastFeedEntriesInfo(true);
        }
    }

    public void showNewVersionInfo(ApplicationVersion applicationVersion, boolean bl) {
        if (bl || !ApplicationState.getInstance().isShowStatusBar()) {
            new UpdateDialog(applicationVersion, this.frame.getFrame()).setVisible(true);
        } else {
            this.frame.showNewVersionInfo(true, applicationVersion);
        }
    }

    public void showImageDialog(AudioObject audioObject) {
        new ImageDialog(this.frame.getFrame(), audioObject);
    }

    public void showIndeterminateProgressDialog(final String string) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GuiHandler.this.getIndeterminateProgressDialog().setTitle(string);
                    GuiHandler.this.getIndeterminateProgressDialog().setVisible(true);
                }
            });
        }
        catch (Exception exception) {
            GuiHandler.getLogger().internalError(exception);
        }
    }

    public String showInputDialog(String string, String string2) {
        return this.showInputDialog(string, string2, null);
    }

    public String showInputDialog(String string, String string2, Image image) {
        InputDialog inputDialog = new InputDialog((Window)this.frame.getFrame(), string, image);
        inputDialog.show(string2);
        return inputDialog.getResult();
    }

    public void showMessage(String string) {
        JOptionPane.showMessageDialog(this.frame.getFrame(), string);
    }

    public Object showMessage(String string, String string2, int n, Object[] objectArray) {
        JOptionPane jOptionPane = new JOptionPane(string, n, 2, null, objectArray);
        JDialog jDialog = jOptionPane.createDialog(this.frame.getFrame(), string2);
        jDialog.setLocationRelativeTo(this.frame.getFrame());
        jDialog.setVisible(true);
        return jOptionPane.getValue();
    }

    public void showNavigationTree(boolean bl) {
        ApplicationState.getInstance().setShowNavigationTree(bl);
        this.frame.showNavigationTree(bl);
        FilterHandler.getInstance().setFilterEnabled(NavigationHandler.getInstance().getTreeFilter(), bl);
    }

    public void showNavigationTable(boolean bl) {
        this.frame.showNavigationTable(bl);
        FilterHandler.getInstance().setFilterEnabled(NavigationHandler.getInstance().getTableFilter(), bl);
    }

    public int showOpenDialog(JFileChooser jFileChooser, FileFilter fileFilter) {
        jFileChooser.setFileFilter(fileFilter);
        return jFileChooser.showOpenDialog(this.frame.getFrame());
    }

    public void showPlayListInformation(PlayList playList) {
        int n = playList.getObjectsOfType(AudioFile.class).size();
        int n2 = playList.getObjectsOfType(Radio.class).size();
        int n3 = playList.getObjectsOfType(PodcastFeedEntry.class).size();
        int n4 = playList.size();
        Object[] objectArray = new Object[]{I18nUtils.getString("PLAYLIST"), ": ", n4, " ", I18nUtils.getString("SONGS"), " (", playList.getLength(), ") ", " - ", n, " ", I18nUtils.getString("SONGS"), " / ", n2, " ", I18nUtils.getString("RADIOS"), " / ", n3, " ", I18nUtils.getString("PODCAST_ENTRIES_COUNTER").isEmpty() ? I18nUtils.getString("PODCAST_ENTRIES") : I18nUtils.getString("PODCAST_ENTRIES_COUNTER")};
        Object[] objectArray2 = new Object[]{I18nUtils.getString("PLAYLIST"), ": ", n4, " - ", n, " / ", n2, " / ", n3};
        String string = StringUtils.getString(objectArray);
        String string2 = StringUtils.getString(objectArray2);
        this.setRightStatusBarText(string2, string);
    }

    public JProgressBar getProgressBar() {
        return this.frame.getProgressBar();
    }

    public void showPropertiesDialog(AudioObject audioObject) {
        PropertiesDialog propertiesDialog = PropertiesDialog.newInstance(audioObject, this.frame.getFrame());
        if (propertiesDialog.isVisible()) {
            propertiesDialog.toFront();
        } else {
            propertiesDialog.setVisible(true);
        }
    }

    public void showRepositorySelectionInfoDialog() {
        new RepositorySelectionInfoDialog(this.frame.getFrame()).setVisible(true);
    }

    public void showRepositoryAudioFileNumber(long l, long l2, long l3) {
        if (I18nUtils.getString("SONGS_IN_REPOSITORY").isEmpty()) {
            String string = StringUtils.getString(I18nUtils.getString("REPOSITORY"), ": ", l, " ", I18nUtils.getString("SONGS"));
            String string2 = StringUtils.getString(I18nUtils.getString("REPOSITORY"), ": ", l, " ", I18nUtils.getString("SONGS"), " - ", StringUtils.fromByteToMegaOrGiga(l2), " - ", StringUtils.fromSecondsToHoursAndDays(l3));
            this.setCenterStatusBarText(string, string2);
        } else {
            String string = StringUtils.getString(I18nUtils.getString("REPOSITORY"), ": ", l, " ", I18nUtils.getString("SONGS_IN_REPOSITORY"));
            String string3 = StringUtils.getString(I18nUtils.getString("REPOSITORY"), ": ", l, " ", I18nUtils.getString("SONGS_IN_REPOSITORY"), " - ", StringUtils.fromByteToMegaOrGiga(l2), " - ", StringUtils.fromSecondsToHoursAndDays(l3));
            this.setCenterStatusBarText(string, string3);
        }
    }

    public int showSaveDialog(JFileChooser jFileChooser, FileFilter fileFilter) {
        jFileChooser.setFileFilter(fileFilter);
        return jFileChooser.showSaveDialog(this.frame.getFrame());
    }

    public void showSongProperties(boolean bl) {
        ApplicationState.getInstance().setShowAudioObjectProperties(bl);
        this.frame.showSongProperties(bl);
        if (bl) {
            if (PlayListHandler.getInstance().getCurrentAudioObjectFromCurrentPlayList() != null) {
                ControllerProxy.getInstance().getFilePropertiesController().updateValues(PlayListHandler.getInstance().getCurrentAudioObjectFromCurrentPlayList());
            } else {
                ControllerProxy.getInstance().getFilePropertiesController().onlyShowPropertiesPanel();
            }
        }
    }

    public void showSplashScreen() {
        if (ApplicationState.getInstance().isShowTitle()) {
            JDialog.setDefaultLookAndFeelDecorated(false);
            this.splashScreenDialog = new SplashScreenDialog(Fonts.getAppVersionLittleFont(), ColorDefinitions.TITLE_DIALOG_FONT_COLOR);
            JDialog.setDefaultLookAndFeelDecorated(true);
            if (GuiUtils.getNumberOfScreenDevices() > 1) {
                GraphicsDevice graphicsDevice = GuiUtils.getGraphicsDeviceForLocation(ApplicationState.getInstance().getWindowXPosition(), ApplicationState.getInstance().getWindowYPosition());
                GuiUtils.setLocationInScreen(this.splashScreenDialog, graphicsDevice);
            }
            this.splashScreenDialog.setVisible(true);
            this.splashScreenDialog.toFront();
        }
    }

    public void showStatusBar(boolean bl) {
        ApplicationState.getInstance().setShowStatusBar(bl);
        this.frame.showStatusBar(bl);
        this.repaint();
    }

    public void showToolBar(boolean bl) {
        Actions.getAction(ShowToolbarAction.class).putValue("SwingSelectedKey", bl);
        ApplicationState.getInstance().setShowToolBar(bl);
        this.frame.showToolBar(bl);
        this.repaint();
    }

    public void showProgressBar(boolean bl, String string) {
        if (this.frame.getProgressBar() != null) {
            this.frame.getProgressBar().setVisible(true);
            this.frame.getProgressBar().setIndeterminate(bl);
            if (!bl) {
                this.frame.getProgressBar().setMinimum(0);
                this.frame.getProgressBar().setValue(0);
            }
            this.frame.getProgressBar().setToolTipText(string);
        }
    }

    public void hideProgressBar() {
        if (this.frame.getProgressBar() != null) {
            this.frame.getProgressBar().setVisible(false);
        }
    }

    public void startVisualization() {
        GuiHandler.getLogger().debug("START       ", "Starting visualization");
        if (SystemProperties.IS_JAVA_6_UPDATE_10_OR_LATER) {
            FadingPopupFactory.install();
        }
        FrameState frameState = ApplicationState.getInstance().getFrameStates().get(this.getFrame().getClass());
        LocaleBean localeBean = ApplicationState.getInstance().getLocale();
        LocaleBean localeBean2 = ApplicationState.getInstance().getOldLocale();
        if (frameState == null || localeBean == null || localeBean != null && localeBean2 != null && !ComponentOrientation.getOrientation(localeBean.getLocale()).equals(ComponentOrientation.getOrientation(localeBean2.getLocale()))) {
            frameState = new FrameState();
            ApplicationState.getInstance().getFrameStates().put(this.getFrame().getClass(), frameState);
        }
        this.getFrame().create(frameState);
        PlayListTableTransferHandler playListTableTransferHandler = new PlayListTableTransferHandler();
        ControllerProxy.getInstance().getPlayListController().getMainPlayListTable().setTransferHandler(playListTableTransferHandler);
        ControllerProxy.getInstance().getPlayListController().getMainPlayListScrollPane().setTransferHandler(playListTableTransferHandler);
        new PlayListToDeviceDragAndDropListener();
        JProgressBar jProgressBar = this.getProgressBar();
        if (jProgressBar != null) {
            jProgressBar.setVisible(false);
        }
        this.hideDeviceInfoOnStatusBar();
        GuiHandler.getLogger().debug("START       ", "Start visualization done");
    }

    public void toggleWindowVisibility() {
        this.getFrame().setVisible(!this.getFrame().isVisible());
        this.getFrame().getFrame().toFront();
        this.getFrame().getFrame().setState(0);
    }

    public void updateStatusBar(AudioObject audioObject) {
        if (!(audioObject instanceof Radio) && !(audioObject instanceof PodcastFeedEntry)) {
            if (GuiUtils.getComponentOrientation().isLeftToRight()) {
                String string = StringUtils.getString(I18nUtils.getString("PLAYING"), ": ");
                if (audioObject instanceof Radio || audioObject instanceof PodcastFeedEntry || ((AudioFile)audioObject).getTag() == null) {
                    string = StringUtils.getString(string, audioObject.getTitleOrFileName());
                } else {
                    string = ((AudioFile)audioObject).getTag().getTitle() == null || ((AudioFile)audioObject).getTag().getTitle().equals("") ? StringUtils.getString(string, ((AudioFile)audioObject).getFile().getName(), " - ") : StringUtils.getString(string, ((AudioFile)audioObject).getTag().getTitle(), " - ");
                    string = ((AudioFile)audioObject).getTag().getArtist() == null || ((AudioFile)audioObject).getTag().getArtist().equals("") ? StringUtils.getString(string, Artist.getUnknownArtist(), " ") : StringUtils.getString(string, ((AudioFile)audioObject).getTag().getArtist(), " ");
                    string = StringUtils.getString(string, "(", StringUtils.seconds2String(audioObject.getDuration()), ")");
                }
                this.setLeftStatusBarText(string, string);
            } else {
                String string = "";
                if (audioObject instanceof Radio || audioObject instanceof PodcastFeedEntry || ((AudioFile)audioObject).getTag() == null) {
                    string = StringUtils.getString(audioObject.getTitleOrFileName());
                } else {
                    string = StringUtils.getString("(", StringUtils.seconds2String(audioObject.getDuration()), ") ");
                    string = ((AudioFile)audioObject).getTag().getArtist() == null || ((AudioFile)audioObject).getTag().getArtist().equals("") ? StringUtils.getString(string, Artist.getUnknownArtist(), " ") : StringUtils.getString(string, ((AudioFile)audioObject).getTag().getArtist(), " ");
                    string = ((AudioFile)audioObject).getTag().getTitle() == null || ((AudioFile)audioObject).getTag().getTitle().equals("") ? StringUtils.getString(string, " - ", ((AudioFile)audioObject).getFile().getName()) : StringUtils.getString(string, " - ", ((AudioFile)audioObject).getTag().getTitle());
                }
                string = StringUtils.getString(string, " :", I18nUtils.getString("PLAYING"));
                this.setLeftStatusBarText(string, string);
            }
        } else if (audioObject instanceof PodcastFeedEntry && ((PodcastFeedEntry)audioObject).isDownloaded()) {
            this.updateStatusBar(StringUtils.getString(I18nUtils.getString("PLAYING"), ": ", audioObject.getTitle()));
        } else {
            this.updateStatusBar(StringUtils.getString(I18nUtils.getString("BUFFERING"), " ", audioObject.getTitle(), "..."));
        }
    }

    private void updateStatusBar(String string) {
        this.setLeftStatusBarText(string, string);
    }

    public void updateTitleBar(AudioObject audioObject) {
        if (audioObject != null) {
            if (audioObject instanceof Radio) {
                this.setTitleBar(StringUtils.getString(((Radio)audioObject).getName(), " (", ((Radio)audioObject).getUrl(), ")"));
                return;
            }
            if (audioObject instanceof PodcastFeedEntry) {
                this.setTitleBar(StringUtils.getString(((PodcastFeedEntry)audioObject).getTitle(), " (", ((PodcastFeedEntry)audioObject).getUrl(), ")"));
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (audioObject instanceof AudioFile && ((AudioFile)audioObject).getTag() == null) {
                stringBuilder.append(((AudioFile)audioObject).getFile().getName());
            } else {
                stringBuilder.append(audioObject.getTitleOrFileName());
                stringBuilder.append(" - ");
                stringBuilder.append(audioObject.getArtist());
                stringBuilder.append(" - ");
                stringBuilder.append(audioObject.getAlbum());
            }
            stringBuilder.append(" (");
            stringBuilder.append(StringUtils.seconds2String(audioObject.getDuration()));
            stringBuilder.append(")");
            this.setTitleBar(stringBuilder.toString());
        } else {
            this.setTitleBar("");
        }
    }

    @Override
    public void playbackStateChanged(final PlaybackState playbackState, final AudioObject audioObject) {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GuiHandler.this.playbackStateChangedEDT(playbackState, audioObject);
                }
            });
        } else {
            this.playbackStateChangedEDT(playbackState, audioObject);
        }
    }

    private void playbackStateChangedEDT(PlaybackState playbackState, AudioObject audioObject) {
        if (playbackState == PlaybackState.PAUSED) {
            this.setPlaying(false);
            this.updateStatusBar(I18nUtils.getString("PAUSED"));
            this.setTitleBar("");
            this.getPlayListTable().setPlayState(PlayListTable.PlayState.PAUSED);
        } else if (playbackState == PlaybackState.RESUMING) {
            this.setPlaying(true);
            this.updateStatusBar(PlayListHandler.getInstance().getCurrentAudioObjectFromCurrentPlayList());
            this.updateTitleBar(PlayListHandler.getInstance().getCurrentAudioObjectFromCurrentPlayList());
            this.getPlayListTable().setPlayState(PlayListTable.PlayState.PLAYING);
        } else if (playbackState == PlaybackState.PLAYING) {
            this.updateStatusBar(audioObject);
            this.updateTitleBar(audioObject);
            this.setPlaying(true);
            this.getPlayListTable().setPlayState(PlayListTable.PlayState.PLAYING);
        } else if (playbackState == PlaybackState.STOPPED) {
            this.setPlaying(false);
            this.updateStatusBar(I18nUtils.getString("STOPPED"));
            this.setTitleBar("");
            this.getPlayListTable().setPlayState(PlayListTable.PlayState.STOPPED);
        }
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
        this.showContextPanel(applicationState.isUseContext());
        this.getNavigationTreePanel().getTabbedPane().setTabPlacement(applicationState.isShowNavigatorTabsAtLeft() ? 2 : 1);
        this.getOSDDialog().setWidth(applicationState.getOsdWidth());
        this.getNavigationTreePanel().updateTabs();
        this.getContextPanel().updateContextTabsText();
        this.getPlayerControls().setShowTicksAndLabels(applicationState.isShowTicks());
        this.repaint();
    }

    public boolean isStatsDialogVisible() {
        return this.statsDialog != null && this.statsDialog.isVisible();
    }

    private static class RipperCancelAction
    implements ActionListener {
        private RipperCancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RipperHandler.getInstance().cancelProcess();
        }
    }
}

