/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.hotkeys;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.atunes.kernel.modules.hotkeys.Hotkey;

public class HotkeysConfig
implements Iterable<Hotkey> {
    private SortedMap<Integer, Hotkey> config;

    public HotkeysConfig() {
        this.config = new TreeMap<Integer, Hotkey>();
    }

    public HotkeysConfig(List<Hotkey> list) {
        this.config = new TreeMap<Integer, Hotkey>();
        for (Hotkey hotkey : list) {
            this.config.put(hotkey.getId(), hotkey);
        }
    }

    @ConstructorProperties(value={"config"})
    public HotkeysConfig(SortedMap<Integer, Hotkey> sortedMap) {
        this.config = new TreeMap<Integer, Hotkey>(sortedMap);
    }

    public void putHotkey(Hotkey hotkey) {
        this.config.put(hotkey.getId(), hotkey);
    }

    public Hotkey getHotkey(int n) {
        return (Hotkey)this.config.get(n);
    }

    public int size() {
        return this.config.size();
    }

    public SortedMap<Integer, Hotkey> getConfig() {
        return this.config;
    }

    @Override
    public Iterator<Hotkey> iterator() {
        return this.config.values().iterator();
    }

    public Hotkey getHotkeyByOrder(int n) {
        return new ArrayList<Hotkey>(this.config.values()).get(n);
    }

    public Set<Integer> conflicts() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < this.size(); ++i) {
            Hotkey hotkey = this.getHotkeyByOrder(i);
            for (int j = 0; j < this.size(); ++j) {
                Hotkey hotkey2 = this.getHotkeyByOrder(j);
                if (i == j || hotkey.getMod() != hotkey2.getMod() || hotkey.getKey() != hotkey2.getKey()) continue;
                hashSet.add(i);
            }
        }
        return hashSet;
    }

    public Set<Integer> notRecommendedKeys() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < this.size(); ++i) {
            Hotkey hotkey = this.getHotkeyByOrder(i);
            if (hotkey.isRecommended()) continue;
            hashSet.add(i);
        }
        return hashSet;
    }
}

