/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import net.sourceforge.atunes.kernel.modules.navigator.AbstractNavigationView;
import net.sourceforge.atunes.kernel.modules.navigator.TreeGenerator;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.model.TreeObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class AlbumTreeGenerator
implements TreeGenerator {
    @Override
    public void buildTree(String string, AbstractNavigationView abstractNavigationView, Map<String, ?> map, String string2, DefaultMutableTreeNode defaultMutableTreeNode, DefaultTreeModel defaultTreeModel, List<TreeObject> list, List<TreeObject> list2) {
        defaultMutableTreeNode.setUserObject(I18nUtils.getString(string));
        defaultMutableTreeNode.removeAllChildren();
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        if (ApplicationState.getInstance().isUseSmartTagViewSorting()) {
            Collections.sort(arrayList, abstractNavigationView.getSmartComparator());
        } else {
            Collections.sort(arrayList, abstractNavigationView.getDefaultComparator());
        }
        ArrayList<DefaultMutableTreeNode> arrayList2 = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Album album = (Album)map.get(arrayList.get(i));
            if (string2 != null && !album.getName().toUpperCase().contains(string2.toUpperCase())) continue;
            AlbumDefaultMutableTreeNode albumDefaultMutableTreeNode = new AlbumDefaultMutableTreeNode((Object)album);
            defaultMutableTreeNode.add(albumDefaultMutableTreeNode);
            if (!list.contains(albumDefaultMutableTreeNode.getUserObject())) continue;
            arrayList2.add(albumDefaultMutableTreeNode);
        }
        defaultTreeModel.reload();
        AbstractNavigationView.selectNodes(abstractNavigationView.getTree(), arrayList2);
    }

    protected static final class AlbumDefaultMutableTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = -1276777390072754207L;

        private AlbumDefaultMutableTreeNode(Object object) {
            super(object);
        }

        @Override
        public String toString() {
            return ((Album)this.getUserObject()).getNameAndArtist();
        }
    }
}

