/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.navigator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTreeCellDecorator;
import net.sourceforge.atunes.gui.views.controls.NavigationTree;
import net.sourceforge.atunes.gui.views.decorators.AlbumTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.ArtistTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.FolderTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.GenreTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.IncompleteTagsTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.StringTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.UnknownElementTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.YearTreeCellDecorator;
import net.sourceforge.atunes.gui.views.menus.EditTagMenu;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.AddToPlayListAction;
import net.sourceforge.atunes.kernel.actions.AddToPlayListAfterCurrentAudioObjectAction;
import net.sourceforge.atunes.kernel.actions.CopyToRepositoryAction;
import net.sourceforge.atunes.kernel.actions.EditTitlesAction;
import net.sourceforge.atunes.kernel.actions.ExtractPictureAction;
import net.sourceforge.atunes.kernel.actions.FillDeviceWithRandomSongsAction;
import net.sourceforge.atunes.kernel.actions.OpenFolderFromNavigatorAction;
import net.sourceforge.atunes.kernel.actions.PlayNowAction;
import net.sourceforge.atunes.kernel.actions.RemoveFromDiskAction;
import net.sourceforge.atunes.kernel.actions.SearchArtistAction;
import net.sourceforge.atunes.kernel.actions.SearchArtistAtAction;
import net.sourceforge.atunes.kernel.actions.SetAsPlayListAction;
import net.sourceforge.atunes.kernel.controllers.navigation.NavigationController;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumnSet;
import net.sourceforge.atunes.kernel.modules.device.DeviceHandler;
import net.sourceforge.atunes.kernel.modules.navigator.AbstractNavigationView;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.TreeObject;
import net.sourceforge.atunes.utils.I18nUtils;

public final class DeviceNavigationView
extends AbstractNavigationView {
    private List<AbstractTreeCellDecorator> decorators;
    private JTree deviceTree;
    private JPopupMenu deviceTreeMenu;
    private JPopupMenu deviceTableMenu;

    @Override
    public ImageIcon getIcon() {
        return Images.getImage("device.png");
    }

    @Override
    public String getTitle() {
        return I18nUtils.getString("DEVICE");
    }

    @Override
    public String getTooltip() {
        return I18nUtils.getString("DEVICE_TAB_TOOLTIP");
    }

    @Override
    public JTree getTree() {
        if (this.deviceTree == null) {
            this.deviceTree = new NavigationTree(new DefaultTreeModel(new DefaultMutableTreeNode(I18nUtils.getString("DEVICE"))));
            this.deviceTree.setToggleClickCount(0);
            this.deviceTree.setCellRenderer(this.getTreeRenderer());
        }
        return this.deviceTree;
    }

    @Override
    public JPopupMenu getTreePopupMenu() {
        if (this.deviceTreeMenu == null) {
            this.deviceTreeMenu = new JPopupMenu();
            this.deviceTreeMenu.add(this.getMenuItemForAction(AddToPlayListAction.class));
            this.deviceTreeMenu.add(this.getMenuItemForAction(SetAsPlayListAction.class));
            this.deviceTreeMenu.add(new JSeparator());
            this.deviceTreeMenu.add(this.getMenuItemForAction(OpenFolderFromNavigatorAction.class));
            this.deviceTreeMenu.add(new JSeparator());
            this.deviceTreeMenu.add(new EditTagMenu(false, this));
            this.deviceTreeMenu.add(Actions.getAction(EditTitlesAction.class));
            this.deviceTreeMenu.add(new JSeparator());
            this.deviceTreeMenu.add(new JMenuItem(Actions.getAction(RemoveFromDiskAction.class)));
            this.deviceTreeMenu.add(new JSeparator());
            this.deviceTreeMenu.add(this.getMenuItemForAction(CopyToRepositoryAction.class));
            this.deviceTreeMenu.add(new JMenuItem(Actions.getAction(FillDeviceWithRandomSongsAction.class)));
            this.deviceTreeMenu.add(new JSeparator());
            this.deviceTreeMenu.add(Actions.getAction(SearchArtistAction.class));
            this.deviceTreeMenu.add(Actions.getAction(SearchArtistAtAction.class));
        }
        return this.deviceTreeMenu;
    }

    @Override
    public JPopupMenu getTablePopupMenu() {
        if (this.deviceTableMenu == null) {
            this.deviceTableMenu = new JPopupMenu();
            this.deviceTableMenu.add(this.getMenuItemForAction(AddToPlayListAction.class));
            this.deviceTableMenu.add(this.getMenuItemForAction(AddToPlayListAfterCurrentAudioObjectAction.class));
            this.deviceTableMenu.add(this.getMenuItemForAction(SetAsPlayListAction.class));
            this.deviceTableMenu.add(new JMenuItem(Actions.getAction(PlayNowAction.class)));
            this.deviceTableMenu.add(new JSeparator());
            this.deviceTableMenu.add(new JMenuItem(Actions.getAction(OpenFolderFromNavigatorAction.class)));
            this.deviceTableMenu.add(new JSeparator());
            this.deviceTableMenu.add(new EditTagMenu(false, this));
            this.deviceTableMenu.add(this.getMenuItemForAction(ExtractPictureAction.class));
            this.deviceTableMenu.add(new JSeparator());
            this.deviceTableMenu.add(new JMenuItem(Actions.getAction(RemoveFromDiskAction.class)));
            this.deviceTableMenu.add(new JSeparator());
            this.deviceTableMenu.add(this.getMenuItemForAction(CopyToRepositoryAction.class));
        }
        return this.deviceTableMenu;
    }

    @Override
    protected Map<String, ?> getViewData(NavigationController.ViewMode viewMode) {
        Map<String, Object> map = viewMode == NavigationController.ViewMode.YEAR ? DeviceHandler.getInstance().getYearStructure() : (viewMode == NavigationController.ViewMode.GENRE ? DeviceHandler.getInstance().getDeviceGenreStructure() : (viewMode == NavigationController.ViewMode.FOLDER ? DeviceHandler.getInstance().getDeviceFolderStructure() : (viewMode == NavigationController.ViewMode.ALBUM ? DeviceHandler.getInstance().getDeviceAlbumStructure() : DeviceHandler.getInstance().getDeviceArtistStructure())));
        return map;
    }

    @Override
    protected void refreshTree(NavigationController.ViewMode viewMode, String string) {
        this.debug("Refreshing ", this.getClass().getName());
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getTree().getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        ArrayList<DefaultMutableTreeNode> arrayList2 = new ArrayList<DefaultMutableTreeNode>();
        List<TreeObject> list = DeviceNavigationView.getTreeObjectsSelected(this.getTree());
        List<TreeObject> list2 = DeviceNavigationView.getTreeObjectsExpanded(this.getTree(), defaultMutableTreeNode);
        defaultMutableTreeNode.removeAllChildren();
        viewMode.getTreeGenerator().buildTree("DEVICE", this, this.getViewData(viewMode), string, defaultMutableTreeNode, defaultTreeModel, list, list2);
        DeviceNavigationView.expandNodes(this.getTree(), arrayList2);
        DeviceNavigationView.selectNodes(this.getTree(), arrayList);
    }

    @Override
    public List<AudioObject> getAudioObjectForTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, NavigationController.ViewMode viewMode, String string) {
        ArrayList<AudioObject> arrayList = new ArrayList<AudioFile>();
        if (defaultMutableTreeNode.isRoot()) {
            if (string == null) {
                arrayList.addAll(DeviceHandler.getInstance().getAudioFilesList());
            } else {
                arrayList = new ArrayList();
                for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                    TreeObject treeObject = (TreeObject)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)).getUserObject();
                    arrayList.addAll(treeObject.getAudioObjects());
                }
            }
        } else {
            TreeObject treeObject = (TreeObject)defaultMutableTreeNode.getUserObject();
            arrayList = treeObject.getAudioObjects();
        }
        return arrayList;
    }

    @Override
    public boolean isUseDefaultNavigatorColumnSet() {
        return true;
    }

    @Override
    public AbstractColumnSet getCustomColumnSet() {
        return null;
    }

    @Override
    public boolean isViewModeSupported() {
        return true;
    }

    @Override
    protected List<AbstractTreeCellDecorator> getTreeCellDecorators() {
        if (this.decorators == null) {
            this.decorators = new ArrayList<AbstractTreeCellDecorator>();
            this.decorators.add(new ArtistTreeCellDecorator());
            this.decorators.add(new AlbumTreeCellDecorator());
            this.decorators.add(new GenreTreeCellDecorator());
            this.decorators.add(new YearTreeCellDecorator());
            this.decorators.add(new FolderTreeCellDecorator());
            this.decorators.add(new StringTreeCellDecorator());
            this.decorators.add(new UnknownElementTreeCellDecorator());
            this.decorators.add(new IncompleteTagsTreeCellDecorator());
        }
        return this.decorators;
    }
}

