/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.navigator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTreeCellDecorator;
import net.sourceforge.atunes.gui.model.NavigationTableModel;
import net.sourceforge.atunes.gui.views.controls.NavigationTree;
import net.sourceforge.atunes.gui.views.decorators.RadioTreeCellDecorator;
import net.sourceforge.atunes.gui.views.decorators.StringTreeCellDecorator;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.AddFavoriteRadioAction;
import net.sourceforge.atunes.kernel.actions.AddRadioAction;
import net.sourceforge.atunes.kernel.actions.AddToPlayListAction;
import net.sourceforge.atunes.kernel.actions.AddToPlayListAfterCurrentAudioObjectAction;
import net.sourceforge.atunes.kernel.actions.PlayNowAction;
import net.sourceforge.atunes.kernel.actions.RefreshRadioAction;
import net.sourceforge.atunes.kernel.actions.RemoveRadioAction;
import net.sourceforge.atunes.kernel.actions.RenameRadioAction;
import net.sourceforge.atunes.kernel.actions.RenameRadioLabelAction;
import net.sourceforge.atunes.kernel.actions.SetAsPlayListAction;
import net.sourceforge.atunes.kernel.actions.ShowNavigatorTableItemInfoAction;
import net.sourceforge.atunes.kernel.controllers.navigation.NavigationController;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumnSet;
import net.sourceforge.atunes.kernel.modules.navigator.AbstractCustomNavigatorColumnSet;
import net.sourceforge.atunes.kernel.modules.navigator.AbstractNavigationView;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.radio.RadioHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.TreeObject;
import net.sourceforge.atunes.utils.I18nUtils;

public final class RadioNavigationView
extends AbstractNavigationView {
    private List<AbstractTreeCellDecorator> decorators;
    private JTree radioTree;
    private JPopupMenu radioTreeMenu;
    private JPopupMenu radioTableMenu;
    private AbstractColumnSet columnSet;

    @Override
    public ImageIcon getIcon() {
        return Images.getImage("radio_little.png");
    }

    @Override
    public String getTitle() {
        return I18nUtils.getString("RADIO");
    }

    @Override
    public String getTooltip() {
        return I18nUtils.getString("RADIO_TAB_TOOLTIP");
    }

    @Override
    public JTree getTree() {
        if (this.radioTree == null) {
            this.radioTree = new NavigationTree(new DefaultTreeModel(new DefaultMutableTreeNode(I18nUtils.getString("RADIO"))));
            this.radioTree.setToggleClickCount(0);
            this.radioTree.setCellRenderer(this.getTreeRenderer());
            this.radioTree.setToolTipText(I18nUtils.getString("RADIO_VIEW_TOOLTIP"));
        }
        return this.radioTree;
    }

    @Override
    public JPopupMenu getTreePopupMenu() {
        if (this.radioTreeMenu == null) {
            this.radioTreeMenu = new JPopupMenu();
            this.radioTreeMenu.add(this.getMenuItemForAction(AddToPlayListAction.class));
            this.radioTreeMenu.add(this.getMenuItemForAction(SetAsPlayListAction.class));
            this.radioTreeMenu.add(new JSeparator());
            this.radioTreeMenu.add(new JMenuItem(Actions.getAction(AddRadioAction.class)));
            this.radioTreeMenu.add(new JMenuItem(Actions.getAction(RefreshRadioAction.class)));
            this.radioTreeMenu.add(this.getMenuItemForAction(AddFavoriteRadioAction.class));
            this.radioTreeMenu.add(new JMenuItem(Actions.getAction(RenameRadioAction.class)));
            this.radioTreeMenu.add(new JMenuItem(Actions.getAction(RenameRadioLabelAction.class)));
            this.radioTreeMenu.add(this.getMenuItemForAction(RemoveRadioAction.class));
        }
        return this.radioTreeMenu;
    }

    @Override
    public JPopupMenu getTablePopupMenu() {
        if (this.radioTableMenu == null) {
            this.radioTableMenu = new JPopupMenu();
            this.radioTableMenu.add(this.getMenuItemForAction(AddToPlayListAction.class));
            this.radioTableMenu.add(this.getMenuItemForAction(AddToPlayListAfterCurrentAudioObjectAction.class));
            this.radioTableMenu.add(this.getMenuItemForAction(SetAsPlayListAction.class));
            this.radioTableMenu.add(new JMenuItem(Actions.getAction(PlayNowAction.class)));
            this.radioTableMenu.add(new JSeparator());
            this.radioTableMenu.add(new JMenuItem(Actions.getAction(ShowNavigatorTableItemInfoAction.class)));
            this.radioTableMenu.add(new JSeparator());
            this.radioTableMenu.add(this.getMenuItemForAction(AddFavoriteRadioAction.class));
            this.radioTableMenu.add(this.getMenuItemForAction(RemoveRadioAction.class));
        }
        return this.radioTableMenu;
    }

    @Override
    protected Map<String, ?> getViewData(NavigationController.ViewMode viewMode) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("SHOW_ALL_STATIONS", ApplicationState.getInstance().isShowAllRadioStations());
        hashMap.put("RADIOS", RadioHandler.getInstance().getRadios());
        hashMap.put("PRESET_RADIOS", RadioHandler.getInstance().getRadioPresets());
        return hashMap;
    }

    @Override
    protected void refreshTree(NavigationController.ViewMode viewMode, String string) {
        this.debug("Refreshing ", this.getClass().getName());
        Map<String, ?> map = this.getViewData(viewMode);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getTree().getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        List<TreeObject> list = RadioNavigationView.getTreeObjectsSelected(this.getTree());
        List<TreeObject> list2 = RadioNavigationView.getTreeObjectsExpanded(this.getTree(), defaultMutableTreeNode);
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        ArrayList<DefaultMutableTreeNode> arrayList2 = new ArrayList<DefaultMutableTreeNode>();
        defaultMutableTreeNode.setUserObject(I18nUtils.getString("RADIO"));
        defaultMutableTreeNode.removeAllChildren();
        RadioNavigationView.addRadioNodes((List)map.get("RADIOS"), (List)map.get("PRESET_RADIOS"), defaultMutableTreeNode, string, (Boolean)map.get("SHOW_ALL_STATIONS"), list2, list, arrayList2, arrayList);
        defaultTreeModel.reload();
        RadioNavigationView.expandNodes(this.getTree(), arrayList2);
        RadioNavigationView.selectNodes(this.getTree(), arrayList);
    }

    @Override
    public List<AudioObject> getAudioObjectForTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, NavigationController.ViewMode viewMode, String string) {
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        if (defaultMutableTreeNode.isRoot()) {
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                arrayList.addAll(this.getAudioObjectForTreeNode((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), viewMode, string));
            }
        } else {
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof Radio) {
                Radio radio = (Radio)defaultMutableTreeNode.getUserObject();
                arrayList.add(radio);
            } else {
                for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                    Radio radio = (Radio)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)).getUserObject();
                    arrayList.add(radio);
                }
            }
        }
        return arrayList;
    }

    private static void addRadioNodes(List<Radio> list, List<Radio> list2, DefaultMutableTreeNode defaultMutableTreeNode, String string, boolean bl, List<TreeObject> list3, List<TreeObject> list4, List<DefaultMutableTreeNode> list5, List<DefaultMutableTreeNode> list6) {
        Object object;
        Object object22;
        if (list == null) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        for (Radio iterator2 : list) {
            if (string != null && !iterator2.getName().toUpperCase().contains(string.toUpperCase())) continue;
            object22 = new DefaultMutableTreeNode(iterator2);
            if (list4.contains(((DefaultMutableTreeNode)object22).getUserObject())) {
                list6.add((DefaultMutableTreeNode)object22);
            }
            if (list3.contains(((DefaultMutableTreeNode)object22).getUserObject())) {
                list5.add((DefaultMutableTreeNode)object22);
            }
            if (hashMap.containsKey(iterator2.getLabel()) && !iterator2.isRemoved()) {
                ((DefaultMutableTreeNode)hashMap.get(iterator2.getLabel())).add((MutableTreeNode)object22);
                continue;
            }
            if (iterator2.isRemoved()) {
                if (list2.isEmpty()) continue;
                list2.remove(iterator2);
                continue;
            }
            if (iterator2.getLabel() == null || iterator2.getLabel().trim().equals("")) {
                hashMap2.put(iterator2.getName(), object22);
                continue;
            }
            if (iterator2.isRemoved()) continue;
            object = new DefaultMutableTreeNode(iterator2.getLabel());
            ((DefaultMutableTreeNode)object).add((MutableTreeNode)object22);
            if (list4.contains(((DefaultMutableTreeNode)object).getUserObject())) {
                list6.add((DefaultMutableTreeNode)object);
            }
            if (list3.contains(((DefaultMutableTreeNode)object).getUserObject())) {
                list5.add((DefaultMutableTreeNode)object);
            }
            hashMap.put(iterator2.getLabel(), object);
        }
        if (list2 != null && bl) {
            for (Radio radio : list2) {
                if (string != null && !radio.getName().toUpperCase().contains(string.toUpperCase())) continue;
                object22 = new DefaultMutableTreeNode(radio);
                if (list4.contains(((DefaultMutableTreeNode)object22).getUserObject())) {
                    list6.add((DefaultMutableTreeNode)object22);
                }
                if (list3.contains(((DefaultMutableTreeNode)object22).getUserObject())) {
                    list5.add((DefaultMutableTreeNode)object22);
                }
                if (hashMap.containsKey(radio.getLabel()) && !radio.isRemoved()) {
                    ((DefaultMutableTreeNode)hashMap.get(radio.getLabel())).add((MutableTreeNode)object22);
                    continue;
                }
                if (radio.isRemoved()) {
                    RadioHandler.getInstance().removeRadio(radio);
                    continue;
                }
                if (radio.getLabel() == null || radio.getLabel().trim().equals("")) {
                    hashMap2.put(radio.getName(), object22);
                    continue;
                }
                if (radio.isRemoved()) continue;
                object = new DefaultMutableTreeNode(radio.getLabel());
                ((DefaultMutableTreeNode)object).add((MutableTreeNode)object22);
                if (list4.contains(((DefaultMutableTreeNode)object).getUserObject())) {
                    list6.add((DefaultMutableTreeNode)object);
                }
                if (list3.contains(((DefaultMutableTreeNode)object).getUserObject())) {
                    list5.add((DefaultMutableTreeNode)object);
                }
                hashMap.put(radio.getLabel(), object);
            }
        }
        Iterator<Radio> iterator3 = RadioHandler.getInstance().sortRadioLabels();
        Iterator iterator = iterator3.iterator();
        block2: while (iterator.hasNext()) {
            object22 = (String)iterator.next();
            for (DefaultMutableTreeNode defaultMutableTreeNode2 : hashMap.values()) {
                if (!defaultMutableTreeNode2.toString().equals(object22)) continue;
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                continue block2;
            }
        }
        for (Object object22 : hashMap2.values()) {
            defaultMutableTreeNode.add((MutableTreeNode)object22);
        }
    }

    @Override
    public boolean isUseDefaultNavigatorColumnSet() {
        return false;
    }

    @Override
    public AbstractColumnSet getCustomColumnSet() {
        if (this.columnSet == null) {
            this.columnSet = new RadioNavigationColumnSet(this.getClass().getName());
        }
        return this.columnSet;
    }

    @Override
    public boolean isViewModeSupported() {
        return false;
    }

    @Override
    protected List<AbstractTreeCellDecorator> getTreeCellDecorators() {
        if (this.decorators == null) {
            this.decorators = new ArrayList<AbstractTreeCellDecorator>();
            this.decorators.add(new StringTreeCellDecorator());
            this.decorators.add(new RadioTreeCellDecorator());
        }
        return this.decorators;
    }

    private static final class RadioNavigationColumnSet
    extends AbstractCustomNavigatorColumnSet {
        public RadioNavigationColumnSet(String string) {
            super(string);
        }

        @Override
        protected List<AbstractColumn> getAllowedColumns() {
            ArrayList<AbstractColumn> arrayList = new ArrayList<AbstractColumn>();
            EmptyColumn emptyColumn = new EmptyColumn("", NavigationTableModel.Property.class);
            emptyColumn.setVisible(true);
            emptyColumn.setWidth(20);
            emptyColumn.setResizable(false);
            arrayList.add(emptyColumn);
            NameColumn nameColumn = new NameColumn("NAME", String.class);
            nameColumn.setVisible(true);
            nameColumn.setWidth(150);
            nameColumn.setUsedForFilter(true);
            arrayList.add(nameColumn);
            UrlColumn urlColumn = new UrlColumn("URL", String.class);
            urlColumn.setVisible(true);
            urlColumn.setWidth(400);
            urlColumn.setUsedForFilter(true);
            arrayList.add(urlColumn);
            return arrayList;
        }

        private static final class EmptyColumn
        extends AbstractColumn {
            private static final long serialVersionUID = 3613237620716484881L;

            private EmptyColumn(String string, Class<?> clazz) {
                super(string, clazz);
            }

            @Override
            protected int ascendingCompare(AudioObject audioObject, AudioObject audioObject2) {
                return 0;
            }

            @Override
            public Object getValueFor(AudioObject audioObject) {
                return NavigationTableModel.Property.NO_PROPERTIES;
            }
        }

        private static final class NameColumn
        extends AbstractColumn {
            private static final long serialVersionUID = 3613237620716484881L;

            private NameColumn(String string, Class<?> clazz) {
                super(string, clazz);
            }

            @Override
            public Object getValueFor(AudioObject audioObject) {
                return ((Radio)audioObject).getName();
            }

            @Override
            protected int ascendingCompare(AudioObject audioObject, AudioObject audioObject2) {
                return ((Radio)audioObject).getName().compareTo(((Radio)audioObject2).getName());
            }
        }

        private static final class UrlColumn
        extends AbstractColumn {
            private static final long serialVersionUID = -1615880013918017198L;

            private UrlColumn(String string, Class<?> clazz) {
                super(string, clazz);
            }

            @Override
            protected int ascendingCompare(AudioObject audioObject, AudioObject audioObject2) {
                return audioObject.getUrl().compareTo(audioObject2.getUrl());
            }

            @Override
            public Object getValueFor(AudioObject audioObject) {
                return audioObject.getUrl();
            }
        }
    }
}

