/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.pattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.EditTagInfo;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.commonjukebox.plugins.model.PluginApi;

@PluginApi
public abstract class AbstractPattern {
    private static final char PATTERN_NAME_FIRST_CHAR = '%';
    private static List<AbstractPattern> patterns;
    private static final AbstractPattern ANY_PATTERN;
    private String pattern;
    private String name;
    private boolean massiveRecognitionPattern = false;
    private boolean recognitionPattern = false;

    public static List<AbstractPattern> getPatterns() {
        if (patterns == null) {
            patterns = new ArrayList<AbstractPattern>();
            patterns.add(ANY_PATTERN);
            patterns.add(new AbstractPattern('T', "TITLE", true, false){

                @Override
                public String getAudioFileStringValue(AudioFile audioFile) {
                    return audioFile.getTitleOrFileName();
                }
            });
            patterns.add(new AbstractPattern('A', "ARTIST", true, true){

                @Override
                public String getAudioFileStringValue(AudioFile audioFile) {
                    return audioFile.getArtist();
                }
            });
            patterns.add(new AbstractPattern('L', "ALBUM", true, true){

                @Override
                public String getAudioFileStringValue(AudioFile audioFile) {
                    return audioFile.getAlbum();
                }
            });
            patterns.add(new AbstractPattern('R', "ALBUM_ARTIST", true, true){

                @Override
                public String getAudioFileStringValue(AudioFile audioFile) {
                    return audioFile.getAlbumArtist();
                }
            });
            patterns.add(new AbstractPattern('N', "TRACK", true, false){

                @Override
                public String getAudioFileStringValue(AudioFile audioFile) {
                    String string = String.valueOf(audioFile.getTrackNumber());
                    return string.length() < 2 ? StringUtils.getString("0", string) : string;
                }
            });
            patterns.add(new AbstractPattern('G', "GENRE", true, true){

                @Override
                public String getAudioFileStringValue(AudioFile audioFile) {
                    return audioFile.getGenre();
                }
            });
            patterns.add(new AbstractPattern('Y', "YEAR", true, true){

                @Override
                public String getAudioFileStringValue(AudioFile audioFile) {
                    return audioFile.getYear();
                }
            });
            patterns.add(new AbstractPattern('C', "COMPOSER", true, true){

                @Override
                public String getAudioFileStringValue(AudioFile audioFile) {
                    return audioFile.getComposer();
                }
            });
            patterns.add(new AbstractPattern('S', "ARTIST_FIRST_CHAR", false, false){

                @Override
                public String getAudioFileStringValue(AudioFile audioFile) {
                    return audioFile.getArtist().substring(0, 1);
                }
            });
            patterns.add(new AbstractPattern('D', "DISC_NUMBER", true, true){

                @Override
                public String getAudioFileStringValue(AudioFile audioFile) {
                    return String.valueOf(audioFile.getDiscNumber());
                }
            });
        }
        return patterns;
    }

    public static List<AbstractPattern> getMassiveRecognitionPatterns() {
        ArrayList<AbstractPattern> arrayList = new ArrayList<AbstractPattern>();
        for (AbstractPattern abstractPattern : AbstractPattern.getPatterns()) {
            if (!abstractPattern.massiveRecognitionPattern) continue;
            arrayList.add(abstractPattern);
        }
        return arrayList;
    }

    public static List<AbstractPattern> getRecognitionPatterns() {
        ArrayList<AbstractPattern> arrayList = new ArrayList<AbstractPattern>();
        for (AbstractPattern abstractPattern : AbstractPattern.getPatterns()) {
            if (!abstractPattern.recognitionPattern) continue;
            arrayList.add(abstractPattern);
        }
        return arrayList;
    }

    protected AbstractPattern(char c, String string, boolean bl, boolean bl2) {
        this.pattern = StringUtils.getString(Character.valueOf('%'), Character.valueOf(c)).toUpperCase();
        this.name = string;
        this.recognitionPattern = bl;
        this.massiveRecognitionPattern = bl2;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return I18nUtils.getString(this.name);
    }

    public String applyPattern(String string, AudioFile audioFile) {
        if (!this.pattern.equals(AbstractPattern.ANY_PATTERN.pattern)) {
            return string.replaceAll(this.pattern, this.getAudioFileStringValue(audioFile));
        }
        return string;
    }

    public abstract String getAudioFileStringValue(AudioFile var1);

    public static String applyPatternTransformations(String string, AudioFile audioFile) {
        String string2 = string;
        for (AbstractPattern abstractPattern : AbstractPattern.getPatterns()) {
            string2 = abstractPattern.applyPattern(string2, audioFile);
        }
        return string2;
    }

    public static EditTagInfo getEditTagInfoFromMatches(Map<String, String> map) {
        EditTagInfo editTagInfo = new EditTagInfo();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            editTagInfo.put(entry.getKey(), entry.getValue());
        }
        return editTagInfo;
    }

    public static Map<String, String> getPatternMatches(String string, String string2, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string == null || string2 == null) {
            return hashMap;
        }
        String string3 = string.trim();
        String[] stringArray = string3.split(StringUtils.getString(Character.valueOf('%'), Character.valueOf('.')));
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string4 = null;
        String string5 = null;
        while (n2 < string3.length() && n < string2.length()) {
            if (n3 < stringArray.length) {
                if (stringArray[n3].isEmpty()) {
                    ++n3;
                    continue;
                }
                int n4 = string3.indexOf(stringArray[n3], n2);
                int n5 = string2.indexOf(stringArray[n3], n);
                if (n4 == -1) break;
                if (n5 == -1) {
                    n5 = string2.length();
                }
                string4 = string3.substring(n2, n4);
                string5 = string2.substring(n, n5);
                n2 = n2 + string4.length() + stringArray[n3].length();
                n = n + string5.length() + stringArray[n3].length();
                ++n3;
            } else {
                string4 = string3.substring(n2);
                string5 = string2.substring(n);
                n2 += string4.length();
            }
            string4 = string4.toUpperCase();
            if (!string4.equals(ANY_PATTERN.getPattern()) && hashMap.containsKey(string4)) {
                return new HashMap<String, String>();
            }
            if (string4.equals(ANY_PATTERN.getPattern())) continue;
            hashMap.put(string4, string5.trim());
        }
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        List<AbstractPattern> list = bl ? AbstractPattern.getMassiveRecognitionPatterns() : AbstractPattern.getPatterns();
        for (AbstractPattern abstractPattern : list) {
            if (!hashMap.containsKey(abstractPattern.getPattern())) continue;
            hashMap2.put(abstractPattern.getName(), (String)hashMap.get(abstractPattern.getPattern()));
        }
        return hashMap2;
    }

    static {
        ANY_PATTERN = new AbstractPattern('?', "ANY", true, true){

            @Override
            public String getAudioFileStringValue(AudioFile audioFile) {
                return null;
            }
        };
    }
}

