/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.player;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.Kernel;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.notify.NotifyHandler;
import net.sourceforge.atunes.kernel.modules.player.AbstractPlayerEngine;
import net.sourceforge.atunes.kernel.modules.player.Equalizer;
import net.sourceforge.atunes.kernel.modules.player.PlaybackState;
import net.sourceforge.atunes.kernel.modules.player.PlaybackStateListener;
import net.sourceforge.atunes.kernel.modules.player.PlayerEngineCapability;
import net.sourceforge.atunes.kernel.modules.player.mplayer.MPlayerEngine;
import net.sourceforge.atunes.kernel.modules.player.xine.XineEngine;
import net.sourceforge.atunes.kernel.modules.plugins.PluginsHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.apache.commons.lang.ArrayUtils;
import org.commonjukebox.plugins.exceptions.PluginSystemException;
import org.commonjukebox.plugins.model.Plugin;
import org.commonjukebox.plugins.model.PluginInfo;
import org.commonjukebox.plugins.model.PluginListener;

public final class PlayerHandler
extends AbstractHandler
implements PluginListener,
PlaybackStateListener {
    private static PlayerHandler instance;
    public static final String DEFAULT_ENGINE = "MPlayer";
    private static String[] engineNames;
    private AbstractPlayerEngine playerEngine;
    private PlaybackState playbackState;

    private PlayerHandler() {
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
    }

    @Override
    public void applicationStarted() {
        PlayerHandler.getInstance().playerEngine.callPlaybackStateListeners(PlaybackState.STOPPED);
        if (ApplicationState.getInstance().isPlayAtStartup()) {
            this.playCurrentAudioObject(true);
        }
    }

    public boolean isEnginePlaying() {
        return this.playerEngine.isEnginePlaying();
    }

    public void setVolume(int n) {
        this.playerEngine.setVolume(n);
    }

    public void applyMuteState(boolean bl) {
        this.playerEngine.applyMuteState(bl);
    }

    public void applyNormalization() {
        this.playerEngine.applyNormalization();
    }

    public boolean supportsCapability(PlayerEngineCapability playerEngineCapability) {
        return this.playerEngine.supportsCapability(playerEngineCapability);
    }

    void applyEqualization(float[] fArray) {
        this.playerEngine.applyEqualization(fArray);
    }

    float[] transformEqualizerValues(float[] fArray) {
        return this.playerEngine.transformEqualizerValues(fArray);
    }

    public void addPlaybackStateListener(PlaybackStateListener playbackStateListener) {
        this.playerEngine.addPlaybackStateListener(playbackStateListener);
    }

    public void removePlaybackStateListener(PlaybackStateListener playbackStateListener) {
        this.playerEngine.removePlaybackStateListener(playbackStateListener);
    }

    public final void playCurrentAudioObject(boolean bl) {
        this.playerEngine.playCurrentAudioObject(bl);
    }

    public final void stopCurrentAudioObject(boolean bl) {
        this.playerEngine.stopCurrentAudioObject(bl);
    }

    public final void playPreviousAudioObject() {
        this.playerEngine.playPreviousAudioObject();
    }

    public final void playNextAudioObject() {
        this.playerEngine.playNextAudioObject(false);
    }

    public final void seekCurrentAudioObject(long l) {
        this.playerEngine.seekCurrentAudioObject(l);
    }

    public final void volumeDown() {
        this.playerEngine.volumeDown();
    }

    public final void volumeUp() {
        this.playerEngine.volumeUp();
    }

    @Override
    public void applicationFinish() {
        PlayerHandler.getInstance().stopCurrentAudioObject(true);
        this.playerEngine.finishPlayer();
    }

    public Equalizer getEqualizer() {
        return this.playerEngine.getEqualizer();
    }

    private static List<AbstractPlayerEngine> getEngines() {
        ArrayList<AbstractPlayerEngine> arrayList = new ArrayList<AbstractPlayerEngine>();
        arrayList.add(new MPlayerEngine());
        arrayList.add(new XineEngine());
        return arrayList;
    }

    public AudioObject getAudioObject() {
        return this.playerEngine.getAudioObject();
    }

    public static final synchronized PlayerHandler getInstance() {
        if (instance == null) {
            instance = new PlayerHandler();
            List<AbstractPlayerEngine> list = PlayerHandler.getEngines();
            Iterator<AbstractPlayerEngine> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().isEngineAvailable()) continue;
                iterator.remove();
            }
            engineNames = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                PlayerHandler.engineNames[i] = list.get(i).getEngineName();
            }
            Arrays.sort(engineNames);
            PlayerHandler.getLogger().info("PLAYER      ", "List of availables engines : " + ArrayUtils.toString((Object)engineNames));
            if (list.isEmpty()) {
                PlayerHandler.handlePlayerError(new IllegalStateException(I18nUtils.getString("NO_PLAYER_ENGINE")));
            } else {
                String string = ApplicationState.getInstance().getPlayerEngine();
                if (!ArrayUtils.contains((Object[])engineNames, (Object)string)) {
                    PlayerHandler.getLogger().info("PLAYER      ", string + " is not availaible");
                    string = ArrayUtils.contains((Object[])engineNames, (Object)DEFAULT_ENGINE) ? DEFAULT_ENGINE : list.iterator().next().getEngineName();
                    ApplicationState.getInstance().setPlayerEngine(string);
                }
                for (AbstractPlayerEngine abstractPlayerEngine : list) {
                    if (!abstractPlayerEngine.getEngineName().equals(string)) continue;
                    PlayerHandler.instance.playerEngine = abstractPlayerEngine;
                    PlayerHandler.getLogger().info("PLAYER      ", "Engine initialized : " + string);
                }
                if (PlayerHandler.instance.playerEngine == null) {
                    PlayerHandler.handlePlayerError(new IllegalStateException(I18nUtils.getString("NO_PLAYER_ENGINE")));
                }
                PlayerHandler.instance.playerEngine.initializePlayerEngine();
                Kernel.getInstance().addFinishListener(instance);
                PlayerHandler.instance.playerEngine.addPlaybackStateListener(PlayerHandler.instance.playerEngine);
                PlayerHandler.instance.playerEngine.addPlaybackStateListener(GuiHandler.getInstance());
                PlayerHandler.instance.playerEngine.addPlaybackStateListener(NotifyHandler.getInstance());
                PlayerHandler.instance.playerEngine.addPlaybackStateListener(instance);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    PlayerHandler.getLogger().debug("SHUTDOWN    ", "Final check for Zombie player engines");
                    instance.playerEngine.killPlayer();
                    PlayerHandler.getLogger().debug("SHUTDOWN    ", "Closing player ...");
                }
            }));
        }
        return instance;
    }

    @Override
    public void initHandler() {
    }

    private static void handlePlayerError(Throwable throwable) {
        PlayerHandler.getLogger().error("PLAYER      ", StringUtils.getString("Player Error: ", throwable));
        PlayerHandler.getLogger().error("PLAYER      ", throwable);
        GuiHandler.getInstance().showErrorDialog(throwable.getMessage());
    }

    public final String[] getEngineNames() {
        return engineNames != null ? Arrays.copyOf(engineNames, engineNames.length) : null;
    }

    public void pluginActivated(PluginInfo pluginInfo) {
        try {
            PlaybackStateListener playbackStateListener = (PlaybackStateListener)PluginsHandler.getInstance().getNewInstance(pluginInfo);
            this.addPlaybackStateListener(playbackStateListener);
        }
        catch (PluginSystemException pluginSystemException) {
            PlayerHandler.getLogger().error("PLUGINS     ", (Object)pluginSystemException);
        }
    }

    public void pluginDeactivated(PluginInfo pluginInfo, Collection<Plugin> collection) {
        PlayerHandler.getLogger().info("PLUGINS     ", StringUtils.getString("Plugin deactivated: ", pluginInfo.getName(), " (", pluginInfo.getClassName(), ")"));
        for (Plugin plugin : collection) {
            PlayerHandler.getInstance().removePlaybackStateListener((PlaybackStateListener)plugin);
        }
    }

    @Override
    public void playbackStateChanged(PlaybackState playbackState, AudioObject audioObject) {
        this.playbackState = playbackState;
    }

    public PlaybackState getPlaybackState() {
        return this.playbackState;
    }

    public long getCurrentAudioObjectPlayedTime() {
        return PlayerHandler.instance.playerEngine.getCurrentAudioObjectPlayedTime();
    }

    public long getCurrentAudioObjectLength() {
        return PlayerHandler.instance.playerEngine.getCurrentAudioObjectLength();
    }
}

