/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.player.gstreamer;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.player.AbstractPlayerEngine;
import net.sourceforge.atunes.kernel.modules.player.PlayerEngineCapability;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.model.AudioObject;
import org.gstreamer.Bus;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.GstObject;
import org.gstreamer.elements.PlayBin;

public class GStreamerEngine
extends AbstractPlayerEngine {
    private PlayBin playBin;
    private Runnable remainingTimeRunnable;
    private ScheduledFuture<?> scheduledFuture;

    public GStreamerEngine() {
        try {
            Gst.init((String)"AudioPlayer", (String[])new String[0]);
            this.playBin = new PlayBin("AudioPlayer");
            this.playBin.setVideoSink(ElementFactory.make((String)"fakesink", (String)"videosink"));
        }
        catch (Throwable throwable) {
            this.getLogger().error("PLAYER      ", "GStreamer is not supported");
        }
        this.remainingTimeRunnable = new Runnable(){

            @Override
            public void run() {
                final long l = GStreamerEngine.this.playBin.queryPosition().toMillis();
                final long l2 = GStreamerEngine.this.playBin.queryDuration().toMillis();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GStreamerEngine.this.setCurrentAudioObjectPlayedTime(l);
                        if (l2 > 0L) {
                            GStreamerEngine.this.setCurrentAudioObjectLength(l2);
                        }
                    }
                });
            }
        };
    }

    @Override
    protected void applyEqualization(float[] fArray) {
    }

    @Override
    public void applyMuteState(boolean bl) {
        if (bl) {
            this.playBin.setVolumePercent(0);
        } else {
            this.playBin.setVolumePercent(ApplicationState.getInstance().getVolume());
        }
    }

    @Override
    public void applyNormalization() {
    }

    @Override
    protected void finishPlayer() {
        this.playBin.stop();
    }

    @Override
    protected String getEngineName() {
        return "GStreamer";
    }

    @Override
    protected boolean isEngineAvailable() {
        try {
            Gst.init();
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isEnginePlaying() {
        return this.playBin.isPlaying();
    }

    @Override
    protected void killPlayer() {
        this.playBin.dispose();
    }

    @Override
    protected void pausePlayback() {
        this.playBin.pause();
    }

    @Override
    protected void resumePlayback() {
        this.playBin.play();
    }

    @Override
    protected void seekTo(long l) {
        this.playBin.seek(l, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setVolume(int n) {
        if (!this.isMuteEnabled()) {
            this.playBin.setVolumePercent(n);
        }
    }

    @Override
    protected void startPlayback(AudioObject audioObject, AudioObject audioObject2) {
        if (audioObject instanceof AudioFile) {
            this.playBin.setInputFile(new File(audioObject.getUrl()));
        } else {
            try {
                this.playBin.setURI(new URI(audioObject.getUrl()));
            }
            catch (URISyntaxException uRISyntaxException) {
                this.getLogger().error("PLAYER      ", uRISyntaxException);
            }
        }
        this.playBin.getBus().connect(new Bus.EOS(){

            public void endOfStream(GstObject gstObject) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GStreamerEngine.this.currentAudioObjectFinished(true, new String[0]);
                    }
                });
            }
        });
        this.playBin.play();
        ScheduledExecutorService scheduledExecutorService = Gst.getScheduledExecutorService();
        this.scheduledFuture = scheduledExecutorService.scheduleWithFixedDelay(this.remainingTimeRunnable, 0L, 100L, TimeUnit.MILLISECONDS);
        GuiHandler.getInstance().updateStatusBar(audioObject);
        GuiHandler.getInstance().updateTitleBar(audioObject);
    }

    @Override
    protected void stopPlayback(boolean bl, boolean bl2) {
        this.stopTimeRunnable();
        this.playBin.stop();
    }

    private void stopTimeRunnable() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
    }

    @Override
    public boolean supportsCapability(PlayerEngineCapability playerEngineCapability) {
        return false;
    }

    @Override
    protected float[] transformEqualizerValues(float[] fArray) {
        return fArray;
    }
}

