/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.player.mplayer;

import net.sourceforge.atunes.kernel.modules.player.mplayer.MPlayerCommandWriter;
import net.sourceforge.atunes.kernel.modules.player.mplayer.MPlayerEngine;
import net.sourceforge.atunes.misc.log.Logger;

class FadeAwayRunnable
implements Runnable {
    private Logger logger;
    private Process process;
    private MPlayerCommandWriter commandWriter;
    private int initialVolume;
    private boolean interrupted = false;
    private MPlayerEngine handler;

    FadeAwayRunnable(Process process, int n, MPlayerEngine mPlayerEngine) {
        this.process = process;
        this.initialVolume = n;
        this.handler = mPlayerEngine;
        this.commandWriter = new MPlayerCommandWriter(process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.getLogger().debug("PLAYER      ", "Fade away runnable started");
        try {
            int n = this.initialVolume;
            for (int i = 0; !this.interrupted && i < 50 && n > 0; ++i) {
                this.commandWriter.sendVolumeCommand(n -= 2);
                try {
                    Thread.sleep(25L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    this.getLogger().error("PLAYER      ", interruptedException);
                }
            }
            this.process.destroy();
        }
        catch (Throwable throwable) {
            this.process.destroy();
            this.getLogger().debug("PLAYER      ", "Fade away runnable finished");
            throw throwable;
        }
        this.getLogger().debug("PLAYER      ", "Fade away runnable finished");
        if (!this.interrupted) {
            this.handler.finishedFadeAway();
        }
    }

    void finish() {
        this.interrupted = true;
        this.handler.finishedFadeAway();
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

