/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.playlist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.atunes.kernel.modules.playlist.PlayList;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListAudioObject;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListChangedListener;
import net.sourceforge.atunes.kernel.modules.playlist.PlaybackHistory;
import net.sourceforge.atunes.kernel.modules.playlist.ShufflePointedList;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.model.AudioObject;

final class PlayListMode
implements PlayListChangedListener {
    private ShufflePointedList shufflePlayList = new ShufflePointedList();
    private PlaybackHistory playbackHistory = new PlaybackHistory();
    private PlayList playList;

    protected static PlayListMode getPlayListMode(PlayList playList) {
        return new PlayListMode(playList);
    }

    private PlayListMode(PlayList playList) {
        this.playList = playList;
        if (playList != null && playList.getAudioObjects() != null && !playList.getAudioObjects().isEmpty()) {
            this.audioObjectsAdded(PlayListAudioObject.getList(0, playList.getAudioObjects()));
            int n = playList.getCurrentAudioObjectIndex();
            int n2 = this.shufflePlayList.indexOf(n);
            if (n2 != -1) {
                Collections.swap(this.shufflePlayList.getList(), 0, n2);
            }
        }
    }

    AudioObject moveToPreviousAudioObject() {
        if (this.playList.isEmpty()) {
            return null;
        }
        AudioObject audioObject = this.playbackHistory.moveToPreviousInHistory();
        if (audioObject != null) {
            int n = this.playList.indexOf(audioObject);
            this.playList.getPointedList().setPointer(n);
            return audioObject;
        }
        if (this.isShuffle()) {
            Integer n = (Integer)this.shufflePlayList.moveToPreviousObject();
            if (n == null) {
                return null;
            }
            this.playList.setCurrentAudioObjectIndex(n);
            return this.playList.get(n);
        }
        AudioObject audioObject2 = this.playList.getPointedList().moveToPreviousObject();
        this.playList.updateUI();
        return audioObject2;
    }

    AudioObject moveToNextAudioObject() {
        if (this.playList.isEmpty()) {
            return null;
        }
        AudioObject audioObject = this.playbackHistory.moveToNextInHistory();
        if (audioObject != null) {
            int n = this.playList.indexOf(audioObject);
            this.playList.getPointedList().setPointer(n);
            return audioObject;
        }
        if (this.isShuffle()) {
            Integer n = (Integer)this.shufflePlayList.moveToNextObject();
            if (n == null) {
                return null;
            }
            this.playList.setCurrentAudioObjectIndex(n);
            return this.playList.get(n);
        }
        AudioObject audioObject2 = this.playList.getPointedList().moveToNextObject();
        this.playList.updateUI();
        return audioObject2;
    }

    AudioObject getPreviousAudioObject(int n) {
        if (this.playList.isEmpty()) {
            return null;
        }
        AudioObject audioObject = this.playbackHistory.getPreviousInHistory(n);
        if (audioObject != null) {
            return audioObject;
        }
        if (this.isShuffle()) {
            Integer n2 = (Integer)this.shufflePlayList.getPreviousObject(n);
            if (n2 == null) {
                return null;
            }
            return this.playList.get(n2);
        }
        return this.playList.getPointedList().getPreviousObject(n);
    }

    AudioObject getNextAudioObject(int n) {
        if (this.playList.isEmpty()) {
            return null;
        }
        AudioObject audioObject = this.playbackHistory.getNextInHistory(n);
        if (audioObject != null) {
            return audioObject;
        }
        if (this.isShuffle()) {
            Integer n2 = (Integer)this.shufflePlayList.getNextObject(n);
            if (n2 == null) {
                return null;
            }
            return this.playList.get(n2);
        }
        return this.playList.getPointedList().getNextObject(n);
    }

    @Override
    public void audioObjectsAdded(List<PlayListAudioObject> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.shufflePlayList.add(list);
    }

    @Override
    public void audioObjectsRemoved(List<PlayListAudioObject> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (PlayListAudioObject object : list) {
            int playListAudioObject = this.shufflePlayList.indexOf(object.getPosition());
            this.shufflePlayList.remove(playListAudioObject);
        }
        ArrayList arrayList = new ArrayList();
        for (PlayListAudioObject playListAudioObject : list) {
            if (this.playList.contains(playListAudioObject.getAudioObject())) continue;
            arrayList.add(playListAudioObject.getAudioObject());
        }
        this.playbackHistory.remove(arrayList);
    }

    @Override
    public void audioObjectsRemovedAll() {
        this.shufflePlayList.clear();
        this.playbackHistory.clear();
    }

    private boolean isShuffle() {
        return ApplicationState.getInstance().isShuffle();
    }

    void addToPlaybackHistory(AudioObject audioObject) {
        this.playbackHistory.addToHistory(audioObject);
    }
}

