/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.radio;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.navigator.RadioNavigationView;
import net.sourceforge.atunes.kernel.modules.proxy.Proxy;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.state.ApplicationStateHandler;
import net.sourceforge.atunes.kernel.modules.state.beans.ProxyBean;
import net.sourceforge.atunes.utils.NetworkUtils;
import net.sourceforge.atunes.utils.XMLUtils;

public final class RadioHandler
extends AbstractHandler {
    private static RadioHandler instance = new RadioHandler();
    private List<Radio> radios;
    private List<Radio> presetRadios;
    private List<Radio> retrievedPresetRadios = new ArrayList<Radio>();
    private boolean noNewStations = true;
    private boolean radioListDirty = false;

    private RadioHandler() {
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
    }

    @Override
    protected void initHandler() {
    }

    @Override
    public void applicationStarted() {
    }

    public static RadioHandler getInstance() {
        return instance;
    }

    public void addRadio() {
        Radio radio = GuiHandler.getInstance().showAddRadioDialog();
        if (radio != null) {
            this.addRadio(radio);
        }
    }

    public void addRadio(Radio radio) {
        RadioHandler.getLogger().info("HANDLER     ", "Adding radio");
        if (radio != null && !this.getRadios().contains(radio)) {
            this.getRadios().add(radio);
            this.radioListDirty = true;
        }
        Collections.sort(this.getRadios(), Radio.getComparator());
        NavigationHandler.getInstance().refreshView(RadioNavigationView.class);
    }

    @Override
    public void applicationFinish() {
        if (this.radioListDirty) {
            ApplicationStateHandler.getInstance().persistRadioCache(this.getRadios());
            if (!this.noNewStations) {
                ApplicationStateHandler.getInstance().persistPresetRadioCache(this.presetRadios);
            }
        } else {
            RadioHandler.getLogger().info("HANDLER     ", "Radio list is clean");
        }
    }

    @Override
    protected Runnable getPreviousInitializationTask() {
        return new Runnable(){

            @Override
            public void run() {
                RadioHandler.this.radios = ApplicationStateHandler.getInstance().retrieveRadioCache();
                RadioHandler.this.presetRadios = ApplicationStateHandler.getInstance().retrieveRadioPreset();
            }
        };
    }

    public List<Radio> getRadios() {
        return this.radios;
    }

    public List<Radio> getRadioPresets() {
        if (this.noNewStations) {
            this.noNewStations = this.presetRadios.containsAll(this.retrievedPresetRadios);
            this.retrievedPresetRadios.removeAll(this.presetRadios);
        } else {
            this.retrievedPresetRadios.removeAll(this.presetRadios);
        }
        this.presetRadios.addAll(this.retrievedPresetRadios);
        this.presetRadios.removeAll(this.getRadios());
        return new ArrayList<Radio>(this.presetRadios);
    }

    public List<Radio> getRadios(String string) {
        return new ArrayList<Radio>(this.getRadios());
    }

    public List<String> sortRadioLabels() {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Radio object : this.getRadios()) {
            string = object.getLabel();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        for (Radio radio : this.presetRadios) {
            string = radio.getLabel();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        arrayList2.add((String)arrayList.get(0));
        for (String string2 : arrayList) {
            int n = 0;
            while (n < arrayList2.size()) {
                int n2 = string2.compareTo((String)arrayList2.get(n));
                if (n2 < 0) {
                    arrayList2.add(n, string2);
                    n = arrayList.size();
                    continue;
                }
                if (n == arrayList2.size() - 1) {
                    if (arrayList2.get(n) != string2) {
                        arrayList2.add(string2);
                    }
                    n = arrayList.size();
                    continue;
                }
                ++n;
            }
        }
        return arrayList2;
    }

    public void removeRadios(List<Radio> list) {
        RadioHandler.getLogger().info("HANDLER     ", "Removing radios");
        for (Radio radio : list) {
            if (!this.presetRadios.contains(radio)) {
                this.getRadios().remove(radio);
                continue;
            }
            this.presetRadios.remove(radio);
            Radio radio2 = new Radio(radio.getName(), radio.getUrl(), radio.getLabel());
            radio2.setRemoved(true);
            this.getRadios().add(radio2);
        }
        this.radioListDirty = true;
        NavigationHandler.getInstance().refreshView(RadioNavigationView.class);
    }

    public void removeRadio(Radio radio) {
        ArrayList<Radio> arrayList = new ArrayList<Radio>();
        arrayList.add(radio);
        this.removeRadios(arrayList);
    }

    public List<Radio> retrieveRadiosForBrowser() throws IOException {
        try {
            String string = NetworkUtils.readURL(NetworkUtils.getConnection("http://svn2.assembla.com/svn/common-jukebox/common-jukebox/src/main/resources/preset_radios.xml", Proxy.getProxy(ApplicationState.getInstance().getProxy())));
            return (List)XMLUtils.readObjectFromString(string);
        }
        catch (Exception exception) {
            String string = NetworkUtils.readURL(NetworkUtils.getConnection("http://atunes.svn.sourceforge.net/viewvc/*checkout*/atunes/aTunes_HEAD/settings/preset_radios.xml?revision=HEAD", Proxy.getProxy(ApplicationState.getInstance().getProxy())));
            return (List)XMLUtils.readObjectFromString(string);
        }
    }

    public void retrieveRadios() {
        new RetrieveRadiosSwingWorker().execute();
    }

    public void setLabel(List<Radio> list, String string) {
        for (Radio radio : list) {
            if (this.presetRadios.contains(radio)) {
                this.addRadio(radio);
            }
            radio.setLabel(string);
        }
        this.radioListDirty = true;
    }

    public void setName(Radio radio, String string) {
        if (this.presetRadios.contains(radio)) {
            this.addRadio(radio);
        }
        radio.setName(string);
        this.radioListDirty = true;
    }

    public Radio getRadioIfLoaded(String string) {
        for (Radio radio : this.getRadios()) {
            if (!radio.getUrl().equalsIgnoreCase(string)) continue;
            return radio;
        }
        for (Radio radio : this.presetRadios) {
            if (!radio.getUrl().equalsIgnoreCase(string)) continue;
            return radio;
        }
        return null;
    }

    private final class RetrieveRadiosSwingWorker
    extends SwingWorker<List<Radio>, Void> {
        private final ProxyBean proxy = ApplicationState.getInstance().getProxy();

        private RetrieveRadiosSwingWorker() {
        }

        @Override
        protected List<Radio> doInBackground() throws Exception {
            String string = NetworkUtils.readURL(NetworkUtils.getConnection("http://atunes.svn.sourceforge.net/viewvc/*checkout*/atunes/aTunes_HEAD/settings/preset_radios.xml?revision=HEAD", Proxy.getProxy(this.proxy)));
            return (List)XMLUtils.readObjectFromString(string);
        }

        @Override
        protected void done() {
            try {
                RadioHandler.this.retrievedPresetRadios.clear();
                RadioHandler.this.retrievedPresetRadios.addAll((Collection)this.get());
                RadioHandler.this.getRadioPresets();
                NavigationHandler.getInstance().refreshView(RadioNavigationView.class);
            }
            catch (InterruptedException interruptedException) {
                RadioHandler.getLogger().error("HANDLER     ", interruptedException);
            }
            catch (ExecutionException executionException) {
                RadioHandler.getLogger().error("HANDLER     ", executionException);
            }
        }
    }
}

