/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.data;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import net.sourceforge.atunes.gui.views.dialogs.ExtendedToolTip;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.TreeObject;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class Folder
implements Serializable,
TreeObject {
    private static final long serialVersionUID = 2608221109707838025L;
    private String name;
    private List<AudioFile> audioFiles;
    private Map<String, Folder> folders;
    private Folder parentFolder;

    public Folder(String string) {
        this.name = string;
        this.audioFiles = new ArrayList<AudioFile>();
        this.folders = new HashMap<String, Folder>();
    }

    public void addAudioFile(AudioFile audioFile) {
        this.audioFiles.add(audioFile);
    }

    public void addFolder(Folder folder) {
        if (this.folders.containsKey(folder.getName())) {
            Folder folder2 = this.folders.get(folder.getName());
            folder2.addFoldersOf(folder);
        } else {
            this.folders.put(folder.getName(), folder);
            folder.setParentFolder(this);
        }
    }

    private void addFoldersOf(Folder folder) {
        this.folders.putAll(folder.getFolders());
    }

    public boolean containsFolder(String string) {
        return this.folders.containsKey(string);
    }

    public List<AudioFile> getAudioFiles() {
        ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>();
        arrayList.addAll(this.audioFiles);
        for (String string : this.folders.keySet()) {
            Folder folder = this.folders.get(string);
            arrayList.addAll(folder.getAudioFiles());
        }
        return arrayList;
    }

    @Override
    public List<AudioObject> getAudioObjects() {
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        arrayList.addAll(this.audioFiles);
        for (String string : this.folders.keySet()) {
            Folder folder = this.folders.get(string);
            arrayList.addAll(folder.getAudioObjects());
        }
        return arrayList;
    }

    public List<AudioFile> getFiles() {
        return this.audioFiles;
    }

    public Folder getFolder(String string) {
        return this.folders.get(string);
    }

    public Map<String, Folder> getFolders() {
        return this.folders;
    }

    public String getName() {
        return this.name;
    }

    public Folder getParentFolder() {
        return this.parentFolder;
    }

    public boolean isEmpty() {
        return this.audioFiles.isEmpty() && this.folders.isEmpty();
    }

    public void removeAudioFile(AudioFile audioFile) {
        this.audioFiles.remove(audioFile);
    }

    public void removeFolder(Folder folder) {
        this.folders.remove(folder.getName());
    }

    public void setName(String string) {
        this.name = string;
    }

    private void setParentFolder(Folder folder) {
        this.parentFolder = folder;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Folder)) {
            return false;
        }
        Folder folder = (Folder)object;
        if (folder.parentFolder != null && this.parentFolder != null) {
            return folder.name.equals(this.name) && folder.parentFolder.equals(this.parentFolder);
        }
        if (folder.parentFolder == null && this.parentFolder == null) {
            return folder.name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        if (this.parentFolder == null) {
            return this.name.hashCode();
        }
        return (this.name + this.parentFolder).hashCode();
    }

    public File getFolderPath() {
        String string = this.name;
        Folder folder = this.parentFolder;
        while (folder != null) {
            string = StringUtils.getString(folder.getName(), SystemProperties.FILE_SEPARATOR, string);
            folder = folder.parentFolder;
        }
        return new File(string);
    }

    @Override
    public String getToolTip() {
        int n = this.getAudioFiles().size();
        return StringUtils.getString(this.getName(), " (", n, " ", n > 1 ? I18nUtils.getString("SONGS") : I18nUtils.getString("SONG"), ")");
    }

    @Override
    public boolean isExtendedToolTipSupported() {
        return true;
    }

    @Override
    public void setExtendedToolTip(ExtendedToolTip extendedToolTip) {
        extendedToolTip.setLine1(this.name);
        int n = this.folders.size();
        if (n > 0) {
            extendedToolTip.setLine2(StringUtils.getString(n, " ", n > 1 ? I18nUtils.getString("FOLDERS") : I18nUtils.getString("FOLDER")));
        } else {
            extendedToolTip.setLine2(null);
        }
        int n2 = this.getAudioObjects().size();
        extendedToolTip.setLine3(StringUtils.getString(n2, " ", n2 > 1 ? I18nUtils.getString("SONGS") : I18nUtils.getString("SONG")));
    }

    @Override
    public ImageIcon getExtendedToolTipImage() {
        return null;
    }

    @Override
    public boolean isExtendedToolTipImageSupported() {
        return false;
    }
}

