/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.favorites;

import java.util.List;
import java.util.Map;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.AddLovedSongInLastFMAction;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.repository.AudioFilesRemovedListener;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.favorites.Favorites;
import net.sourceforge.atunes.kernel.modules.search.SearchHandler;
import net.sourceforge.atunes.kernel.modules.search.searchableobjects.FavoritesSearchableObject;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.state.ApplicationStateHandler;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.TreeObject;

public final class FavoritesHandler
extends AbstractHandler
implements AudioFilesRemovedListener {
    private static FavoritesHandler instance = new FavoritesHandler();
    private Favorites favorites;

    public static FavoritesHandler getInstance() {
        return instance;
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
    }

    @Override
    protected void initHandler() {
        RepositoryHandler.getInstance().addAudioFilesRemovedListener(this);
    }

    @Override
    public void applicationStarted() {
        SearchHandler.getInstance().registerSearchableObject(FavoritesSearchableObject.getInstance());
    }

    public void addFavoriteAlbums(List<AudioFile> list) {
        Map<String, Artist> map = RepositoryHandler.getInstance().getArtistStructure();
        Map<String, Album> map2 = this.getFavorites().getFavoriteAlbums();
        for (int i = 0; i < list.size(); ++i) {
            AudioFile audioFile = list.get(i);
            Artist artist = map.get(audioFile.getArtist());
            if (artist == null) {
                artist = map.get(audioFile.getAlbumArtist());
            }
            Album album = artist.getAlbum(audioFile.getAlbum());
            map2.put(album.getName(), album);
        }
        this.callActionsAfterFavoritesChange();
    }

    public void addFavoriteArtists(List<AudioFile> list) {
        Map<String, Artist> map = RepositoryHandler.getInstance().getArtistStructure();
        Map<String, Artist> map2 = this.getFavorites().getFavoriteArtists();
        for (int i = 0; i < list.size(); ++i) {
            AudioFile audioFile = list.get(i);
            Artist artist = map.get(audioFile.getArtist());
            map2.put(artist.getName(), artist);
        }
        this.callActionsAfterFavoritesChange();
    }

    public void addFavoriteSongs(List<AudioFile> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Map<String, AudioFile> map = this.getFavorites().getFavoriteAudioFiles();
        for (AudioFile audioFile : list) {
            map.put(audioFile.getUrl(), audioFile);
            if (!ApplicationState.getInstance().isLastFmEnabled() || !ApplicationState.getInstance().isAutoLoveFavoriteSong()) continue;
            Actions.getAction(AddLovedSongInLastFMAction.class).actionPerformed(null);
        }
        this.callActionsAfterFavoritesChange();
    }

    @Override
    public void applicationFinish() {
        if (this.getFavorites().isDirty()) {
            ApplicationStateHandler.getInstance().persistFavoritesCache(this.getFavorites());
        } else {
            FavoritesHandler.getLogger().info("FAVORITES   ", "Favorites are clean");
        }
    }

    public Map<String, Album> getFavoriteAlbumsInfo() {
        return this.getFavorites().getFavoriteAlbums();
    }

    public Map<String, Artist> getFavoriteArtistsInfo() {
        return this.getFavorites().getFavoriteArtists();
    }

    @Override
    protected Runnable getPreviousInitializationTask() {
        return new Runnable(){

            @Override
            public void run() {
                FavoritesHandler.this.favorites = ApplicationStateHandler.getInstance().retrieveFavoritesCache();
            }
        };
    }

    private Favorites getFavorites() {
        return this.favorites;
    }

    public List<AudioFile> getFavoriteSongs() {
        return this.getFavorites().getAllFavoriteSongs();
    }

    public Map<String, AudioFile> getFavoriteSongsMap() {
        return this.getFavorites().getAllFavoriteSongsMap();
    }

    public Map<String, AudioFile> getFavoriteSongsInfo() {
        return this.getFavorites().getFavoriteAudioFiles();
    }

    public void removeFromFavorites(List<TreeObject> list) {
        for (TreeObject treeObject : list) {
            if (treeObject instanceof Artist) {
                this.getFavorites().getFavoriteArtists().remove(treeObject.toString());
                continue;
            }
            this.getFavorites().getFavoriteAlbums().remove(treeObject.toString());
        }
        this.callActionsAfterFavoritesChange();
    }

    public void removeSongsFromFavorites(List<AudioObject> list) {
        for (AudioObject audioObject : list) {
            this.getFavorites().getFavoriteAudioFiles().remove(audioObject.getUrl());
        }
        this.callActionsAfterFavoritesChange();
    }

    private void callActionsAfterFavoritesChange() {
        this.getFavorites().setDirty(true);
        ControllerProxy.getInstance().getPlayListController().refreshPlayList();
        NavigationHandler.getInstance().refreshCurrentView();
        ControllerProxy.getInstance().getFilePropertiesController().refreshFavoriteIcons();
    }

    @Override
    public void audioFilesRemoved(List<AudioFile> list) {
        for (AudioFile audioFile : list) {
            this.getFavorites().getFavoriteAudioFiles().remove(audioFile.getUrl());
            if (!RepositoryHandler.getInstance().getArtistStructure().containsKey(audioFile.getArtist())) {
                this.getFavorites().getFavoriteArtists().remove(audioFile.getArtist());
                continue;
            }
            if (RepositoryHandler.getInstance().getArtistStructure().get(audioFile.getArtist()).getAlbum(audioFile.getAlbum()) != null) continue;
            this.getFavorites().getFavoriteAlbums().remove(audioFile.getAlbum());
        }
        this.callActionsAfterFavoritesChange();
    }
}

