/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.processes;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.atunes.kernel.modules.process.AbstractAudioFileTransferProcess;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.TagAttributesReviewed;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.AbstractTag;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.DefaultTag;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.TagEditionOperations;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.TagModifier;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.utils.FileNameUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.apache.commons.io.FileUtils;

public class ImportFilesProcess
extends AbstractAudioFileTransferProcess {
    private List<File> folders;
    private String path;
    private HashSet<AudioFile> filesToChangeTag;

    public ImportFilesProcess(List<AudioFile> list, List<File> list2, String string, TagAttributesReviewed tagAttributesReviewed) {
        super(list);
        this.folders = list2;
        this.path = string;
        this.filesToChangeTag = new HashSet();
        for (AudioFile audioFile : list) {
            this.replaceTag(audioFile, tagAttributesReviewed);
            this.setTrackNumber(audioFile);
        }
    }

    @Override
    public String getProgressDialogTitle() {
        return StringUtils.getString(I18nUtils.getString("IMPORTING"), "...");
    }

    /*
     * WARNING - void declaration
     */
    public File getDirectory(AudioFile audioFile, File file) {
        void var5_8;
        File file2 = null;
        for (File object2 : this.folders) {
            if (!audioFile.getFile().getAbsolutePath().startsWith(object2.getParentFile().getAbsolutePath())) continue;
            file2 = object2.getParentFile();
            break;
        }
        if (file2 == null) {
            file2 = this.folders.get(0);
        }
        String string = audioFile.getFile().getParentFile().getAbsolutePath();
        String string2 = string.replaceFirst(file2.getAbsolutePath().replace("\\", "\\\\").replace("$", "\\$"), "");
        if (ApplicationState.getInstance().getImportExportFolderPathPattern() != null) {
            String string3 = FileNameUtils.getValidFolderName(FileNameUtils.getNewFolderPath(ApplicationState.getInstance().getImportExportFolderPathPattern(), audioFile));
        }
        return new File(StringUtils.getString(file.getAbsolutePath(), SystemProperties.FILE_SEPARATOR, var5_8));
    }

    @Override
    protected String getDestination() {
        return this.path;
    }

    @Override
    protected File transferAudioFile(File file, AudioFile audioFile, List<Exception> list) {
        this.setTitle(audioFile);
        if (ApplicationState.getInstance().isApplyChangesToSourceFilesBeforeImport()) {
            this.changeTag(audioFile, audioFile);
        }
        File file2 = this.importFile(file, audioFile, list);
        if (!ApplicationState.getInstance().isApplyChangesToSourceFilesBeforeImport()) {
            this.changeTag(audioFile, new AudioFile(file2));
        }
        return file2;
    }

    private File importFile(File file, AudioFile audioFile, List<Exception> list) {
        File file2 = this.getDirectory(audioFile, file);
        String string = ApplicationState.getInstance().getImportExportFileNamePattern() != null ? FileNameUtils.getNewFileName(ApplicationState.getInstance().getImportExportFileNamePattern(), audioFile) : FileNameUtils.getValidFileName(audioFile.getFile().getName().replace("\\", "\\\\").replace("$", "\\$"), false);
        File file3 = new File(StringUtils.getString(file2.getAbsolutePath(), SystemProperties.FILE_SEPARATOR, string));
        try {
            FileUtils.copyFile((File)audioFile.getFile(), (File)file3);
        }
        catch (IOException iOException) {
            list.add(iOException);
        }
        return file3;
    }

    private void changeTag(AudioFile audioFile, AudioFile audioFile2) {
        if (this.filesToChangeTag.contains(audioFile)) {
            TagModifier.setInfo(audioFile2, audioFile.getTag());
        }
    }

    private void replaceTag(AudioFile audioFile, TagAttributesReviewed tagAttributesReviewed) {
        AbstractTag abstractTag;
        if (tagAttributesReviewed != null && (abstractTag = tagAttributesReviewed.getTagForAudioFile(audioFile)) != null) {
            audioFile.setTag(abstractTag);
            this.filesToChangeTag.add(audioFile);
        }
    }

    private void setTrackNumber(AudioFile audioFile) {
        int n;
        if (ApplicationState.getInstance().isSetTrackNumbersWhenImporting() && audioFile.getTrackNumber() < 1 && (n = TagEditionOperations.getTrackNumber(audioFile)) > 0) {
            if (audioFile.getTag() == null) {
                audioFile.setTag(new DefaultTag());
            }
            audioFile.getTag().setTrackNumber(n);
            if (!this.filesToChangeTag.contains(audioFile)) {
                this.filesToChangeTag.add(audioFile);
            }
        }
    }

    private void setTitle(AudioFile audioFile) {
        String string;
        if (ApplicationState.getInstance().isSetTitlesWhenImporting() && (string = LastFmService.getInstance().getTitleForFile(audioFile)) != null) {
            if (audioFile.getTag() == null) {
                audioFile.setTag(new DefaultTag());
            }
            audioFile.getTag().setTitle(string);
            if (!this.filesToChangeTag.contains(audioFile)) {
                this.filesToChangeTag.add(audioFile);
            }
        }
    }
}

