/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.statistics;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.statistics.AudioFileStats;
import net.sourceforge.atunes.kernel.modules.repository.statistics.Statistics;
import net.sourceforge.atunes.kernel.modules.repository.statistics.StatisticsAlbum;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.state.ApplicationStateHandler;
import net.sourceforge.atunes.misc.RankList;
import net.sourceforge.atunes.utils.StringUtils;

public final class StatisticsHandler
extends AbstractHandler {
    private static StatisticsHandler instance;
    private Statistics statistics;

    public static StatisticsHandler getInstance() {
        if (instance == null) {
            instance = new StatisticsHandler();
        }
        return instance;
    }

    @Override
    public void applicationFinish() {
    }

    @Override
    public void applicationStarted() {
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
    }

    @Override
    protected void initHandler() {
    }

    @Override
    protected Runnable getPreviousInitializationTask() {
        return new Runnable(){

            @Override
            public void run() {
                StatisticsHandler.this.statistics = ApplicationStateHandler.getInstance().retrieveStatisticsCache();
            }
        };
    }

    private void fillStats(AudioFile audioFile) {
        String string = audioFile.getUrl();
        if (RepositoryHandler.getInstance().getAudioFilesMap().containsKey(string)) {
            this.statistics.setTotalPlays(this.statistics.getTotalPlays() + 1);
            AudioFileStats audioFileStats = this.statistics.getAudioFilesStats().get(string);
            if (audioFileStats != null) {
                audioFileStats.setLastPlayed(new Date());
                audioFileStats.increaseTimesPlayed();
            } else {
                audioFileStats = new AudioFileStats();
                this.statistics.getAudioFilesStats().put(string, audioFileStats);
                this.statistics.setDifferentAudioFilesPlayed(this.statistics.getDifferentAudioFilesPlayed() + 1);
            }
            this.statistics.getAudioFilesRanking().addItem(audioFile.getUrl());
            String string2 = audioFile.getArtist();
            Artist artist = RepositoryHandler.getInstance().getArtistStructure().get(string2);
            if (artist == null) {
                return;
            }
            this.statistics.getArtistsRanking().addItem(artist.getName());
            String string3 = audioFile.getAlbum();
            Album album = artist.getAlbum(string3);
            if (album == null) {
                return;
            }
            StatisticsAlbum statisticsAlbum = new StatisticsAlbum(string2, string3);
            this.statistics.getAlbumsRanking().addItem(statisticsAlbum);
        }
    }

    public Map<String, Integer> getAlbumMostPlayed() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (this.statistics.getAlbumsRanking().size() > 0) {
            String string = this.statistics.getAlbumsRanking().getNFirstElements(1).get(0).toString();
            Integer n = this.statistics.getAlbumsRanking().getNFirstElementCounts(1).get(0);
            hashMap.put(string, n);
        } else {
            hashMap.put(null, 0);
        }
        return hashMap;
    }

    public Integer getAlbumTimesPlayed(AudioFile audioFile) {
        if (audioFile != null && this.statistics.getAlbumsRanking().getCount(new StatisticsAlbum(audioFile.getArtist(), audioFile.getAlbum())) != null) {
            return this.statistics.getAlbumsRanking().getCount(new StatisticsAlbum(audioFile.getArtist(), audioFile.getAlbum()));
        }
        return 0;
    }

    public Map<String, Integer> getArtistMostPlayed() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (this.statistics.getArtistsRanking().size() > 0) {
            String string = this.statistics.getArtistsRanking().getNFirstElements(1).get(0);
            Integer n = this.statistics.getArtistsRanking().getNFirstElementCounts(1).get(0);
            hashMap.put(string, n);
        } else {
            hashMap.put(null, 0);
        }
        return hashMap;
    }

    public Integer getArtistTimesPlayed(Artist artist) {
        if (this.statistics.getArtistsRanking().getCount(artist.getName()) != null) {
            return this.statistics.getArtistsRanking().getCount(artist.getName());
        }
        return 0;
    }

    public int getDifferentAudioFilesPlayed() {
        return this.statistics.getDifferentAudioFilesPlayed();
    }

    public List<Album> getMostPlayedAlbums(int n) {
        List<StatisticsAlbum> list = this.statistics.getAlbumsRanking().getNFirstElements(n);
        if (list != null) {
            ArrayList<Album> arrayList = new ArrayList<Album>();
            for (StatisticsAlbum statisticsAlbum : list) {
                Album album;
                Artist artist = RepositoryHandler.getInstance().getArtistStructure().get(statisticsAlbum.getArtist());
                if (artist == null || (album = artist.getAlbum(statisticsAlbum.getAlbum())) == null) continue;
                arrayList.add(album);
            }
            return arrayList;
        }
        return null;
    }

    public List<Integer> getMostPlayedAlbumsCount(int n) {
        return this.statistics.getAlbumsRanking().getNFirstElementCounts(n);
    }

    public List<Artist> getMostPlayedArtists(int n) {
        List<String> list = this.statistics.getArtistsRanking().getNFirstElements(n);
        if (list != null) {
            ArrayList<Artist> arrayList = new ArrayList<Artist>();
            for (String string : list) {
                arrayList.add(RepositoryHandler.getInstance().getArtistStructure().get(string));
            }
            return arrayList;
        }
        return null;
    }

    public List<Integer> getMostPlayedArtistsCount(int n) {
        return this.statistics.getArtistsRanking().getNFirstElementCounts(n);
    }

    public List<AudioFile> getMostPlayedAudioFiles(int n) {
        List<String> list = this.statistics.getAudioFilesRanking().getNFirstElements(n);
        if (list != null) {
            ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>();
            for (String string : list) {
                arrayList.add(RepositoryHandler.getInstance().getFileIfLoaded(string));
            }
            return arrayList;
        }
        return null;
    }

    public List<Integer> getMostPlayedAudioFilesCount(int n) {
        return this.statistics.getAudioFilesRanking().getNFirstElementCounts(n);
    }

    public Map<AudioFile, Integer> getAudioFileMostPlayed() {
        HashMap<AudioFile, Integer> hashMap = new HashMap<AudioFile, Integer>();
        if (this.statistics.getAudioFilesRanking().size() > 0) {
            AudioFile audioFile = this.getMostPlayedAudioFiles(1).get(0);
            Integer n = this.statistics.getAudioFilesRanking().getNFirstElementCounts(1).get(0);
            hashMap.put(audioFile, n);
        } else {
            hashMap.put(null, 0);
        }
        return hashMap;
    }

    public String getAudioFilesPlayed() {
        int n = this.statistics.getDifferentAudioFilesPlayed();
        int n2 = RepositoryHandler.getInstance().getNumberOfFiles();
        float f = n2 == 0 ? 0.0f : (float)n / (float)n2 * 100.0f;
        return StringUtils.getString(n, " / ", n2, " (", StringUtils.toString(f, 2), "%)");
    }

    public AudioFileStats getAudioFileStatistics(AudioFile audioFile) {
        return this.statistics.getStatsForAudioFile(audioFile);
    }

    public int getTotalAudioFilesPlayed() {
        return this.statistics.getTotalPlays();
    }

    public List<AudioFile> getUnplayedAudioFiles() {
        List<AudioFile> list = RepositoryHandler.getInstance().getAudioFilesList();
        list.removeAll(this.statistics.getAudioFilesRanking().getNFirstElements(-1));
        return list;
    }

    public void setAudioFileStatistics(AudioFile audioFile) {
        this.fillStats(audioFile);
        this.storeStatistics();
    }

    private void storeStatistics() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                ApplicationStateHandler.getInstance().persistStatisticsCache(StatisticsHandler.this.statistics);
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    public void updateArtist(String string, String string2) {
        this.statistics.getArtistsRanking().replaceItem(string, string2);
        RankList<StatisticsAlbum> rankList = this.statistics.getAlbumsRanking();
        for (StatisticsAlbum statisticsAlbum : rankList.getOrder()) {
            if (!statisticsAlbum.getArtist().equals(string)) continue;
            this.statistics.getAlbumsRanking().replaceItem(statisticsAlbum, new StatisticsAlbum(string2, statisticsAlbum.getAlbum()));
        }
        this.storeStatistics();
    }

    public void updateAlbum(String string, String string2, String string3) {
        RankList<StatisticsAlbum> rankList = this.statistics.getAlbumsRanking();
        for (StatisticsAlbum statisticsAlbum : rankList.getOrder()) {
            if (!statisticsAlbum.getArtist().equals(string) || !statisticsAlbum.getAlbum().equals(string2)) continue;
            this.statistics.getAlbumsRanking().replaceItem(statisticsAlbum, new StatisticsAlbum(string, string3));
        }
        this.storeStatistics();
    }

    public void updateFileName(String string, String string2) {
        this.statistics.getAudioFilesRanking().replaceItem(string, string2);
        this.statistics.getAudioFilesStats().put(string2, this.statistics.getAudioFilesStats().get(string));
        this.statistics.getAudioFilesStats().remove(string);
        this.storeStatistics();
    }
}

