/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.tags;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.data.Genre;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.TagAttribute;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.TreeObject;

public final class IncompleteTagsChecker {
    private IncompleteTagsChecker() {
    }

    public static List<TagAttribute> getDefaultTagAttributesToHighlightFolders() {
        ArrayList<TagAttribute> arrayList = new ArrayList<TagAttribute>();
        arrayList.add(TagAttribute.ARTIST);
        arrayList.add(TagAttribute.ALBUM);
        return arrayList;
    }

    public static Map<TagAttribute, Boolean> getAllTagAttributes() {
        HashMap<TagAttribute, Boolean> hashMap = new HashMap<TagAttribute, Boolean>();
        hashMap.put(TagAttribute.TITLE, false);
        hashMap.put(TagAttribute.ARTIST, false);
        hashMap.put(TagAttribute.ALBUM, false);
        hashMap.put(TagAttribute.YEAR, false);
        hashMap.put(TagAttribute.COMMENT, false);
        hashMap.put(TagAttribute.GENRE, false);
        hashMap.put(TagAttribute.LYRICS, false);
        hashMap.put(TagAttribute.COMPOSER, false);
        hashMap.put(TagAttribute.ALBUM_ARTIST, false);
        hashMap.put(TagAttribute.TRACK, false);
        for (TagAttribute tagAttribute : ApplicationState.getInstance().getHighlightIncompleteTagFoldersAttributes()) {
            hashMap.put(tagAttribute, true);
        }
        return hashMap;
    }

    private static boolean hasTagAttributesFilled(AudioFile audioFile) {
        if (audioFile.getTag() == null) {
            return false;
        }
        for (TagAttribute tagAttribute : ApplicationState.getInstance().getHighlightIncompleteTagFoldersAttributes()) {
            if (tagAttribute == TagAttribute.TITLE && audioFile.getTitle().isEmpty()) {
                return false;
            }
            if (tagAttribute == TagAttribute.ARTIST && Artist.isUnknownArtist(audioFile.getArtist())) {
                return false;
            }
            if (tagAttribute == TagAttribute.ALBUM && Album.isUnknownAlbum(audioFile.getAlbum())) {
                return false;
            }
            if (tagAttribute == TagAttribute.YEAR && audioFile.getYear().isEmpty()) {
                return false;
            }
            if (tagAttribute == TagAttribute.COMMENT && audioFile.getComment().isEmpty()) {
                return false;
            }
            if (tagAttribute == TagAttribute.GENRE && Genre.isUnknownGenre(audioFile.getGenre())) {
                return false;
            }
            if (tagAttribute == TagAttribute.LYRICS && audioFile.getLyrics().isEmpty()) {
                return false;
            }
            if (tagAttribute == TagAttribute.COMPOSER && audioFile.getComposer().isEmpty()) {
                return false;
            }
            if (tagAttribute == TagAttribute.ALBUM_ARTIST && audioFile.getAlbumArtist().isEmpty()) {
                return false;
            }
            if (tagAttribute != TagAttribute.TRACK || audioFile.getTrackNumber() > 0) continue;
            return false;
        }
        return true;
    }

    public static boolean hasIncompleteTags(TreeObject treeObject) {
        for (AudioObject audioObject : treeObject.getAudioObjects()) {
            if (!IncompleteTagsChecker.hasIncompleteTags(audioObject)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasIncompleteTags(AudioObject audioObject) {
        if (audioObject instanceof AudioFile) {
            return !IncompleteTagsChecker.hasTagAttributesFilled((AudioFile)audioObject);
        }
        return false;
    }
}

