/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.tags;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.AbstractTagAttributeReviewed;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.AbstractTag;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.DefaultTag;
import org.jdesktop.swingx.combobox.ListComboBoxModel;

public class TagAttributesReviewed {
    private List<AbstractTagAttributeReviewed> tagAttributes;

    private List<AbstractTagAttributeReviewed> getTagAttributes() {
        if (this.tagAttributes == null) {
            this.tagAttributes = new ArrayList<AbstractTagAttributeReviewed>();
            this.tagAttributes.add(new ArtistTagAttributeReviewed("ARTIST"));
            this.tagAttributes.add(new AlbumArtistTagAttributeReviewed("ALBUM_ARTIST"));
            this.tagAttributes.add(new ComposerTagAttributeReviewed("COMPOSER"));
            this.tagAttributes.add(new AlbumTagAttributeReviewed("ALBUM"));
            this.tagAttributes.add(new GenreTagAttributeReviewed("GENRE"));
            this.tagAttributes.add(new YearTagAttributeReviewed("YEAR"));
            this.tagAttributes.add(new DiscNumberTagAttributeReviewed("DISC_NUMBER"));
        }
        return this.tagAttributes;
    }

    public int getTagAttributesCount() {
        return this.getTagAttributes().size();
    }

    public String getTagAttributeName(int n) {
        if (this.getTagAttributes().size() <= n) {
            return null;
        }
        return this.getTagAttributes().get(n).getName();
    }

    public String getValueForTagAttribute(int n, AudioFile audioFile) {
        if (this.getTagAttributes().size() <= n) {
            return null;
        }
        return this.getTagAttributes().get(n).getValue(audioFile);
    }

    public String getChangeForAttributeAndFolder(int n, File file) {
        if (this.getTagAttributes().size() <= n) {
            return null;
        }
        if (this.getTagAttributes().get(n).getChangesMade().containsKey(file)) {
            return this.getTagAttributes().get(n).getChangesMade().get(file);
        }
        return null;
    }

    public void setTagAttributeForFolder(int n, File file, String string) {
        if (this.getTagAttributes().size() <= n) {
            return;
        }
        this.getTagAttributes().get(n).getChangesMade().put(file, string);
    }

    public AbstractTag getTagForAudioFile(AudioFile audioFile) {
        File file = audioFile.getFile().getParentFile();
        AbstractTag abstractTag = null;
        for (AbstractTagAttributeReviewed abstractTagAttributeReviewed : this.getTagAttributes()) {
            if (!abstractTagAttributeReviewed.getChangesMade().containsKey(file)) continue;
            if (abstractTag == null) {
                abstractTag = audioFile.getTag() != null ? audioFile.getTag() : new DefaultTag();
            }
            abstractTag = abstractTagAttributeReviewed.changeTag(abstractTag, abstractTagAttributeReviewed.getChangesMade().get(file));
        }
        return abstractTag;
    }

    public TableCellEditor getCellEditorForTagAttribute(int n) {
        if (this.getTagAttributes().size() <= n) {
            return null;
        }
        return this.getTagAttributes().get(n).getCellEditor();
    }

    public int getTagAttributeIndex(String string) {
        for (int i = 0; i < this.tagAttributes.size(); ++i) {
            if (!this.tagAttributes.get(i).getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    private static final class ArtistTagAttributeReviewed
    extends AbstractTagAttributeReviewed {
        private ArtistTagAttributeReviewed(String string) {
            super(string);
        }

        @Override
        String getValue(AudioFile audioFile) {
            return audioFile.getTag() != null ? audioFile.getTag().getArtist() : null;
        }

        @Override
        AbstractTag changeTag(AbstractTag abstractTag, String string) {
            abstractTag.setArtist(string);
            return abstractTag;
        }

        @Override
        TableCellEditor getCellEditor() {
            List<Artist> list = RepositoryHandler.getInstance().getArtists();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Artist artist : list) {
                arrayList.add(artist.getName());
            }
            JComboBox jComboBox = new JComboBox(new ListComboBoxModel(arrayList));
            jComboBox.setEditable(true);
            return new DefaultCellEditor(jComboBox);
        }
    }

    private static final class AlbumArtistTagAttributeReviewed
    extends AbstractTagAttributeReviewed {
        private AlbumArtistTagAttributeReviewed(String string) {
            super(string);
        }

        @Override
        String getValue(AudioFile audioFile) {
            return audioFile.getAlbumArtist();
        }

        @Override
        AbstractTag changeTag(AbstractTag abstractTag, String string) {
            abstractTag.setAlbumArtist(string);
            return abstractTag;
        }
    }

    private static final class ComposerTagAttributeReviewed
    extends AbstractTagAttributeReviewed {
        private ComposerTagAttributeReviewed(String string) {
            super(string);
        }

        @Override
        String getValue(AudioFile audioFile) {
            return audioFile.getComposer();
        }

        @Override
        AbstractTag changeTag(AbstractTag abstractTag, String string) {
            abstractTag.setComposer(string);
            return abstractTag;
        }
    }

    private static final class AlbumTagAttributeReviewed
    extends AbstractTagAttributeReviewed {
        private AlbumTagAttributeReviewed(String string) {
            super(string);
        }

        @Override
        String getValue(AudioFile audioFile) {
            return audioFile.getTag() != null ? audioFile.getTag().getAlbum() : null;
        }

        @Override
        AbstractTag changeTag(AbstractTag abstractTag, String string) {
            abstractTag.setAlbum(string);
            return abstractTag;
        }
    }

    private static final class GenreTagAttributeReviewed
    extends AbstractTagAttributeReviewed {
        private GenreTagAttributeReviewed(String string) {
            super(string);
        }

        @Override
        String getValue(AudioFile audioFile) {
            return audioFile.getTag() != null ? audioFile.getTag().getGenre() : null;
        }

        @Override
        AbstractTag changeTag(AbstractTag abstractTag, String string) {
            abstractTag.setGenre(string);
            return abstractTag;
        }

        @Override
        TableCellEditor getCellEditor() {
            List<String> list = Arrays.asList(AbstractTag.genres);
            Collections.sort(list);
            JComboBox jComboBox = new JComboBox(new ListComboBoxModel(list));
            jComboBox.setEditable(true);
            return new DefaultCellEditor(jComboBox);
        }
    }

    private static final class YearTagAttributeReviewed
    extends AbstractTagAttributeReviewed {
        private YearTagAttributeReviewed(String string) {
            super(string);
        }

        @Override
        String getValue(AudioFile audioFile) {
            return audioFile.getYear();
        }

        @Override
        AbstractTag changeTag(AbstractTag abstractTag, String string) {
            try {
                abstractTag.setYear(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                abstractTag.setYear(0);
            }
            return abstractTag;
        }
    }

    private static final class DiscNumberTagAttributeReviewed
    extends AbstractTagAttributeReviewed {
        private DiscNumberTagAttributeReviewed(String string) {
            super(string);
        }

        @Override
        String getValue(AudioFile audioFile) {
            return audioFile.getDiscNumber() > 0 ? String.valueOf(audioFile.getDiscNumber()) : "";
        }

        @Override
        AbstractTag changeTag(AbstractTag abstractTag, String string) {
            try {
                abstractTag.setDiscNumber(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                abstractTag.setDiscNumber(0);
            }
            return abstractTag;
        }
    }
}

