/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.tags.writer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.SetAlbumNamesProcess;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.SetCoversProcess;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.SetGenresProcess;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.SetLyricsProcess;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.SetTrackNumberProcess;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.utils.I18nUtils;

public final class TagEditionOperations {
    private static final Pattern NUMBER_SEPARATOR_PATTERN = Pattern.compile("[^0-9]+");

    private TagEditionOperations() {
    }

    public static void addLyrics(List<AudioFile> list) {
        SetLyricsProcess setLyricsProcess = new SetLyricsProcess(list);
        setLyricsProcess.execute();
    }

    private static void editAlbumName(List<AudioFile> list) {
        SetAlbumNamesProcess setAlbumNamesProcess = new SetAlbumNamesProcess(list);
        setAlbumNamesProcess.execute();
    }

    public static void editGenre(List<AudioFile> list) {
        SetGenresProcess setGenresProcess = new SetGenresProcess(list);
        setGenresProcess.execute();
    }

    public static void editCover(List<AudioFile> list) {
        SetCoversProcess setCoversProcess = new SetCoversProcess(list);
        setCoversProcess.execute();
    }

    public static void editTrackNumber(List<AudioFile> list) {
        HashMap<AudioFile, Integer> hashMap = new HashMap<AudioFile, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            int n = TagEditionOperations.getTrackNumber(list.get(i));
            if (n == 0) continue;
            hashMap.put(list.get(i), n);
        }
        if (!hashMap.isEmpty()) {
            SetTrackNumberProcess setTrackNumberProcess = new SetTrackNumberProcess(hashMap);
            setTrackNumberProcess.execute();
        }
    }

    public static int getTrackNumber(AudioFile audioFile) {
        String string = audioFile.getNameWithoutExtension();
        String[] stringArray = NUMBER_SEPARATOR_PATTERN.split(string);
        int n = 0;
        for (int i = 0; n == 0 && i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            try {
                n = Integer.parseInt(string2);
                if (n < 1000) continue;
                n = 0;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n == 0) {
            n = LastFmService.getInstance().getTrackNumberForFile(audioFile);
        }
        return n;
    }

    public static void repairAlbumNames() {
        if (GuiHandler.getInstance().showConfirmationDialog(I18nUtils.getString("REPAIR_ALBUM_NAMES_MESSAGE"), I18nUtils.getString("REPAIR_ALBUM_NAMES")) == 0) {
            List<AudioFile> list = RepositoryHandler.getInstance().getAudioFilesList();
            ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>();
            for (AudioFile audioFile : list) {
                if (audioFile.getGenre() != null && !audioFile.getGenre().isEmpty()) continue;
                arrayList.add(audioFile);
            }
            TagEditionOperations.editAlbumName(arrayList);
        }
    }

    public static void repairGenres() {
        if (GuiHandler.getInstance().showConfirmationDialog(I18nUtils.getString("REPAIR_GENRES_MESSAGE"), I18nUtils.getString("REPAIR_GENRES")) == 0) {
            List<AudioFile> list = RepositoryHandler.getInstance().getAudioFilesList();
            ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>();
            for (AudioFile audioFile : list) {
                if (audioFile.getGenre() != null && !audioFile.getGenre().isEmpty()) continue;
                arrayList.add(audioFile);
            }
            TagEditionOperations.editGenre(arrayList);
        }
    }

    public static void repairTrackNumbers() {
        if (GuiHandler.getInstance().showConfirmationDialog(I18nUtils.getString("REPAIR_TRACK_NUMBERS_MESSAGE"), I18nUtils.getString("REPAIR_TRACK_NUMBERS")) == 0) {
            List<AudioFile> list = RepositoryHandler.getInstance().getAudioFilesList();
            ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>();
            for (AudioFile audioFile : list) {
                if (audioFile.getTrackNumber() != 0) continue;
                arrayList.add(audioFile);
            }
            TagEditionOperations.editTrackNumber(arrayList);
        }
    }
}

