/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.search.searchableobjects;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.atunes.kernel.Kernel;
import net.sourceforge.atunes.kernel.modules.device.DeviceHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.search.RawSearchResult;
import net.sourceforge.atunes.kernel.modules.search.searchableobjects.AbstractCommonAudioFileSearchableObject;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;

public final class DeviceSearchableObject
extends AbstractCommonAudioFileSearchableObject {
    private static DeviceSearchableObject instance;
    private FSDirectory indexDirectory;

    private DeviceSearchableObject() {
    }

    public static DeviceSearchableObject getInstance() {
        if (instance == null) {
            instance = new DeviceSearchableObject();
        }
        return instance;
    }

    @Override
    public String getSearchableObjectName() {
        return I18nUtils.getString("DEVICE");
    }

    @Override
    public synchronized FSDirectory getIndexDirectory() throws IOException {
        if (this.indexDirectory == null) {
            this.indexDirectory = new SimpleFSDirectory(new File(StringUtils.getString(SystemProperties.getUserConfigFolder(Kernel.isDebug()), "/", "index/device")));
        }
        return this.indexDirectory;
    }

    @Override
    public List<AudioObject> getSearchResult(List<RawSearchResult> list) {
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        for (RawSearchResult rawSearchResult : list) {
            AudioFile audioFile = DeviceHandler.getInstance().getFileIfLoaded(rawSearchResult.getDocument().get("url"));
            if (audioFile == null) continue;
            arrayList.add(audioFile);
        }
        return arrayList;
    }

    @Override
    public List<AudioObject> getElementsToIndex() {
        return new ArrayList<AudioObject>(DeviceHandler.getInstance().getAudioFilesList());
    }
}

