/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.webservices.lyrics;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.atunes.kernel.modules.proxy.Proxy;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.state.ApplicationStateChangeListener;
import net.sourceforge.atunes.kernel.modules.state.beans.ProxyBean;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.Lyrics;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.LyricsCache;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.engines.AbstractLyricsEngine;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.engines.LyricsEngineInfo;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.StringUtils;

public final class LyricsService
implements ApplicationStateChangeListener {
    private static final List<LyricsEngineInfo> DEFAULT_LYRICS_ENGINES;
    private static LyricsCache lyricsCache;
    private Logger logger;
    private List<AbstractLyricsEngine> lyricsEngines = this.loadEngines(ApplicationState.getInstance().getProxy());
    private static LyricsService instance;

    public static LyricsService getInstance() {
        if (instance == null) {
            instance = new LyricsService();
        }
        return instance;
    }

    private LyricsService() {
    }

    public void updateService() {
        instance = null;
    }

    public Lyrics getLyrics(String string, String string2) {
        this.getLogger().debugMethodCall("SERVICE     ", string, string2);
        Lyrics lyrics = lyricsCache.retrieveLyric(string, string2);
        if (lyrics != null && lyrics.getLyrics().contains("<") && lyrics.getLyrics().contains(">")) {
            this.getLogger().debug("SERVICE     ", "Discarding lyrics. Seems to contain some HTML code: ");
            this.getLogger().debug("SERVICE     ", lyrics.getLyrics());
            lyrics = null;
        }
        if (lyrics == null) {
            if (this.lyricsEngines != null) {
                for (int i = 0; i < this.lyricsEngines.size() && (lyrics == null || lyrics.getLyrics().trim().isEmpty()); ++i) {
                    lyrics = this.lyricsEngines.get(i).getLyricsFor(string, string2);
                    if (lyrics == null) {
                        this.getLogger().info("SERVICE     ", StringUtils.getString("Lyrics for: ", string, "/", string2, " not found with engine: ", this.lyricsEngines.get(i).getLyricsProviderName()));
                        continue;
                    }
                    this.getLogger().debug("SERVICE     ", "Engine: ", this.lyricsEngines.get(i).getLyricsProviderName(), " returned lyrics for: ", string, "/", string2, ": ", lyrics.getLyrics());
                }
            }
            this.fixLyrics(lyrics);
            lyricsCache.storeLyric(string, string2, lyrics);
        }
        return lyrics;
    }

    private void fixLyrics(Lyrics lyrics) {
        if (lyrics != null) {
            String string = lyrics.getLyrics().replaceAll("'", "'").replaceAll("\n\n", "\n").replaceAll("<.*>", "").trim();
            lyrics.setLyrics(string);
        }
    }

    public Map<String, String> getUrlsForAddingNewLyrics(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (AbstractLyricsEngine abstractLyricsEngine : this.lyricsEngines) {
            String string3 = abstractLyricsEngine.getUrlForAddingNewLyrics(string, string2);
            if (string3 == null || string3.trim().equals("")) continue;
            hashMap.put(abstractLyricsEngine.getLyricsProviderName(), string3);
        }
        return hashMap;
    }

    private void setLyricsEngines(List<AbstractLyricsEngine> list) {
        this.lyricsEngines = list;
    }

    private List<AbstractLyricsEngine> loadEngines(ProxyBean proxyBean) {
        List<LyricsEngineInfo> list = ApplicationState.getInstance().getLyricsEnginesInfo();
        Proxy proxy = null;
        try {
            if (proxyBean != null) {
                proxy = Proxy.getProxy(proxyBean);
            }
        }
        catch (Exception exception) {
            this.getLogger().error("HANDLER     ", exception);
        }
        boolean bl = false;
        if (list != null) {
            for (LyricsEngineInfo object2 : list) {
                if (object2 != null) continue;
                bl = true;
                break;
            }
        } else {
            bl = true;
        }
        if (bl) {
            list = new ArrayList<LyricsEngineInfo>(DEFAULT_LYRICS_ENGINES);
        } else {
            list = new ArrayList<LyricsEngineInfo>(list);
            for (LyricsEngineInfo lyricsEngineInfo : DEFAULT_LYRICS_ENGINES) {
                if (list.contains(lyricsEngineInfo)) continue;
                list.add(lyricsEngineInfo);
            }
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<LyricsEngineInfo> arrayList2 = new ArrayList<LyricsEngineInfo>();
        for (LyricsEngineInfo lyricsEngineInfo : list) {
            if (!lyricsEngineInfo.isEnabled()) continue;
            try {
                Class<?> illegalAccessException = Class.forName(lyricsEngineInfo.getClazz());
                Constructor<?> constructor = illegalAccessException.getConstructor(Proxy.class);
                arrayList.add((AbstractLyricsEngine)constructor.newInstance(proxy));
            }
            catch (ClassNotFoundException securityException) {
                arrayList2.add(lyricsEngineInfo);
                this.logLyricEngineLoadError(lyricsEngineInfo.getClazz(), securityException);
            }
            catch (InstantiationException noSuchMethodException) {
                arrayList2.add(lyricsEngineInfo);
                this.logLyricEngineLoadError(lyricsEngineInfo.getClazz(), noSuchMethodException);
            }
            catch (IllegalAccessException illegalArgumentException) {
                arrayList2.add(lyricsEngineInfo);
                this.logLyricEngineLoadError(lyricsEngineInfo.getClazz(), illegalArgumentException);
            }
            catch (SecurityException invocationTargetException) {
                arrayList2.add(lyricsEngineInfo);
                this.logLyricEngineLoadError(lyricsEngineInfo.getClazz(), invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                arrayList2.add(lyricsEngineInfo);
                this.logLyricEngineLoadError(lyricsEngineInfo.getClazz(), noSuchMethodException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                arrayList2.add(lyricsEngineInfo);
                this.logLyricEngineLoadError(lyricsEngineInfo.getClazz(), illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                arrayList2.add(lyricsEngineInfo);
                this.logLyricEngineLoadError(lyricsEngineInfo.getClazz(), invocationTargetException);
            }
        }
        for (LyricsEngineInfo lyricsEngineInfo : arrayList2) {
            list.remove(lyricsEngineInfo);
        }
        ApplicationState.getInstance().setLyricsEnginesInfo(list);
        return arrayList;
    }

    private void logLyricEngineLoadError(String string, Exception exception) {
        this.getLogger().error("HANDLER     ", StringUtils.getString("Error loading lyrics engine: ", string));
        this.getLogger().error("HANDLER     ", StringUtils.getString("Error was: ", exception.getClass().getCanonicalName(), " (", exception.getMessage(), ")"));
    }

    private void setLyricsEngines(ProxyBean proxyBean, List<LyricsEngineInfo> list) {
        ArrayList<AbstractLyricsEngine> arrayList = new ArrayList<AbstractLyricsEngine>();
        for (LyricsEngineInfo lyricsEngineInfo : list) {
            if (!lyricsEngineInfo.isEnabled()) continue;
            try {
                Class<?> clazz = Class.forName(lyricsEngineInfo.getClazz());
                Constructor<?> constructor = clazz.getConstructor(Proxy.class);
                arrayList.add((AbstractLyricsEngine)constructor.newInstance(proxyBean));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.getLogger().error("HANDLER     ", classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                this.getLogger().error("HANDLER     ", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.getLogger().error("HANDLER     ", illegalAccessException);
            }
            catch (SecurityException securityException) {
                this.getLogger().error("HANDLER     ", securityException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.getLogger().error("HANDLER     ", noSuchMethodException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.getLogger().error("HANDLER     ", illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.getLogger().error("HANDLER     ", invocationTargetException);
            }
        }
        this.setLyricsEngines(arrayList);
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    public boolean clearCache() {
        return lyricsCache.clearCache();
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
        this.setLyricsEngines(applicationState.getProxy(), applicationState.getLyricsEnginesInfo());
    }

    public void finishService() {
        lyricsCache.shutdown();
    }

    static {
        ArrayList<LyricsEngineInfo> arrayList = new ArrayList<LyricsEngineInfo>();
        arrayList.add(new LyricsEngineInfo("LyricWiki", "net.sourceforge.atunes.kernel.modules.webservices.lyrics.engines.LyricWikiEngine", true));
        arrayList.add(new LyricsEngineInfo("LyricsDirectory", "net.sourceforge.atunes.kernel.modules.webservices.lyrics.engines.LyricsDirectoryEngine", false));
        arrayList.add(new LyricsEngineInfo("LyrcEngine", "net.sourceforge.atunes.kernel.modules.webservices.lyrics.engines.LyrcEngine", false));
        arrayList.add(new LyricsEngineInfo("Winampcn", "net.sourceforge.atunes.kernel.modules.webservices.lyrics.engines.WinampcnEngine", false));
        DEFAULT_LYRICS_ENGINES = Collections.unmodifiableList(arrayList);
        lyricsCache = new LyricsCache();
    }
}

