/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.misc;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import org.commonjukebox.plugins.model.PluginApi;

@PluginApi
public final class ClipboardFacade
implements ClipboardOwner {
    private static ClipboardFacade instance = new ClipboardFacade();

    private ClipboardFacade() {
    }

    public static void copyToClipboard(String string) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, instance);
    }

    public static String getClipboardContent() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        String string = "";
        try {
            boolean bl;
            Transferable transferable = clipboard.getContents(null);
            boolean bl2 = bl = transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
            if (bl) {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static boolean clipboardContainsText() {
        return !ClipboardFacade.getClipboardContent().equals("");
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

