/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sourceforge.atunes.utils.StringUtils;

public final class I18nUtils {
    private static final String BUNDLE_BASE_NAME = StringUtils.getString("translations", ".MainBundle");
    private static final ClassLoader WD_CLASS_LOADER = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return new ClassLoader(){

                @Override
                public URL getResource(String string) {
                    try {
                        URL uRL = super.getResource(string);
                        if (uRL != null) {
                            return uRL;
                        }
                        return new File(string).toURI().toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        return null;
                    }
                }
            };
        }
    });
    private static ResourceBundle languageBundle;
    private static Locale selectedLocale;

    private I18nUtils() {
    }

    public static List<Locale> getLanguages() {
        return Arrays.asList(new Locale("ar"), new Locale("ca"), new Locale("cs"), new Locale("da"), new Locale("de"), new Locale("el"), new Locale("en"), new Locale("es"), new Locale("fr"), new Locale("gl"), new Locale("he"), new Locale("hr"), new Locale("hu"), new Locale("it"), new Locale("ja"), new Locale("nl"), new Locale("no"), new Locale("pl"), new Locale("pt", "BR"), new Locale("pt"), new Locale("ru"), new Locale("sk"), new Locale("sv"), new Locale("tr"), new Locale("uk"), new Locale("zh", "TW"), new Locale("zh"));
    }

    public static String getString(String string) {
        if (languageBundle != null) {
            String string2;
            try {
                string2 = languageBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                return string;
            }
            return string2;
        }
        return string;
    }

    public static void setLocale(Locale locale) {
        languageBundle = locale == null ? ResourceBundle.getBundle(BUNDLE_BASE_NAME, Locale.getDefault(), WD_CLASS_LOADER) : ResourceBundle.getBundle(BUNDLE_BASE_NAME, locale, WD_CLASS_LOADER);
        selectedLocale = languageBundle.getLocale();
    }

    public static Locale getSelectedLocale() {
        return selectedLocale;
    }
}

