/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import net.roarsoftware.lastfm.Caller;
import net.roarsoftware.lastfm.MusicEntry;
import net.roarsoftware.lastfm.Result;
import net.roarsoftware.lastfm.Session;
import net.roarsoftware.util.StringUtilities;
import net.roarsoftware.xml.DomElement;

public class Album
extends MusicEntry {
    private static final DateFormat RELEASE_DATE_FORMAT = new SimpleDateFormat("d MMM yyyy, HH:mm", Locale.ENGLISH);
    private String artist;
    private Date releaseDate;
    private String id;

    protected Album(String name, String url, String artist) {
        super(name, url);
        this.artist = artist;
    }

    protected Album(String name, String url, String mbid, int playcount, int listeners, boolean streamable, String artist) {
        super(name, url, mbid, playcount, listeners, streamable);
        this.artist = artist;
    }

    public String getArtist() {
        return this.artist;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public String getId() {
        return this.id;
    }

    public static Album getInfo(String artist, String albumOrMbid, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(albumOrMbid)) {
            params.put("mbid", albumOrMbid);
        } else {
            params.put("artist", artist);
            params.put("album", albumOrMbid);
        }
        Result result = Caller.getInstance().call("album.getInfo", apiKey, params);
        DomElement element = result.getContentElement();
        return Album.albumFromElement(element);
    }

    public static Result addTags(String artist, String album, String tags, Session session) {
        return Caller.getInstance().call("album.addTags", session, "artist", artist, "album", album, "tags", tags);
    }

    public static Result removeTag(String artist, String album, String tag, Session session) {
        return Caller.getInstance().call("album.removeTag", session, "artist", artist, "album", album, "tag", tag);
    }

    public static Collection<String> getTags(String artist, String album, Session session) {
        Result result = Caller.getInstance().call("album.getTags", session, "artist", artist, "album", album);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        ArrayList<String> tags = new ArrayList<String>();
        for (DomElement domElement : element.getChildren("tag")) {
            tags.add(domElement.getChildText("name"));
        }
        return tags;
    }

    public static Collection<Album> search(String album, String apiKey) {
        Result result = Caller.getInstance().call("album.search", apiKey, "album", album);
        DomElement matches = result.getContentElement().getChild("albummatches");
        Collection<DomElement> children = matches.getChildren("album");
        ArrayList<Album> albums = new ArrayList<Album>(children.size());
        for (DomElement element : children) {
            albums.add(Album.albumFromElement(element));
        }
        return albums;
    }

    static Album albumFromElement(DomElement element) {
        return Album.albumFromElement(element, null);
    }

    static Album albumFromElement(DomElement element, String artistName) {
        if (element == null) {
            return null;
        }
        Album album = new Album(null, null, artistName);
        MusicEntry.loadStandardInfo(album, element);
        if (element.hasChild("id")) {
            album.id = element.getChildText("id");
        }
        if (element.hasChild("artist")) {
            album.artist = element.getChild("artist").getChildText("name");
            if (album.artist == null) {
                album.artist = element.getChildText("artist");
            }
        }
        if (element.hasChild("releasedate")) {
            try {
                album.releaseDate = RELEASE_DATE_FORMAT.parse(element.getChildText("releasedate"));
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (element.hasChild("toptags")) {
            for (DomElement o : element.getChild("toptags").getChildren("tag")) {
                album.tags.add(o.getChildText("name"));
            }
        }
        return album;
    }
}

