/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import net.roarsoftware.lastfm.Artist;
import net.roarsoftware.lastfm.Caller;
import net.roarsoftware.lastfm.Event;
import net.roarsoftware.lastfm.PaginatedResult;
import net.roarsoftware.lastfm.Result;
import net.roarsoftware.lastfm.Track;
import net.roarsoftware.xml.DomElement;

public class Geo {
    private Geo() {
    }

    public static Collection<Event> getAllEvents(String location, String distance, String apiKey) {
        int total;
        ArrayList<Event> events = null;
        int page = 1;
        do {
            PaginatedResult<Event> result = Geo.getEvents(location, distance, page, apiKey);
            total = result.getTotalPages();
            Collection<Event> pageResults = result.getPageResults();
            if (events == null) {
                events = new ArrayList<Event>(total * pageResults.size());
            }
            for (Event artist : pageResults) {
                events.add(artist);
            }
        } while (++page <= total);
        return events;
    }

    public static PaginatedResult<Event> getEvents(String location, String distance, String apiKey) {
        return Geo.getEvents(location, distance, 1, apiKey);
    }

    public static PaginatedResult<Event> getEvents(String location, String distance, int page, String apiKey) {
        Result result;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("page", String.valueOf(page));
        if (location != null) {
            params.put("location", location);
        }
        if (distance != null) {
            params.put("distance", distance);
        }
        if (!(result = Caller.getInstance().call("geo.getEvents", apiKey, params)).isSuccessful()) {
            return new PaginatedResult<Event>(0, 0, Collections.emptyList());
        }
        DomElement element = result.getContentElement();
        ArrayList<Event> events = new ArrayList<Event>();
        for (DomElement domElement : element.getChildren("event")) {
            events.add(Event.eventFromElement(domElement));
        }
        int currentPage = Integer.valueOf(element.getAttribute("page"));
        int totalPages = Integer.valueOf(element.getAttribute("totalpages"));
        return new PaginatedResult<Event>(page, totalPages, events);
    }

    public static PaginatedResult<Event> getEvents(double latitude, double longitude, int page, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("page", String.valueOf(page));
        params.put("lat", String.valueOf(latitude));
        params.put("long", String.valueOf(longitude));
        Result result = Caller.getInstance().call("geo.getEvents", apiKey, params);
        if (!result.isSuccessful()) {
            return new PaginatedResult<Event>(0, 0, Collections.emptyList());
        }
        DomElement element = result.getContentElement();
        ArrayList<Event> events = new ArrayList<Event>();
        for (DomElement domElement : element.getChildren("event")) {
            events.add(Event.eventFromElement(domElement));
        }
        int currentPage = Integer.valueOf(element.getAttribute("page"));
        int totalPages = Integer.valueOf(element.getAttribute("totalpages"));
        return new PaginatedResult<Event>(page, totalPages, events);
    }

    public static Collection<Artist> getTopArtists(String country, String apiKey) {
        Result result = Caller.getInstance().call("geo.getTopArtists", apiKey, "country", country);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        ArrayList<Artist> artists = new ArrayList<Artist>();
        for (DomElement domElement : result.getContentElement().getChildren("artist")) {
            artists.add(Artist.artistFromElement(domElement));
        }
        return artists;
    }

    public static Collection<Track> getTopTracks(String country, String apiKey) {
        Result result = Caller.getInstance().call("geo.getTopTracks", apiKey, "country", country);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        ArrayList<Track> tracks = new ArrayList<Track>();
        for (DomElement domElement : result.getContentElement().getChildren("track")) {
            tracks.add(Track.trackFromElement(domElement));
        }
        return tracks;
    }
}

