/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm;

import net.roarsoftware.xml.DomElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Result {
    private Status status;
    private String errorMessage = null;
    private int errorCode = -1;
    private int httpErrorCode = -1;
    private Document resultDocument;

    public Result(Document resultDocument) {
        this.status = Status.OK;
        this.resultDocument = resultDocument;
    }

    public Result(String errorMessage) {
        this.status = Status.FAILED;
        this.errorMessage = errorMessage;
    }

    static Result createOkResult(Document resultDocument) {
        return new Result(resultDocument);
    }

    static Result createHttpErrorResult(int httpErrorCode, String errorMessage) {
        Result r = new Result(errorMessage);
        r.httpErrorCode = httpErrorCode;
        return r;
    }

    static Result createRestErrorResult(int errorCode, String errorMessage) {
        Result r = new Result(errorMessage);
        r.errorCode = errorCode;
        return r;
    }

    public boolean isSuccessful() {
        return this.status == Status.OK;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getHttpErrorCode() {
        return this.httpErrorCode;
    }

    public Status getStatus() {
        return this.status;
    }

    public Document getResultDocument() {
        return this.resultDocument;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public DomElement getContentElement() {
        if (!this.isSuccessful()) {
            return null;
        }
        return new DomElement((Element)this.resultDocument.getDocumentElement().getElementsByTagName("*").item(0));
    }

    public static enum Status {
        OK,
        FAILED;

    }
}

