/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import net.roarsoftware.lastfm.Album;
import net.roarsoftware.lastfm.Artist;
import net.roarsoftware.lastfm.Caller;
import net.roarsoftware.lastfm.Chart;
import net.roarsoftware.lastfm.Result;
import net.roarsoftware.lastfm.Track;
import net.roarsoftware.xml.DomElement;

public class Tag
implements Comparable<Tag> {
    private String name;
    private String url;
    private int count;

    private Tag() {
    }

    Tag(String name) {
        this.name = name;
    }

    public int getCount() {
        return this.count;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public static long getTagCountSum(Collection<Tag> tags) {
        long total = 0L;
        for (Tag topTag : tags) {
            total += (long)topTag.count;
        }
        return total;
    }

    public static List<Tag> filter(Collection<Tag> tags, double percentage) {
        ArrayList<Tag> tops = new ArrayList<Tag>();
        long total = Tag.getTagCountSum(tags);
        double cutOff = (double)total / 100.0 * percentage;
        for (Tag tag : tags) {
            if (!((double)tag.count > cutOff)) continue;
            tops.add(tag);
        }
        return tops;
    }

    public static Collection<String> getSimilar(String tag, String apiKey) {
        Result result = Caller.getInstance().call("tag.getSimilar", apiKey, "tag", tag);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (DomElement domElement : result.getContentElement().getChildren("tag")) {
            tags.add(domElement.getChildText("name"));
        }
        return tags;
    }

    public static List<Tag> getTopTags(String apiKey) {
        Result result = Caller.getInstance().call("tag.getTopTags", apiKey, new String[0]);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (DomElement domElement : result.getContentElement().getChildren("tag")) {
            tags.add(Tag.tagFromElement(domElement));
        }
        return tags;
    }

    public static Collection<Album> getTopAlbums(String tag, String apiKey) {
        Result result = Caller.getInstance().call("tag.getTopAlbums", apiKey, "tag", tag);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        ArrayList<Album> albums = new ArrayList<Album>();
        for (DomElement domElement : result.getContentElement().getChildren("album")) {
            albums.add(Album.albumFromElement(domElement));
        }
        return albums;
    }

    public static Collection<Track> getTopTracks(String tag, String apiKey) {
        Result result = Caller.getInstance().call("tag.getTopTracks", apiKey, "tag", tag);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        ArrayList<Track> tracks = new ArrayList<Track>();
        for (DomElement domElement : result.getContentElement().getChildren("track")) {
            tracks.add(Track.trackFromElement(domElement));
        }
        return tracks;
    }

    public static Collection<Artist> getTopArtists(String tag, String apiKey) {
        Result result = Caller.getInstance().call("tag.getTopArtists", apiKey, "tag", tag);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        ArrayList<Artist> artists = new ArrayList<Artist>();
        for (DomElement domElement : result.getContentElement().getChildren("artist")) {
            artists.add(Artist.artistFromElement(domElement));
        }
        return artists;
    }

    public static Collection<String> search(String tag, String apiKey) {
        return Tag.search(tag, 30, apiKey);
    }

    public static Collection<String> search(String tag, int limit, String apiKey) {
        Result result = Caller.getInstance().call("tag.search", apiKey, "tag", tag, "limit", String.valueOf(limit));
        ArrayList<String> tags = new ArrayList<String>();
        for (DomElement s : result.getContentElement().getChild("tagmatches").getChildren("tag")) {
            tags.add(s.getChildText("name"));
        }
        return tags;
    }

    public static Chart<Artist> getWeeklyArtistChart(String tag, String apiKey) {
        return Tag.getWeeklyArtistChart(tag, null, null, -1, apiKey);
    }

    public static Chart<Artist> getWeeklyArtistChart(String tag, int limit, String apiKey) {
        return Tag.getWeeklyArtistChart(tag, null, null, limit, apiKey);
    }

    public static Chart<Artist> getWeeklyArtistChart(String tag, String from, String to, int limit, String apiKey) {
        return Chart.getChart("tag.getWeeklyArtistChart", "tag", tag, "artist", from, to, limit, apiKey);
    }

    public static LinkedHashMap<String, String> getWeeklyChartList(String tag, String apiKey) {
        return Chart.getWeeklyChartList("tag", tag, apiKey);
    }

    public static Collection<Chart> getWeeklyChartListAsCharts(String tag, String apiKey) {
        return Chart.getWeeklyChartListAsCharts("tag", tag, apiKey);
    }

    static Tag tagFromElement(DomElement element) {
        Tag t = new Tag(element.getChildText("name"));
        t.url = element.getChildText("url");
        if (element.hasChild("count")) {
            t.count = Integer.parseInt(element.getChildText("count"));
        }
        return t;
    }

    @Override
    public int compareTo(Tag o) {
        return Double.compare(o.getCount(), this.getCount());
    }
}

