/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Pointer;
import org.gstreamer.Structure;
import org.gstreamer.lowlevel.GstCapsAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.NativeObject;
import org.gstreamer.lowlevel.RefCountedObject;

public class Caps
extends RefCountedObject {
    private static final GstCapsAPI gst = GstNative.load(GstCapsAPI.class);

    public static Caps emptyCaps() {
        return new Caps(Caps.initializer(gst.ptr_gst_caps_new_empty()));
    }

    public static Caps anyCaps() {
        return new Caps(Caps.initializer(gst.ptr_gst_caps_new_any()));
    }

    public static Caps fromString(String caps) {
        return new Caps(Caps.initializer(gst.ptr_gst_caps_from_string(caps)));
    }

    public Caps() {
        this(Caps.initializer(gst.ptr_gst_caps_new_empty()));
    }

    public Caps(String caps) {
        this(Caps.initializer(gst.ptr_gst_caps_from_string(caps)));
    }

    public Caps(Caps caps) {
        this(Caps.initializer(gst.ptr_gst_caps_copy(caps)));
    }

    protected static NativeObject.Initializer initializer(Pointer ptr) {
        return new NativeObject.Initializer(ptr, false, true);
    }

    public Caps(NativeObject.Initializer init) {
        super(init);
    }

    public int size() {
        return gst.gst_caps_get_size(this);
    }

    public Caps copy() {
        return gst.gst_caps_copy(this);
    }

    public Caps union(Caps other) {
        return gst.gst_caps_union(this, other);
    }

    public Caps intersect(Caps other) {
        return gst.gst_caps_intersect(this, other);
    }

    public Caps subtract(Caps subtrahend) {
        return gst.gst_caps_subtract(this, subtrahend);
    }

    public Caps normalize() {
        return gst.gst_caps_normalize(this);
    }

    public boolean simplify() {
        return gst.gst_caps_do_simplify(this);
    }

    public void append(Caps caps) {
        gst.gst_caps_append(this, caps);
    }

    public void append(Structure struct) {
        gst.gst_caps_append_structure(this, struct);
    }

    public void removeStructure(int index) {
        gst.gst_caps_remove_structure(this, index);
    }

    public void merge(Caps other) {
        gst.gst_caps_merge(this, other);
    }

    public void merge(Structure structure) {
        gst.gst_caps_merge_structure(this, structure);
    }

    public Caps makeWritable() {
        return gst.gst_caps_make_writable(this);
    }

    public void setInteger(String field, Integer value) {
        gst.gst_caps_set_simple(this, field, value, null);
    }

    public Structure getStructure(int index) {
        return gst.gst_caps_get_structure(this, index);
    }

    public void truncate() {
        gst.gst_caps_truncate(this);
    }

    public String toString() {
        return gst.gst_caps_to_string(this);
    }

    public boolean isAny() {
        return gst.gst_caps_is_any(this);
    }

    public boolean isEmpty() {
        return gst.gst_caps_is_empty(this);
    }

    public boolean isFixed() {
        return gst.gst_caps_is_fixed(this);
    }

    public boolean isEqual(Caps other) {
        return gst.gst_caps_is_equal(this, other);
    }

    public boolean isEqualFixed(Caps other) {
        return gst.gst_caps_is_equal_fixed(this, other);
    }

    public boolean isSubset(Caps superset) {
        return gst.gst_caps_is_subset(this, superset);
    }

    public boolean isAlwaysCompatible(Caps other) {
        return gst.gst_caps_is_always_compatible(this, other);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Caps)) {
            return false;
        }
        return other == this || this.isEqual((Caps)other);
    }

    protected void ref() {
        gst.gst_caps_ref(this);
    }

    protected void unref() {
        gst.gst_caps_unref(this);
    }

    protected void disposeNativeHandle(Pointer ptr) {
        gst.gst_caps_unref(ptr);
    }
}

