/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Library;
import java.util.ArrayList;
import java.util.List;
import org.gstreamer.lowlevel.GstNative;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueryType
implements Comparable<QueryType> {
    private static int queryMax = 0;
    private static final List<QueryType> cache = new ArrayList<QueryType>();
    private static final API gst = GstNative.load(API.class);
    public static final QueryType NONE = QueryType.init();
    public static final QueryType POSITION = QueryType.init();
    public static final QueryType DURATION = QueryType.init();
    public static final QueryType LATENCY = QueryType.init();
    public static final QueryType JITTER = QueryType.init();
    public static final QueryType RATE = QueryType.init();
    public static final QueryType SEEKING = QueryType.init();
    public static final QueryType SEGMENT = QueryType.init();
    public static final QueryType CONVERT = QueryType.init();
    public static final QueryType FORMATS = QueryType.init();
    private final Integer value;

    private static final QueryType init() {
        QueryType type = new QueryType(queryMax++);
        cache.add(type.value, type);
        return type;
    }

    public static QueryType valueOf(int value) {
        if (value >= 0 && value < cache.size()) {
            return cache.get(value);
        }
        return new QueryType(value);
    }

    public static QueryType fromNick(String nick) {
        return gst.gst_query_type_get_by_nick(nick);
    }

    private QueryType(int value) {
        this.value = value;
    }

    public int intValue() {
        return this.value;
    }

    public String getName() {
        return gst.gst_query_type_get_name(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof QueryType && ((QueryType)obj).value.equals(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(QueryType queryType) {
        return this.value.compareTo(queryType.value);
    }

    private static interface API
    extends Library {
        public String gst_query_type_get_name(QueryType var1);

        public QueryType gst_query_type_get_by_nick(String var1);
    }
}

