/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.elements;

import com.sun.jna.Pointer;
import java.io.File;
import java.util.LinkedList;
import java.util.concurrent.ScheduledExecutorService;
import org.gstreamer.Bin;
import org.gstreamer.Buffer;
import org.gstreamer.Caps;
import org.gstreamer.ClockTime;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.State;
import org.gstreamer.elements.AppSrc;
import org.gstreamer.lowlevel.GstBinAPI;
import org.gstreamer.lowlevel.GstNative;

public class RGBDataFileSink
extends Bin {
    private static final GstBinAPI gst = GstNative.load(GstBinAPI.class);
    private final LinkedList<Buffer> bufferList = new LinkedList();
    private final AppSrc source;
    private final Caps videoCaps;
    private final AppSrcNeedDataListener needDataListener;
    private final AppSrcEnoughDataListener enoughDataListener;
    private final BufferDispatcher bufferDispatcher;
    private final int FPS;
    private final int NANOS_PER_FRAME;
    private final int sourceWidth;
    private final int sourceHeight;
    private boolean sendingData;
    private int frameCount;
    private int QUEUED_FRAMES = 30;
    private ScheduledExecutorService executor;

    public RGBDataFileSink(String name, int width, int height, int fps, String encoderStr, String[] encoderPropertyNames, Object[] encoderPropertyData, String muxerStr, File file) {
        super(RGBDataFileSink.initializer(gst.ptr_gst_bin_new(name)));
        this.sourceWidth = width;
        this.sourceHeight = height;
        this.FPS = fps;
        this.NANOS_PER_FRAME = (int)(1.0E9 / (double)this.FPS);
        this.videoCaps = Caps.fromString("video/x-raw-rgb,width=" + width + ",height=" + height + "," + "bpp=32,endianness=4321,depth=24,red_mask=65280,green_mask=16711680,blue_mask=-16777216," + "framerate=" + fps + "/1");
        this.source = (AppSrc)ElementFactory.make("appsrc", "source");
        this.source.set("is-live", true);
        this.source.set("format", 3);
        this.source.setCaps(this.videoCaps);
        this.source.setMaxBytes(this.QUEUED_FRAMES * this.sourceWidth * this.sourceHeight * 4);
        this.needDataListener = new AppSrcNeedDataListener();
        this.enoughDataListener = new AppSrcEnoughDataListener();
        this.source.connect(this.needDataListener);
        this.source.connect(this.enoughDataListener);
        this.bufferDispatcher = new BufferDispatcher();
        this.executor = Gst.getScheduledExecutorService();
        Element formatConverter = ElementFactory.make("ffmpegcolorspace", "formatConverter");
        Element formatFilter = ElementFactory.make("capsfilter", "formatFilter");
        Caps capsFormat = Caps.fromString("video/x-raw-yuv,format=(fourcc)I420,width=" + width + ",height=" + height);
        formatFilter.setCaps(capsFormat);
        Element encoder = ElementFactory.make(encoderStr, "encoder");
        if (encoderPropertyNames != null && encoderPropertyData != null) {
            int n0 = encoderPropertyNames.length;
            int n1 = encoderPropertyData.length;
            int n = n0 < n1 ? n0 : n1;
            for (int i = 0; i < n; ++i) {
                encoder.set(encoderPropertyNames[i], encoderPropertyData[i]);
            }
        }
        Element muxer = ElementFactory.make(muxerStr, "muxer");
        Element sink = ElementFactory.make("filesink", "sink");
        sink.set("location", file.toString());
        this.addMany(this.source, formatConverter, formatFilter, encoder, muxer, sink);
        Element.linkMany(this.source, formatConverter, formatFilter, encoder, muxer, sink);
        this.sendingData = false;
    }

    public void pushRGBFrame(Buffer buf) {
        this.addBuffer(buf);
        this.executor.execute(this.bufferDispatcher);
    }

    public void start() {
        this.frameCount = 0;
        this.setState(State.PLAYING);
    }

    public void stop() {
        this.setState(State.PAUSED);
        this.source.endOfStream();
    }

    public void setQueueSize(int nFrames) {
        this.QUEUED_FRAMES = nFrames;
        this.source.setMaxBytes(this.QUEUED_FRAMES * this.sourceWidth * this.sourceHeight * 4);
    }

    public int getQueueSize() {
        return this.QUEUED_FRAMES;
    }

    public int getNumQueuedFrames() {
        return this.bufferList.size();
    }

    private void addBuffer(Buffer buf) {
        this.bufferList.add(buf);
    }

    private void pushBuffer() {
        if (this.sendingData && 0 < this.bufferList.size()) {
            Buffer buf = this.bufferList.remove(0);
            ++this.frameCount;
            long f = this.frameCount * this.NANOS_PER_FRAME;
            buf.setCaps(this.videoCaps);
            buf.setTimestamp(ClockTime.fromNanos(f));
            buf.setDuration(ClockTime.fromNanos(this.NANOS_PER_FRAME));
            this.source.pushBuffer(buf);
            buf.dispose();
        }
    }

    class BufferDispatcher
    implements Runnable {
        BufferDispatcher() {
        }

        public void run() {
            RGBDataFileSink.this.pushBuffer();
        }
    }

    class AppSrcEnoughDataListener
    implements AppSrc.ENOUGH_DATA {
        AppSrcEnoughDataListener() {
        }

        public void enoughData(Element elem, Pointer userData) {
            if (RGBDataFileSink.this.sendingData) {
                RGBDataFileSink.this.sendingData = false;
                RGBDataFileSink.this.source.connect(RGBDataFileSink.this.needDataListener);
                RGBDataFileSink.this.source.disconnect(RGBDataFileSink.this.enoughDataListener);
            }
        }
    }

    class AppSrcNeedDataListener
    implements AppSrc.NEED_DATA {
        AppSrcNeedDataListener() {
        }

        public void needData(Element elem, int size, Pointer userData) {
            if (!RGBDataFileSink.this.sendingData) {
                RGBDataFileSink.this.sendingData = true;
                RGBDataFileSink.this.source.disconnect(RGBDataFileSink.this.needDataListener);
                RGBDataFileSink.this.source.connect(RGBDataFileSink.this.enoughDataListener);
            }
        }
    }
}

