/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.example;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.gstreamer.Buffer;
import org.gstreamer.Caps;
import org.gstreamer.Closure;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.Pad;
import org.gstreamer.Pipeline;
import org.gstreamer.State;
import org.gstreamer.TagList;
import org.gstreamer.swing.VideoComponent;

public class FakeSrcTest {
    private static Pipeline pipeline;
    static TagList tags;

    public static void main(String[] args) {
        args = Gst.init("FakeSrcTest", args);
        int width = 320;
        int height = 200;
        pipeline = new Pipeline("pipeline");
        final Element fakesrc = ElementFactory.make("fakesrc", "source");
        final Element srcfilter = ElementFactory.make("capsfilter", "srcfilter");
        Caps fltcaps = new Caps("video/x-raw-rgb, framerate=2/1, width=320, height=200, bpp=16, depth=16");
        srcfilter.setCaps(fltcaps);
        final Element videorate = ElementFactory.make("videorate", "videorate");
        final Element ratefilter = ElementFactory.make("capsfilter", "RateFilter");
        ratefilter.setCaps(Caps.fromString("video/x-raw-rgb, framerate=2/1"));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame("FakeSrcTest");
                VideoComponent panel = new VideoComponent();
                panel.setPreferredSize(new Dimension(320, 200));
                frame.add((Component)panel, "Center");
                Element videosink = panel.getElement();
                pipeline.addMany(fakesrc, srcfilter, videorate, ratefilter, videosink);
                Element.linkMany(fakesrc, srcfilter, videorate, ratefilter, videosink);
                fakesrc.set("signal-handoffs", true);
                fakesrc.set("sizemax", 128000);
                fakesrc.set("sizetype", 2);
                fakesrc.set("sync", true);
                fakesrc.set("is-live", true);
                fakesrc.set("filltype", 1);
                fakesrc.connect(new Element.HANDOFF(){
                    byte color = 0;
                    byte[] data = new byte[128000];

                    public void handoff(Element element, Buffer buffer, Pad pad) {
                        System.out.println("HANDOFF: Element=" + element.getNativeAddress() + " buffer=" + buffer.getNativeAddress() + " pad=" + pad.getNativeAddress());
                        byte by = this.color;
                        this.color = (byte)(by + 1);
                        Arrays.fill(this.data, by);
                        buffer.getByteBuffer().put(this.data, 0, this.data.length);
                    }
                });
                fakesrc.connect("handoff", new Closure(){

                    public void invoke(Element element, Buffer buffer, Pad pad) {
                        System.out.println("Closure: Element=" + element.getNativeAddress() + " buffer=" + buffer.getNativeAddress() + " pad=" + pad.getNativeAddress());
                    }
                });
                frame.setSize(640, 480);
                frame.pack();
                frame.setDefaultCloseOperation(3);
                frame.setVisible(true);
                pipeline.setState(State.PLAYING);
            }
        });
    }
}

