/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp3;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.mp3.MPEGFrameHeader;
import org.jaudiotagger.audio.mp3.VbriFrame;
import org.jaudiotagger.audio.mp3.XingFrame;
import org.jaudiotagger.logging.Hex;

public class MP3AudioHeader
implements AudioHeader {
    protected MPEGFrameHeader mp3FrameHeader;
    protected XingFrame mp3XingFrame;
    protected VbriFrame mp3VbriFrame;
    private long fileSize;
    private long startByte;
    private double timePerFrame;
    private double trackLength;
    private long numberOfFrames;
    private long numberOfFramesEstimate;
    private long bitrate;
    private String encoder = "";
    private static final SimpleDateFormat timeInFormat = new SimpleDateFormat("ss", Locale.UK);
    private static final SimpleDateFormat timeOutFormat = new SimpleDateFormat("mm:ss", Locale.UK);
    private static final SimpleDateFormat timeOutOverAnHourFormat = new SimpleDateFormat("kk:mm:ss", Locale.UK);
    private static final char isVbrIdentifier = '~';
    private static final int CONVERT_TO_KILOBITS = 1000;
    private static final String TYPE_MP3 = "mp3";
    private static final int CONVERTS_BYTE_TO_BITS = 8;
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.mp3");
    private static final int FILE_BUFFER_SIZE = 5000;
    private static final int MIN_BUFFER_REMAINING_REQUIRED = 196;
    private static final int NO_SECONDS_IN_HOUR = 3600;

    public MP3AudioHeader() {
    }

    public MP3AudioHeader(File seekFile) throws IOException, InvalidAudioFrameException {
        if (!this.seek(seekFile, 0L)) {
            throw new InvalidAudioFrameException("No audio header found within" + seekFile.getName());
        }
    }

    public MP3AudioHeader(File seekFile, long startByte) throws IOException, InvalidAudioFrameException {
        if (!this.seek(seekFile, startByte)) {
            throw new InvalidAudioFrameException("No audio header found within" + seekFile.getName());
        }
    }

    public boolean seek(File seekFile, long startByte) throws IOException {
        FileInputStream fis = new FileInputStream(seekFile);
        FileChannel fc = fis.getChannel();
        ByteBuffer bb = ByteBuffer.allocateDirect(5000);
        fc.position(startByte);
        long filePointerCount = startByte;
        fc.read(bb, startByte);
        bb.flip();
        boolean syncFound = false;
        try {
            do {
                block27: {
                    if (bb.remaining() <= 196) {
                        bb.clear();
                        fc.position(filePointerCount);
                        fc.read(bb, fc.position());
                        bb.flip();
                        if (bb.limit() <= 196) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    if (MPEGFrameHeader.isMPEGFrame(bb)) {
                        try {
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.finest("Found Possible header at:" + filePointerCount);
                            }
                            this.mp3FrameHeader = MPEGFrameHeader.parseMPEGHeader(bb);
                            syncFound = true;
                            if (XingFrame.isXingFrame(bb, this.mp3FrameHeader)) {
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.finest("Found Possible XingHeader");
                                }
                                try {
                                    this.mp3XingFrame = XingFrame.parseXingFrame();
                                }
                                catch (InvalidAudioFrameException ex) {}
                                break;
                            }
                            if (VbriFrame.isVbriFrame(bb, this.mp3FrameHeader)) {
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.finest("Found Possible VbriHeader");
                                }
                                try {
                                    this.mp3VbriFrame = VbriFrame.parseVBRIFrame();
                                }
                                catch (InvalidAudioFrameException ex) {}
                                break;
                            }
                            syncFound = this.isNextFrameValid(seekFile, filePointerCount, bb, fc);
                            if (!syncFound) break block27;
                            break;
                        }
                        catch (InvalidAudioFrameException ex) {
                            // empty catch block
                        }
                    }
                }
                bb.position(bb.position() + 1);
                ++filePointerCount;
            } while (!syncFound);
        }
        catch (EOFException ex) {
            logger.log(Level.WARNING, "Reached end of file without finding sync match", ex);
            syncFound = false;
        }
        catch (IOException iox) {
            logger.log(Level.SEVERE, "IOException occurred whilst trying to find sync", iox);
            syncFound = false;
            throw iox;
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finer("Return found matching mp3 header starting at" + filePointerCount);
        }
        this.setFileSize(seekFile.length());
        this.setMp3StartByte(filePointerCount);
        this.setTimePerFrame();
        this.setNumberOfFrames();
        this.setTrackLength();
        this.setBitRate();
        this.setEncoder();
        return syncFound;
    }

    private boolean isNextFrameValid(File seekFile, long filePointerCount, ByteBuffer bb, FileChannel fc) throws IOException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finer("Checking next frame" + seekFile.getName() + ":fpc:" + filePointerCount + "skipping to:" + (filePointerCount + (long)this.mp3FrameHeader.getFrameLength()));
        }
        boolean result = false;
        int currentPosition = bb.position();
        if (this.mp3FrameHeader.getFrameLength() > 4804) {
            logger.finer("Frame size is too large to be a frame:" + this.mp3FrameHeader.getFrameLength());
            return false;
        }
        if (bb.remaining() <= 196 + this.mp3FrameHeader.getFrameLength()) {
            logger.finer("Buffer too small, need to reload, buffer size:" + bb.remaining());
            bb.clear();
            fc.position(filePointerCount);
            fc.read(bb, fc.position());
            bb.flip();
            currentPosition = 0;
            if (bb.limit() <= 196) {
                logger.finer("Nearly at end of file, no header found:");
                return false;
            }
            if (bb.limit() <= 196 + this.mp3FrameHeader.getFrameLength()) {
                logger.finer("Nearly at end of file, no room for next frame, no header found:");
                return false;
            }
        }
        bb.position(bb.position() + this.mp3FrameHeader.getFrameLength());
        if (MPEGFrameHeader.isMPEGFrame(bb)) {
            try {
                MPEGFrameHeader.parseMPEGHeader(bb);
                logger.finer("Check next frame confirms is an audio header ");
                result = true;
            }
            catch (InvalidAudioFrameException ex) {
                logger.finer("Check next frame has identified this is not an audio header");
                result = false;
            }
        } else {
            logger.finer("isMPEGFrame has identified this is not an audio header");
        }
        bb.position(currentPosition);
        return result;
    }

    protected void setMp3StartByte(long startByte) {
        this.startByte = startByte;
    }

    public long getMp3StartByte() {
        return this.startByte;
    }

    protected void setNumberOfFrames() {
        this.numberOfFramesEstimate = (this.fileSize - this.startByte) / (long)this.mp3FrameHeader.getFrameLength();
        this.numberOfFrames = this.mp3XingFrame != null && this.mp3XingFrame.isFrameCountEnabled() ? (long)this.mp3XingFrame.getFrameCount() : (this.mp3VbriFrame != null ? (long)this.mp3VbriFrame.getFrameCount() : this.numberOfFramesEstimate);
    }

    public long getNumberOfFrames() {
        return this.numberOfFrames;
    }

    public long getNumberOfFramesEstimate() {
        return this.numberOfFramesEstimate;
    }

    protected void setTimePerFrame() {
        this.timePerFrame = (double)this.mp3FrameHeader.getNoOfSamples() / this.mp3FrameHeader.getSamplingRate().doubleValue();
        if (!(this.mp3FrameHeader.getVersion() != 2 && this.mp3FrameHeader.getVersion() != 0 || this.mp3FrameHeader.getLayer() != 2 && this.mp3FrameHeader.getLayer() != 1 || this.mp3FrameHeader.getNumberOfChannels() != 1)) {
            this.timePerFrame /= 2.0;
        }
    }

    private double getTimePerFrame() {
        return this.timePerFrame;
    }

    protected void setTrackLength() {
        this.trackLength = (double)this.numberOfFrames * this.getTimePerFrame();
    }

    public double getPreciseTrackLength() {
        return this.trackLength;
    }

    public int getTrackLength() {
        return (int)this.getPreciseTrackLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTrackLengthAsString() {
        try {
            Date timeIn;
            long lengthInSecs = this.getTrackLength();
            SimpleDateFormat simpleDateFormat = timeInFormat;
            synchronized (simpleDateFormat) {
                timeIn = timeInFormat.parse(String.valueOf(lengthInSecs));
            }
            if (lengthInSecs < 3600L) {
                simpleDateFormat = timeOutFormat;
                synchronized (simpleDateFormat) {
                    return timeOutFormat.format(timeIn);
                }
            }
            simpleDateFormat = timeOutOverAnHourFormat;
            synchronized (simpleDateFormat) {
                return timeOutOverAnHourFormat.format(timeIn);
            }
        }
        catch (ParseException pe) {
            logger.warning("Unable to parse:" + this.getPreciseTrackLength() + " failed with ParseException:" + pe.getMessage());
            return "";
        }
    }

    public String getEncodingType() {
        return TYPE_MP3;
    }

    protected void setBitRate() {
        this.bitrate = this.mp3XingFrame != null && this.mp3XingFrame.isVbr() ? (this.mp3XingFrame.isAudioSizeEnabled() && this.mp3XingFrame.getAudioSize() > 0 ? (long)((double)(this.mp3XingFrame.getAudioSize() * 8) / (this.timePerFrame * (double)this.getNumberOfFrames() * 1000.0)) : (long)((double)((this.fileSize - this.startByte) * 8L) / (this.timePerFrame * (double)this.getNumberOfFrames() * 1000.0))) : (this.mp3VbriFrame != null ? (this.mp3VbriFrame.getAudioSize() > 0 ? (long)((double)(this.mp3VbriFrame.getAudioSize() * 8) / (this.timePerFrame * (double)this.getNumberOfFrames() * 1000.0)) : (long)((double)((this.fileSize - this.startByte) * 8L) / (this.timePerFrame * (double)this.getNumberOfFrames() * 1000.0))) : (long)this.mp3FrameHeader.getBitRate().intValue());
    }

    protected void setEncoder() {
        if (this.mp3XingFrame != null) {
            if (this.mp3XingFrame.getLameFrame() != null) {
                this.encoder = this.mp3XingFrame.getLameFrame().getEncoder();
            }
        } else if (this.mp3VbriFrame != null) {
            this.encoder = this.mp3VbriFrame.getEncoder();
        }
    }

    public long getBitRateAsNumber() {
        return this.bitrate;
    }

    public String getBitRate() {
        if (this.mp3XingFrame != null && this.mp3XingFrame.isVbr()) {
            return '~' + String.valueOf(this.bitrate);
        }
        if (this.mp3VbriFrame != null) {
            return '~' + String.valueOf(this.bitrate);
        }
        return String.valueOf(this.bitrate);
    }

    public int getSampleRateAsNumber() {
        return this.mp3FrameHeader.getSamplingRate();
    }

    public String getSampleRate() {
        return String.valueOf(this.mp3FrameHeader.getSamplingRate());
    }

    public String getMpegVersion() {
        return this.mp3FrameHeader.getVersionAsString();
    }

    public String getMpegLayer() {
        return this.mp3FrameHeader.getLayerAsString();
    }

    public String getFormat() {
        return this.mp3FrameHeader.getVersionAsString() + " " + this.mp3FrameHeader.getLayerAsString();
    }

    public String getChannels() {
        return this.mp3FrameHeader.getChannelModeAsString();
    }

    public String getEmphasis() {
        return this.mp3FrameHeader.getEmphasisAsString();
    }

    public boolean isVariableBitRate() {
        if (this.mp3XingFrame != null) {
            return this.mp3XingFrame.isVbr();
        }
        if (this.mp3VbriFrame != null) {
            return this.mp3VbriFrame.isVbr();
        }
        return this.mp3FrameHeader.isVariableBitRate();
    }

    public boolean isProtected() {
        return this.mp3FrameHeader.isProtected();
    }

    public boolean isPrivate() {
        return this.mp3FrameHeader.isPrivate();
    }

    public boolean isCopyrighted() {
        return this.mp3FrameHeader.isCopyrighted();
    }

    public boolean isOriginal() {
        return this.mp3FrameHeader.isOriginal();
    }

    public boolean isPadding() {
        return this.mp3FrameHeader.isPadding();
    }

    public String getEncoder() {
        return this.encoder;
    }

    protected void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String toString() {
        String s = "fileSize:" + this.fileSize + " encoder:" + this.encoder + " startByte:" + Hex.asHex(this.startByte) + " numberOfFrames:" + this.numberOfFrames + " numberOfFramesEst:" + this.numberOfFramesEstimate + " timePerFrame:" + this.timePerFrame + " bitrate:" + this.bitrate + " trackLength:" + this.getTrackLengthAsString();
        if (this.mp3FrameHeader != null) {
            s = s + this.mp3FrameHeader.toString();
        }
        if (this.mp3XingFrame != null) {
            s = s + this.mp3XingFrame.toString();
        }
        return s;
    }
}

