/*
 * Decompiled with CFR 0.152.
 */
package com.melloware.jintellitype;

import com.melloware.jintellitype.HotkeyListener;
import com.melloware.jintellitype.IntellitypeListener;
import com.melloware.jintellitype.JIntellitypeConstants;
import com.melloware.jintellitype.JIntellitypeException;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;

public final class JIntellitype
implements JIntellitypeConstants {
    private static JIntellitype jintellitype = null;
    private static boolean isInitialized = false;
    private static String libraryLocation = null;
    private final List<HotkeyListener> hotkeyListeners = Collections.synchronizedList(new CopyOnWriteArrayList());
    private final List<IntellitypeListener> intellitypeListeners = Collections.synchronizedList(new CopyOnWriteArrayList());
    private int handler = 0;

    private JIntellitype() {
        try {
            if (JIntellitype.getLibraryLocation() != null) {
                System.load(JIntellitype.getLibraryLocation());
            } else {
                System.loadLibrary("JIntellitype");
            }
            this.initializeLibrary();
        }
        catch (UnsatisfiedLinkError ex) {
            throw new JIntellitypeException(ex);
        }
        catch (RuntimeException ex) {
            throw new JIntellitypeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JIntellitype getInstance() {
        if (isInitialized) return jintellitype;
        Class<JIntellitype> clazz = JIntellitype.class;
        synchronized (JIntellitype.class) {
            if (isInitialized) return jintellitype;
            jintellitype = new JIntellitype();
            isInitialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return jintellitype;
        }
    }

    public void addHotKeyListener(HotkeyListener listener) {
        this.hotkeyListeners.add(listener);
    }

    public void addIntellitypeListener(IntellitypeListener listener) {
        this.intellitypeListeners.add(listener);
    }

    public void cleanUp() {
        try {
            this.terminate();
        }
        catch (UnsatisfiedLinkError ex) {
            throw new JIntellitypeException("JIntellitype DLL Error", ex);
        }
        catch (RuntimeException ex) {
            throw new JIntellitypeException(ex);
        }
    }

    public void registerHotKey(int identifier, int modifier, int keycode) {
        try {
            int modifiers = JIntellitype.swingToIntelliType(modifier);
            if (modifiers == 0) {
                modifiers = modifier;
            }
            this.regHotKey(identifier, modifier, keycode);
        }
        catch (UnsatisfiedLinkError ex) {
            throw new JIntellitypeException("JIntellitype DLL Error", ex);
        }
        catch (RuntimeException ex) {
            throw new JIntellitypeException(ex);
        }
    }

    public void registerSwingHotKey(int identifier, int modifier, int keycode) {
        try {
            this.regHotKey(identifier, JIntellitype.swingToIntelliType(modifier), keycode);
        }
        catch (UnsatisfiedLinkError ex) {
            throw new JIntellitypeException("JIntellitype DLL Error", ex);
        }
        catch (RuntimeException ex) {
            throw new JIntellitypeException(ex);
        }
    }

    public void registerHotKey(int identifier, String modifierAndKeyCode) {
        String[] split = modifierAndKeyCode.split("\\+");
        int mask = 0;
        for (int i = 0; i < split.length - 1; ++i) {
            if ("ALT".equalsIgnoreCase(split[i])) {
                ++mask;
                continue;
            }
            if ("CTRL".equalsIgnoreCase(split[i]) || "CONTROL".equalsIgnoreCase(split[i])) {
                mask += 2;
                continue;
            }
            if ("SHIFT".equalsIgnoreCase(split[i])) {
                mask += 4;
                continue;
            }
            if (!"WIN".equalsIgnoreCase(split[i])) continue;
            mask += 8;
        }
        this.registerHotKey(identifier, mask, split[split.length - 1].charAt(0));
    }

    public void removeHotKeyListener(HotkeyListener listener) {
        this.hotkeyListeners.remove(listener);
    }

    public void removeIntellitypeListener(IntellitypeListener listener) {
        this.intellitypeListeners.remove(listener);
    }

    public void unregisterHotKey(int identifier) {
        try {
            this.unregHotKey(identifier);
        }
        catch (UnsatisfiedLinkError ex) {
            throw new JIntellitypeException("JIntellitype DLL Error", ex);
        }
        catch (RuntimeException ex) {
            throw new JIntellitypeException(ex);
        }
    }

    public static boolean checkInstanceAlreadyRunning(String appTitle) {
        return JIntellitype.getInstance().isRunning(appTitle);
    }

    public static boolean isJIntellitypeSupported() {
        boolean result = false;
        String os = "none";
        String architecture = "none";
        try {
            os = System.getProperty("os.name").toLowerCase();
            architecture = System.getProperty("sun.arch.data.model").toLowerCase();
        }
        catch (SecurityException ex) {
            System.err.println("Caught a SecurityException reading the system property 'os.name'; the SystemUtils property value will default to null.");
        }
        if (os.startsWith("windows")) {
            try {
                JIntellitype.getInstance();
                result = true;
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }

    public static String getLibraryLocation() {
        return libraryLocation;
    }

    public static void setLibraryLocation(String libraryLocation) {
        File dll = new File(libraryLocation);
        JIntellitype.libraryLocation = !dll.isAbsolute() ? dll.getAbsolutePath() : libraryLocation;
    }

    protected void onHotKey(final int identifier) {
        for (final HotkeyListener hotkeyListener : this.hotkeyListeners) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    hotkeyListener.onHotKey(identifier);
                }
            });
        }
    }

    protected void onIntellitype(final int command) {
        for (final IntellitypeListener intellitypeListener : this.intellitypeListeners) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    intellitypeListener.onIntellitype(command);
                }
            });
        }
    }

    protected static int swingToIntelliType(int swingKeystrokeModifier) {
        int mask = 0;
        if ((swingKeystrokeModifier & 1) == 1) {
            mask += 4;
        }
        if ((swingKeystrokeModifier & 8) == 8) {
            ++mask;
        }
        if ((swingKeystrokeModifier & 2) == 2) {
            mask += 2;
        }
        if ((swingKeystrokeModifier & 0x40) == 64) {
            mask += 4;
        }
        if ((swingKeystrokeModifier & 0x200) == 512) {
            ++mask;
        }
        if ((swingKeystrokeModifier & 0x80) == 128) {
            mask += 2;
        }
        return mask;
    }

    private synchronized native void initializeLibrary() throws UnsatisfiedLinkError;

    private synchronized native void regHotKey(int var1, int var2, int var3) throws UnsatisfiedLinkError;

    private synchronized native void terminate() throws UnsatisfiedLinkError;

    private synchronized native void unregHotKey(int var1) throws UnsatisfiedLinkError;

    private synchronized native boolean isRunning(String var1);
}

