/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ProxyInputStream;

public class BOMExclusionInputStream
extends ProxyInputStream {
    private int[] firstBytes;
    private int fbLength;
    private int fbIndex;
    private boolean markedAtStart;

    public BOMExclusionInputStream(InputStream delegate) {
        super(delegate);
    }

    private int readFirstBytes() throws IOException {
        if (this.firstBytes == null) {
            this.firstBytes = new int[3];
            int b0 = this.in.read();
            if (b0 < 0 || b0 != 239) {
                return b0;
            }
            int b1 = this.in.read();
            int b2 = this.in.read();
            if (b1 == 187 && b2 == 191) {
                return this.in.read();
            }
            this.firstBytes[this.fbLength++] = b0;
            this.firstBytes[this.fbLength++] = b1;
            this.firstBytes[this.fbLength++] = b2;
        }
        return this.fbIndex < this.fbLength ? this.firstBytes[this.fbIndex++] : -1;
    }

    public int read() throws IOException {
        int b = this.readFirstBytes();
        return b >= 0 ? b : this.in.read();
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int firstCount = 0;
        int b = 0;
        while (len > 0 && b >= 0) {
            b = this.readFirstBytes();
            if (b < 0) continue;
            buf[off++] = (byte)(b & 0xFF);
            --len;
            ++firstCount;
        }
        int secondCount = this.in.read(buf, off, len);
        return secondCount < 0 ? firstCount : firstCount + secondCount;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public synchronized void mark(int readlimit) {
        this.markedAtStart = this.firstBytes == null;
        this.in.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        if (this.markedAtStart) {
            this.firstBytes = null;
        }
        this.in.reset();
    }

    public long skip(long n) throws IOException {
        while (n > 0L && this.readFirstBytes() >= 0) {
            --n;
        }
        return this.in.skip(n);
    }
}

