/*
 * Decompiled with CFR 0.152.
 */
package org.commonjukebox.plugins;

import java.io.File;
import java.io.IOException;
import org.commonjukebox.plugins.exceptions.PluginSystemException;
import org.commonjukebox.plugins.model.PluginInfo;

class PluginActivation {
    PluginActivation() {
    }

    protected static void activatePlugin(PluginInfo info) throws PluginSystemException {
        try {
            PluginActivation.getPluginActivationFlag(info).createNewFile();
            info.setActive(true);
        }
        catch (IOException e) {
            throw new PluginSystemException(e);
        }
    }

    protected static void deactivatePlugin(PluginInfo info) throws PluginSystemException {
        boolean deleted = PluginActivation.getPluginActivationFlag(info).delete();
        if (!deleted) {
            throw new PluginSystemException("Plugin " + info.getName() + " could not be deactivated");
        }
        info.setActive(false);
    }

    protected static boolean isPluginActive(PluginInfo info) {
        return PluginActivation.getPluginActivationFlag(info).exists();
    }

    private static File getPluginActivationFlag(PluginInfo info) {
        return new File(info.getPluginFolder().getAbsolutePath() + System.getProperty("file.separator") + info.getName() + ".activation");
    }
}

