/*
 * Decompiled with CFR 0.152.
 */
package org.commonjukebox.plugins;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.commonjukebox.plugins.PluginActivation;
import org.commonjukebox.plugins.PluginFolderLoader;
import org.commonjukebox.plugins.PluginListeners;
import org.commonjukebox.plugins.PluginSystemLogger;
import org.commonjukebox.plugins.PluginsLoader;
import org.commonjukebox.plugins.ZipUtils;
import org.commonjukebox.plugins.classloader.ClassLoaderManager;
import org.commonjukebox.plugins.exceptions.InvalidPluginConfigurationException;
import org.commonjukebox.plugins.exceptions.PluginSystemException;
import org.commonjukebox.plugins.jar.JarUtils;
import org.commonjukebox.plugins.model.Plugin;
import org.commonjukebox.plugins.model.PluginConfiguration;
import org.commonjukebox.plugins.model.PluginFolder;
import org.commonjukebox.plugins.model.PluginInfo;
import org.commonjukebox.plugins.model.PluginListener;
import org.commonjukebox.plugins.model.PluginRepositoryInformation;

public class PluginsFactory {
    private File pluginRepositoryFile;
    private File temporalPluginRepositoryFile;
    private ClassLoaderManager classLoaderManager;
    private Set<String> pluginTypes;
    private PluginListeners pluginListeners;
    private boolean validatePluginApi;
    private String restrictedPackage;
    private PluginsLoader pluginsLoader;
    private PluginFolderLoader jarLoader;
    private PluginRepositoryInformation pluginRepositoryInformation;

    public void setPluginsRepository(String path) throws PluginSystemException {
        if (path == null) {
            throw new PluginSystemException("Path is null");
        }
        File pluginRepositoryFile = new File(path);
        if (!pluginRepositoryFile.exists()) {
            throw new PluginSystemException("Path does not exist");
        }
        this.setPluginRepositoryFile(pluginRepositoryFile);
        this.setPluginRepositoryInformation(this.readPluginRepositoryInformation(pluginRepositoryFile));
    }

    public void setTemporalPluginRepository(String path) throws PluginSystemException {
        if (path == null) {
            throw new PluginSystemException("Path is null");
        }
        File temporalPluginRepositoryFile = new File(path);
        if (!temporalPluginRepositoryFile.exists()) {
            throw new PluginSystemException("Path does not exist");
        }
        this.setTemporalPluginRepositoryFile(temporalPluginRepositoryFile);
    }

    private PluginRepositoryInformation readPluginRepositoryInformation(File pluginRepositoryFile) throws PluginSystemException {
        File[] filesInPath;
        PluginRepositoryInformation pluginRepositoryInformation = new PluginRepositoryInformation();
        File[] fileArray = filesInPath = pluginRepositoryFile.listFiles();
        int n = filesInPath.length;
        int n2 = 0;
        while (n2 < n) {
            File fileInPath = fileArray[n2];
            if (fileInPath.isDirectory()) {
                List<URI> jars = new JarUtils().getJarsInPath(fileInPath, true);
                if (jars != null && !jars.isEmpty()) {
                    PluginFolder pluginFolder = new PluginFolder(fileInPath.getAbsolutePath());
                    pluginFolder.setJars(jars);
                    pluginRepositoryInformation.addPluginFolder(pluginFolder);
                    PluginSystemLogger.getLogger().fine("Added plugin folder: " + fileInPath.getAbsolutePath());
                }
            } else {
                PluginSystemLogger.getLogger().info("Ignoring file: " + fileInPath);
            }
            ++n2;
        }
        return pluginRepositoryInformation;
    }

    public Map<PluginFolder, PluginSystemException> start(Set<String> pTypes, boolean validatePluginApi, String restrictedPackage) throws PluginSystemException {
        if (this.getPluginRepositoryFile() == null) {
            throw new PluginSystemException("Plugin folder not initialized");
        }
        if (this.getTemporalPluginRepositoryFile() == null) {
            throw new PluginSystemException("Temporal plugin folder not initialized");
        }
        PluginSystemLogger.getLogger().fine("Types: " + pTypes.toString());
        PluginSystemLogger.getLogger().fine("ValidatePluginApi: " + validatePluginApi);
        PluginSystemLogger.getLogger().fine("RestrictedPackage: " + restrictedPackage);
        this.pluginTypes = pTypes;
        this.validatePluginApi = validatePluginApi;
        this.restrictedPackage = restrictedPackage;
        this.validatePluginTypes(pTypes);
        Map<PluginFolder, PluginSystemException> problemsFound = this.getJarLoader().loadPluginFolders(this.getPluginRepositoryInformation(), this.getPluginRepositoryInformation().getPluginFolders().values());
        return problemsFound;
    }

    protected Map<PluginFolder, PluginSystemException> refresh() throws PluginSystemException {
        PluginRepositoryInformation newPluginRepositoryInformation = this.readPluginRepositoryInformation(this.getPluginRepositoryFile());
        List<PluginFolder> newPlugins = newPluginRepositoryInformation.differenceWith(this.getPluginRepositoryInformation());
        List<PluginFolder> removedPlugins = this.getPluginRepositoryInformation().differenceWith(newPluginRepositoryInformation);
        Map<PluginFolder, PluginSystemException> problemsFound = this.getJarLoader().loadPluginFolders(this.getPluginRepositoryInformation(), newPlugins);
        this.getJarLoader().unloadPluginFolders(removedPlugins);
        newPluginRepositoryInformation.setPluginsInfoFrom(this.getPluginRepositoryInformation());
        this.setPluginRepositoryInformation(newPluginRepositoryInformation);
        return problemsFound;
    }

    public Plugin getNewInstance(PluginInfo pluginInfo) throws PluginSystemException {
        try {
            Plugin plugin = (Plugin)this.getClassLoaderManager().loadClass(pluginInfo.getClassName()).newInstance();
            plugin.setPluginInfo(pluginInfo);
            plugin.setConfiguration(this.getConfiguration(pluginInfo));
            pluginInfo.addInstancedObject(plugin);
            PluginSystemLogger.getLogger().fine("Created new instance of plugin: " + pluginInfo.getName());
            return plugin;
        }
        catch (Exception e) {
            throw new PluginSystemException(e);
        }
    }

    private String getConfigurationFile(PluginInfo plugin) {
        return plugin.getPluginFolder().getAbsolutePath() + "/" + plugin.getName() + ".config";
    }

    public PluginConfiguration getConfiguration(PluginInfo plugin) throws PluginSystemException {
        PluginConfiguration config;
        block15: {
            if (plugin == null) {
                return null;
            }
            config = null;
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(new FileInputStream(this.getConfigurationFile(plugin)));
                config = (PluginConfiguration)ois.readObject();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (ois == null) break block15;
                try {
                    ois.close();
                    break block15;
                }
                catch (IOException e) {
                    throw new PluginSystemException(e);
                }
            }
            catch (Exception e) {
                try {
                    throw new PluginSystemException(e);
                }
                catch (Throwable throwable) {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException e2) {
                            throw new PluginSystemException(e2);
                        }
                    }
                    throw throwable;
                }
            }
            if (ois == null) break block15;
            try {
                ois.close();
            }
            catch (IOException e) {
                throw new PluginSystemException(e);
            }
        }
        if (config == null) {
            config = plugin.getDefaultPluginConfiguration();
        }
        return config;
    }

    public void setConfiguration(PluginInfo plugin, PluginConfiguration configuration) throws PluginSystemException {
        for (Plugin instancedObject : plugin.getInstancedObjects()) {
            instancedObject.configurationChanged(configuration);
        }
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.getConfigurationFile(plugin)));
            oos.writeObject(configuration);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            throw new PluginSystemException(e);
        }
    }

    public void addPluginListener(String pluginType, PluginListener listener) {
        this.getPluginListeners().addPluginListener(pluginType, listener);
    }

    public List<PluginInfo> getPlugins() {
        return this.getPluginRepositoryInformation().getPlugins();
    }

    public void activatePlugin(PluginInfo plugin) throws PluginSystemException {
        this.getClassLoaderManager().addToClassLoader(Collections.singleton(plugin.getPluginFolder()));
        PluginActivation.activatePlugin(plugin);
        PluginSystemLogger.getLogger().fine(plugin.getName() + " has been activated");
        this.getPluginListeners().callListenersForActivePlugin(plugin);
    }

    public void deactivatePlugin(PluginInfo plugin) throws PluginSystemException {
        PluginActivation.deactivatePlugin(plugin);
        PluginSystemLogger.getLogger().fine(plugin.getName() + " has been deactivated");
        HashSet<PluginInfo> plugins = new HashSet<PluginInfo>();
        plugins.add(plugin);
        this.getPluginListeners().callListenersForInactivePlugin(plugins);
        this.getClassLoaderManager().removeFromClassLoader(Collections.singleton(plugin.getPluginFolder()));
    }

    protected PluginRepositoryInformation getPluginRepositoryInformation() {
        return this.pluginRepositoryInformation;
    }

    protected void setPluginRepositoryInformation(PluginRepositoryInformation pluginRepositoryInformation) {
        this.pluginRepositoryInformation = pluginRepositoryInformation;
    }

    protected File getPluginRepositoryFile() {
        return this.pluginRepositoryFile;
    }

    protected PluginListeners getPluginListeners() {
        if (this.pluginListeners == null) {
            this.pluginListeners = new PluginListeners();
        }
        return this.pluginListeners;
    }

    protected ClassLoaderManager getClassLoaderManager() {
        if (this.classLoaderManager == null) {
            this.classLoaderManager = new ClassLoaderManager();
        }
        return this.classLoaderManager;
    }

    protected PluginsLoader getPluginsLoader() {
        if (this.pluginsLoader == null) {
            this.pluginsLoader = new PluginsLoader(this.getPluginListeners(), this.isValidatePluginApi(), this.getRestrictedPackage(), this.getPluginTypes());
        }
        return this.pluginsLoader;
    }

    protected PluginFolderLoader getJarLoader() {
        if (this.jarLoader == null) {
            this.jarLoader = new PluginFolderLoader(this.getClassLoaderManager(), this.getPluginsLoader(), this.getPluginListeners());
        }
        return this.jarLoader;
    }

    protected boolean isValidatePluginApi() {
        return this.validatePluginApi;
    }

    protected String getRestrictedPackage() {
        return this.restrictedPackage;
    }

    protected Set<String> getPluginTypes() {
        return this.pluginTypes;
    }

    public Map<PluginFolder, PluginSystemException> installPlugin(File zipFile) throws PluginSystemException {
        Map<PluginFolder, PluginSystemException> problemsFound;
        try {
            try {
                FileUtils.cleanDirectory((File)this.getTemporalPluginRepositoryFile());
                ZipUtils.unzipArchive(zipFile, this.getTemporalPluginRepositoryFile());
                final File[] files = this.getTemporalPluginRepositoryFile().listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                });
                for (PluginInfo currentPlugin : this.getPlugins()) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        if (file.getName().equals(currentPlugin.getPluginFolder().getName())) {
                            this.uninstallPlugin(currentPlugin);
                        }
                        ++n2;
                    }
                }
                File[] repositoryFolder = this.getPluginRepositoryFile().listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isDirectory() && pathname.getName().equals(files[0].getName());
                    }
                });
                if (repositoryFolder.length > 0) {
                    FileUtils.deleteDirectory((File)repositoryFolder[0]);
                }
                ZipUtils.unzipArchive(zipFile, this.getPluginRepositoryFile());
                problemsFound = this.refresh();
                if (problemsFound != null && !problemsFound.isEmpty()) {
                    for (PluginFolder pluginFolder : problemsFound.keySet()) {
                        FileUtils.deleteDirectory((File)pluginFolder);
                    }
                }
            }
            catch (IOException e) {
                throw new PluginSystemException(e);
            }
        }
        finally {
            try {
                FileUtils.cleanDirectory((File)this.getTemporalPluginRepositoryFile());
            }
            catch (IOException e) {
                throw new PluginSystemException(e);
            }
        }
        return problemsFound;
    }

    public Map<PluginFolder, PluginSystemException> uninstallPlugin(PluginInfo plugin) throws PluginSystemException {
        if (plugin.isActive()) {
            this.deactivatePlugin(plugin);
        }
        try {
            FileUtils.deleteDirectory((File)plugin.getPluginFolder());
        }
        catch (IOException e) {
            throw new PluginSystemException(e);
        }
        PluginSystemLogger.getLogger().info("Uninstalled plugin: " + plugin.getName());
        return this.refresh();
    }

    protected void setPluginRepositoryFile(File pluginRepositoryFile) {
        this.pluginRepositoryFile = pluginRepositoryFile;
    }

    protected File getTemporalPluginRepositoryFile() {
        return this.temporalPluginRepositoryFile;
    }

    private void setTemporalPluginRepositoryFile(File temporalPluginRepositoryFile) {
        this.temporalPluginRepositoryFile = temporalPluginRepositoryFile;
    }

    public void validateConfiguration(PluginInfo plugin, PluginConfiguration configuration) throws InvalidPluginConfigurationException {
        for (Plugin instancedObject : plugin.getInstancedObjects()) {
            instancedObject.validateConfiguration(configuration);
        }
    }

    private void validatePluginTypes(Set<String> pluginTypes) throws PluginSystemException {
        if (pluginTypes == null || pluginTypes.isEmpty()) {
            throw new PluginSystemException("No plugin types defined");
        }
        try {
            for (String pluginType : pluginTypes) {
                Class.forName(pluginType);
            }
        }
        catch (ClassNotFoundException e) {
            throw new PluginSystemException(e);
        }
    }

    public void removePluginFolder(PluginFolder pluginFolder) throws PluginSystemException {
        if (this.getPluginRepositoryInformation().containsPluginFolder(pluginFolder)) {
            throw new PluginSystemException("Plugin Folder " + pluginFolder.getName() + " contains a valid plugin. It should be uninstalled first");
        }
        try {
            FileUtils.deleteDirectory((File)pluginFolder);
        }
        catch (IOException e) {
            new PluginSystemException(e);
        }
    }
}

