/*
 * Decompiled with CFR 0.152.
 */
package org.commonjukebox.plugins.jar;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.classes.JarClasses;
import org.apache.maven.shared.jar.classes.JarClassesAnalysis;
import org.commonjukebox.plugins.exceptions.InvalidJarException;
import org.commonjukebox.plugins.exceptions.PluginSystemException;
import org.commonjukebox.plugins.model.PluginApi;
import org.commonjukebox.plugins.model.PluginFolder;

public class JarValidator {
    public void validateJars(PluginFolder pluginFolder, String restrictedPackage) throws PluginSystemException {
        for (URI jar : pluginFolder.getJars()) {
            this.validateJar(jar, restrictedPackage);
        }
    }

    private void validateJar(URI jar, String restrictedPackage) throws PluginSystemException {
        JarAnalyzer jarAnalyzer = null;
        try {
            try {
                jarAnalyzer = new JarAnalyzer(new File(jar));
                JarClassesAnalysis jarClassesAnalysis = new JarClassesAnalysis();
                JarClasses jarClasses = jarClassesAnalysis.analyze(jarAnalyzer);
                List imports = jarClasses.getImports();
                for (String imp : imports) {
                    if (!imp.startsWith(restrictedPackage)) continue;
                    try {
                        Class<?> clazz = Class.forName(imp);
                        boolean present = clazz.isAnnotationPresent(PluginApi.class);
                        if (present) continue;
                        throw new InvalidJarException(jar.toString());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            catch (IOException e) {
                throw new PluginSystemException(e);
            }
        }
        finally {
            jarAnalyzer.closeQuietly();
        }
    }
}

